/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity;

import cd4017be.api.rs_ctr.com.BlockReference;
import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.lib.TickRegistry;
import cd4017be.rs_ctr.tileentity.WallMountGate;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class BlockReorienter
extends WallMountGate
implements BlockReference.BlockHandler,
SignalHandler,
TickRegistry.IUpdatable {
    BlockReference in;
    BlockReference.BlockHandler out;
    int side;
    byte tick;
    boolean delayed;

    public BlockReorienter() {
        this.ports = new MountedPort[]{new MountedPort((IPortProvider)this, 0, BlockReference.BlockHandler.class, false).setName("port.rs_ctr.bi").setLocation(0.25, 0.125, 0.125, EnumFacing.WEST), new MountedPort((IPortProvider)this, 1, SignalHandler.class, false).setName("port.rs_ctr.side").setLocation(0.25, 0.875, 0.125, EnumFacing.WEST), new MountedPort((IPortProvider)this, 2, BlockReference.BlockHandler.class, true).setName("port.rs_ctr.bo").setLocation(0.75, 0.5, 0.125, EnumFacing.EAST)};
    }

    public Object getPortCallback(int pin) {
        return this;
    }

    public void setPortCallback(int pin, Object callback) {
        BlockReference.BlockHandler blockHandler = this.out = callback instanceof BlockReference.BlockHandler ? (BlockReference.BlockHandler)callback : null;
        if (this.out != null) {
            this.out.updateBlock(this.out());
        }
    }

    private BlockReference out() {
        if (this.side < 0 || this.in == null) {
            return this.in;
        }
        return new BlockReference(this.in.dim, this.in.pos, EnumFacing.field_82609_l[this.side], this.in.lifespan);
    }

    @Override
    public Object getState(int pin) {
        switch (pin) {
            case 0: {
                return this.in;
            }
            case 1: {
                return this.side;
            }
            case 2: {
                return this.out();
            }
        }
        return null;
    }

    @Override
    protected void resetPin(int pin) {
        if (pin == 0) {
            this.updateBlock(null);
        } else {
            this.updateSignal(0);
        }
    }

    public void updateBlock(BlockReference ref) {
        if (BlockReference.equalDelayed((BlockReference)ref, (BlockReference)this.in, (int)1)) {
            return;
        }
        this.scheduleUpdate();
        this.in = BlockReference.delayed((BlockReference)ref, (int)1);
    }

    public void updateSignal(int value) {
        if (value < 0 || value >= 6) {
            value = -1;
        }
        if (value == this.side) {
            return;
        }
        this.scheduleUpdate();
        this.side = value;
    }

    private void scheduleUpdate() {
        if (this.tick == 0) {
            this.tick = TickRegistry.TICK;
            TickRegistry.schedule((TickRegistry.IUpdatable)this);
        } else if (this.tick != TickRegistry.TICK) {
            this.tick = TickRegistry.TICK;
            if (this.out != null) {
                this.out.updateBlock(this.out());
            }
            this.delayed = true;
        }
    }

    public void process() {
        if (this.delayed) {
            this.delayed = false;
            TickRegistry.schedule((TickRegistry.IUpdatable)this);
            return;
        }
        this.tick = 0;
        if (this.out != null) {
            this.out.updateBlock(this.out());
        }
    }

    @Override
    protected void storeState(NBTTagCompound nbt, int mode) {
        super.storeState(nbt, mode);
        if (mode == 0) {
            if (this.in != null) {
                nbt.func_74782_a("block", (NBTBase)this.in.serializeNBT());
            }
            nbt.func_74774_a("side", (byte)this.side);
        }
    }

    @Override
    protected void loadState(NBTTagCompound nbt, int mode) {
        super.loadState(nbt, mode);
        if (mode == 0) {
            this.in = nbt.func_150297_b("block", 10) ? new BlockReference(nbt.func_74775_l("block")) : null;
            this.side = nbt.func_74771_c("side");
            if (this.side >= 6) {
                this.side = -1;
            }
        }
    }
}

