/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity;

import cd4017be.api.rs_ctr.com.BlockReference;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.lib.TickRegistry;
import cd4017be.rs_ctr.tileentity.WallMountGate;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;

public class BlockDelayer
extends WallMountGate {
    private final Delay[] channels = new Delay[4];

    public BlockDelayer() {
        this.ports = new MountedPort[8];
        for (int i = 0; i < 4; ++i) {
            this.ports[i] = new MountedPort((IPortProvider)this, i, BlockReference.BlockHandler.class, false).setLocation(0.25, (double)(0.125f + (float)i * 0.25f), 0.125, EnumFacing.WEST).setName("port.rs_ctr.bi");
            this.ports[i + 4] = new MountedPort((IPortProvider)this, i + 4, BlockReference.BlockHandler.class, true).setLocation(0.75, (double)(0.125f + (float)i * 0.25f), 0.125, EnumFacing.EAST).setName("port.rs_ctr.bo");
            this.channels[i] = new Delay();
        }
    }

    public BlockReference.BlockHandler getPortCallback(int pin) {
        return this.channels[pin];
    }

    public void setPortCallback(int pin, Object callback) {
        Delay c = this.channels[pin - 4];
        if (callback instanceof BlockReference.BlockHandler) {
            c.out = (BlockReference.BlockHandler)callback;
            c.out.updateBlock(c.state);
        } else {
            c.out = null;
        }
    }

    @Override
    protected void resetPin(int pin) {
        this.channels[pin].updateBlock(null);
    }

    @Override
    protected void storeState(NBTTagCompound nbt, int mode) {
        if (mode == 0) {
            NBTTagList list = new NBTTagList();
            for (Delay d : this.channels) {
                list.func_74742_a((NBTBase)(d.state != null ? d.state.serializeNBT() : new NBTTagCompound()));
            }
            nbt.func_74782_a("states", (NBTBase)list);
        }
        super.storeState(nbt, mode);
    }

    @Override
    protected void loadState(NBTTagCompound nbt, int mode) {
        super.loadState(nbt, mode);
        if (mode == 0) {
            NBTTagList list = nbt.func_150295_c("states", 10);
            for (int i = 0; i < 4; ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                this.channels[i].state = tag.func_82582_d() ? null : new BlockReference(tag);
            }
        }
    }

    @Override
    public Object getState(int id) {
        return this.channels[id & 3].state;
    }

    static class Delay
    implements BlockReference.BlockHandler,
    TickRegistry.IUpdatable {
        BlockReference.BlockHandler out;
        BlockReference state;
        byte tick;

        Delay() {
        }

        public void updateBlock(BlockReference value) {
            if (BlockReference.equalDelayed((BlockReference)value, (BlockReference)this.state, (int)1)) {
                return;
            }
            if (this.tick == 0) {
                this.tick = TickRegistry.TICK;
                TickRegistry.schedule((TickRegistry.IUpdatable)this);
            } else if (this.tick != TickRegistry.TICK && this.out != null) {
                this.tick = TickRegistry.TICK;
                this.out.updateBlock(this.state);
            }
            this.state = BlockReference.delayed((BlockReference)value, (int)1);
        }

        public void process() {
            if (this.tick == TickRegistry.TICK) {
                TickRegistry.schedule((TickRegistry.IUpdatable)this);
            } else {
                this.tick = 0;
                if (this.out != null) {
                    this.out.updateBlock(this.state);
                }
            }
        }
    }
}

