/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity;

import cd4017be.api.rs_ctr.com.BlockReference;
import cd4017be.api.rs_ctr.com.EnergyHandler;
import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.lib.block.AdvancedBlock;
import cd4017be.lib.tileentity.BaseTileEntity;
import cd4017be.lib.util.Utils;
import cd4017be.rs_ctr.item.ItemBlockBreaker;
import cd4017be.rs_ctr.tileentity.WallMountGate;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockBreaker
extends WallMountGate
implements BaseTileEntity.ITickableServerOnly,
SignalHandler,
BlockReference.BlockHandler,
AdvancedBlock.ITilePlaceHarvest {
    public static float BASE_ENERGY;
    public static float ENERGY_MULT;
    public static float SPEED_MOD;
    public static float NO_TOOL_MULT;
    private static final int S_SUCCESS = 0;
    private static final int S_UNBREAKABLE = -1;
    private static final int S_FULLINV = 1;
    private static final int S_NOENERGY = 2;
    NonNullList<ItemStack> drops = NonNullList.func_191196_a();
    BlockReference block;
    EnergyHandler energy = EnergyHandler.NOP;
    SignalHandler out;
    int clk;
    int status;
    int idle = 1000;
    boolean update;
    int fortune;
    private static final Method getSTD;

    public BlockBreaker() {
        this.ports = new MountedPort[]{new MountedPort((IPortProvider)this, 0, BlockReference.BlockHandler.class, false).setName("port.rs_ctr.bi").setLocation(0.75, 0.625, 0.875, EnumFacing.EAST), new MountedPort((IPortProvider)this, 1, SignalHandler.class, false).setName("port.rs_ctr.clk").setLocation(0.875, 0.25, 0.625, EnumFacing.UP), new MountedPort((IPortProvider)this, 2, SignalHandler.class, true).setName("port.rs_ctr.status").setLocation(0.875, 0.25, 0.125, EnumFacing.UP), new MountedPort((IPortProvider)this, 3, EnergyHandler.class, true).setName("port.rs_ctr.energy_i").setLocation(0.875, 0.25, 0.375, EnumFacing.UP)};
    }

    public Object getPortCallback(int pin) {
        return this;
    }

    public void setPortCallback(int pin, Object callback) {
        if (pin == 2) {
            SignalHandler signalHandler = this.out = callback instanceof SignalHandler ? (SignalHandler)callback : null;
            if (this.out != null) {
                this.out.updateSignal(this.status);
            }
        } else {
            this.energy = callback instanceof EnergyHandler ? (EnergyHandler)callback : EnergyHandler.NOP;
        }
    }

    @Override
    protected void resetPin(int pin) {
        if (pin == 0) {
            this.block = null;
        }
    }

    public void updateBlock(BlockReference ref) {
        this.block = ref;
    }

    public void updateSignal(int value) {
        if (value == this.clk) {
            return;
        }
        this.clk = value;
        this.update = true;
    }

    public void func_73660_a() {
        ++this.idle;
        if (!this.update) {
            return;
        }
        this.update = false;
        int status = !this.drops.isEmpty() ? this.clearDrops() : (this.block != null && this.block.isLoaded() ? this.mineBlock(this.block) : -1);
        if (status != this.status) {
            this.status = status;
            if (this.out != null) {
                this.out.updateSignal(status);
            }
        }
        if (status != 2) {
            this.idle = 0;
        }
    }

    private int clearDrops() {
        int i;
        IItemHandler inv = (IItemHandler)Utils.neighborCapability((TileEntity)this, (EnumFacing)this.getOrientation().front, (Capability)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        if (inv == null) {
            return 1;
        }
        int j = i = this.drops.size() - 1;
        while (i >= 0) {
            ItemStack stack = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)((ItemStack)this.drops.get(i)), (boolean)false);
            if (stack.func_190916_E() > 0) {
                this.drops.set(i, (Object)stack);
            } else {
                stack = (ItemStack)this.drops.remove(j--);
                if (j >= i) {
                    this.drops.set(i, (Object)stack);
                }
            }
            --i;
        }
        return this.drops.isEmpty() ? 0 : 1;
    }

    private int mineBlock(BlockReference ref) {
        IBlockState state = ref.getState();
        Material m = state.func_185904_a();
        if (m == Material.field_151579_a || m == Material.field_151586_h || m == Material.field_151587_i) {
            return -1;
        }
        float h = state.func_185887_b(this.field_145850_b, this.field_174879_c);
        if (h < 0.0f) {
            return -1;
        }
        int e = this.energyCost(h, m.func_76229_l());
        if (this.energy.changeEnergy(e, true) != e) {
            return 2;
        }
        World world = ref.world();
        Block block = state.func_177230_c();
        if (this.fortune >= 0 || (this.fortune == -1 ? !block.canSilkHarvest(world, ref.pos, state, null) : m.func_76229_l())) {
            block.getDrops(this.drops, (IBlockAccess)world, ref.pos, state, Math.max(0, this.fortune));
        } else if (this.fortune == -1) {
            this.drops.add((Object)BlockBreaker.getSilkTouchDrop(state));
        }
        world.func_175698_g(ref.pos);
        this.energy.changeEnergy(e, false);
        return this.drops.isEmpty() ? 0 : this.clearDrops();
    }

    private int energyCost(float h, boolean byHand) {
        h = h * ENERGY_MULT + BASE_ENERGY;
        h += h * SPEED_MOD / (float)this.idle;
        if (byHand) {
            h *= NO_TOOL_MULT;
        }
        return -((int)h);
    }

    @Override
    protected void storeState(NBTTagCompound nbt, int mode) {
        if (mode == 0) {
            nbt.func_74768_a("clk", this.clk);
            nbt.func_74774_a("out", (byte)this.status);
            nbt.func_74768_a("t", this.idle);
            nbt.func_74757_a("update", this.update);
            if (this.block != null) {
                nbt.func_74782_a("ref", (NBTBase)this.block.serializeNBT());
            } else {
                nbt.func_82580_o("ref");
            }
            NBTTagList list = new NBTTagList();
            for (ItemStack stack : this.drops) {
                if (stack.func_190926_b()) continue;
                list.func_74742_a((NBTBase)stack.func_77955_b(new NBTTagCompound()));
            }
            nbt.func_74782_a("drop", (NBTBase)list);
        }
        if (mode <= 1) {
            nbt.func_74774_a("type", (byte)this.fortune);
        }
        super.storeState(nbt, mode);
    }

    @Override
    protected void loadState(NBTTagCompound nbt, int mode) {
        if (mode == 0) {
            this.clk = nbt.func_74762_e("clk");
            this.status = nbt.func_74771_c("out");
            this.idle = nbt.func_74762_e("t");
            this.block = nbt.func_150297_b("ref", 10) ? new BlockReference(nbt.func_74775_l("ref")) : null;
            NBTTagList list = nbt.func_150295_c("drop", 10);
            this.drops.clear();
            for (int i = 0; i < list.func_74745_c(); ++i) {
                this.drops.add((Object)new ItemStack(list.func_150305_b(i)));
            }
        }
        if (mode <= 1) {
            this.fortune = nbt.func_74771_c("type");
        }
        super.loadState(nbt, mode);
    }

    public void onPlaced(EntityLivingBase entity, ItemStack item) {
        Map ench;
        Integer f;
        this.fortune = item.func_77973_b() instanceof ItemBlockBreaker ? ((f = (Integer)(ench = EnchantmentHelper.func_82781_a((ItemStack)item)).get(Enchantments.field_185308_t)) != null ? f : ((f = (Integer)ench.get(Enchantments.field_185306_r)) != null ? -1 : 0)) : -2;
    }

    public List<ItemStack> dropItem(IBlockState state, int f) {
        this.getBlockState();
        ItemStack stack = new ItemStack(this.field_145854_h);
        if (this.fortune == -1) {
            EnchantmentHelper.func_82782_a(Collections.singletonMap(Enchantments.field_185306_r, 1), (ItemStack)stack);
        } else if (this.fortune > 0) {
            EnchantmentHelper.func_82782_a(Collections.singletonMap(Enchantments.field_185308_t, this.fortune), (ItemStack)stack);
        }
        return Arrays.asList(stack);
    }

    private static ItemStack getSilkTouchDrop(IBlockState state) {
        try {
            return (ItemStack)getSTD.invoke((Object)state.func_177230_c(), state);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return ItemStack.field_190927_a;
        }
    }

    @Override
    public Object getState(int id) {
        switch (id) {
            case 0: {
                return this.block;
            }
            case 1: {
                return this.clk;
            }
            case 2: {
                return this.status;
            }
        }
        return null;
    }

    static {
        Method m;
        BASE_ENERGY = 1000.0f;
        ENERGY_MULT = 4000.0f;
        SPEED_MOD = 8.0f;
        NO_TOOL_MULT = 0.5f;
        try {
            m = Block.class.getDeclaredMethod("func_180643_i", IBlockState.class);
        }
        catch (NoSuchMethodException e) {
            try {
                m = Block.class.getDeclaredMethod("getSilkTouchDrop", IBlockState.class);
            }
            catch (NoSuchMethodException e1) {
                throw new RuntimeException(e1);
            }
        }
        m.setAccessible(true);
        getSTD = m;
    }
}

