/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.sensor;

import cd4017be.api.rs_ctr.com.BlockReference;
import cd4017be.api.rs_ctr.sensor.IBlockSensor;
import cd4017be.lib.jvm_utils.ClassUtils;
import cd4017be.lib.jvm_utils.FieldWrapper;
import cd4017be.lib.util.TooltipUtil;
import cd4017be.rs_ctr.Main;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;

public class DraconicFusionSensor
implements IBlockSensor,
INBTSerializable<NBTBase> {
    private static final Class<?> C_REACTOR_COMP = ClassUtils.getClassOrNull((String)"com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorComponent");
    private static final Class<?> C_REACTOR_CORE = ClassUtils.getClassOrNull((String)"com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore");
    private static final Class<?> C_MANAGED_ENUM = ClassUtils.getClassOrNull((String)"com.brandon3055.brandonscore.lib.datamanager.ManagedEnum");
    private static final Class<?> C_MANAGED_DOUBLE = ClassUtils.getClassOrNull((String)"com.brandon3055.brandonscore.lib.datamanager.ManagedDouble");
    private static final Class<?> C_MANAGED_INT = ClassUtils.getClassOrNull((String)"com.brandon3055.brandonscore.lib.datamanager.ManagedInt");
    private static final Method M_GET_CORE = ClassUtils.getMethodOrNull(C_REACTOR_COMP, (String)"tryGetCore", (Class[])new Class[0]);
    private static final Field F_RS_MODE = ClassUtils.getFieldOrNull(C_REACTOR_COMP, (String)"rsMode");
    private static final Field F_REACTABLE_FUEL = ClassUtils.getFieldOrNull(C_REACTOR_CORE, (String)"reactableFuel");
    private static final Field F_CONVERTED_FUEL = ClassUtils.getFieldOrNull(C_REACTOR_CORE, (String)"convertedFuel");
    private static final Field F_TEMPERATURE = ClassUtils.getFieldOrNull(C_REACTOR_CORE, (String)"temperature");
    private static final Field F_SHIELD = ClassUtils.getFieldOrNull(C_REACTOR_CORE, (String)"shieldCharge");
    private static final Field F_MAX_SHIELD = ClassUtils.getFieldOrNull(C_REACTOR_CORE, (String)"maxShieldCharge");
    private static final Field F_SATURATION = ClassUtils.getFieldOrNull(C_REACTOR_CORE, (String)"saturation");
    private static final Field F_MAX_SATURATION = ClassUtils.getFieldOrNull(C_REACTOR_CORE, (String)"maxSaturation");
    private static final Field F_ENUM_VALUE = ClassUtils.getFieldOrNull(C_MANAGED_ENUM, (String)"value");
    private static final Field F_DOUBLE_VALUE = ClassUtils.getFieldOrNull(C_MANAGED_DOUBLE, (String)"value");
    private static final Field F_INT_VALUE = ClassUtils.getFieldOrNull(C_MANAGED_INT, (String)"value");
    public static final ResourceLocation MODEL = new ResourceLocation("rs_ctr", "block/_sensor.draconic()");
    private static final double PRECISION = 1000.0;
    public static boolean INVALID_API;
    IBlockSensor.IHost host;
    FieldWrapper<?> satur;
    FieldWrapper<?> maxSatur;
    FieldWrapper<?> fuel;
    FieldWrapper<?> chaos;
    FieldWrapper<?> temp;
    FieldWrapper<?> shield;
    FieldWrapper<?> maxShield;
    FieldWrapper<Enum<?>> mode;
    IBlockState lastBlock;
    byte lastMode = (byte)-2;

    public int readValue(BlockReference block) {
        if (block.getState() != this.lastBlock) {
            this.updateState(block);
        }
        if (this.lastMode < 0) {
            return 0;
        }
        int m = ((Enum)this.mode.get()).ordinal();
        if (m != this.lastMode && this.host != null) {
            this.lastMode = (byte)m;
            this.host.syncSensorState();
        }
        switch (m) {
            case 0: {
                return (int)this.temp.getAsDouble();
            }
            case 1: {
                int t = (int)this.temp.getAsDouble();
                return t > 2500 ? (t > 8000 ? 3 : 2) : (t > 2000 ? 1 : (t > 100 ? 0 : -1));
            }
            case 2: {
                return (int)this.shield.getAsDouble();
            }
            case 3: {
                return (int)(this.shield.getAsDouble() / this.maxShield.getAsDouble() * 1000.0);
            }
            case 4: {
                return this.satur.getAsInt();
            }
            case 5: {
                return (int)(this.satur.getAsDouble() / this.maxSatur.getAsDouble() * 1000.0);
            }
            case 6: {
                return (int)(this.fuel.getAsDouble() + this.chaos.getAsDouble());
            }
            case 7: {
                double c = this.chaos.getAsDouble();
                return (int)(c / (c + this.fuel.getAsDouble()) * 1000.0);
            }
        }
        return 0;
    }

    public void onRefChange(BlockReference block, IBlockSensor.IHost host) {
        this.host = host;
        if (this.host == null) {
            this.mode = null;
            this.maxSatur = null;
            this.satur = null;
            this.maxShield = null;
            this.shield = null;
            this.temp = null;
            this.chaos = null;
            this.fuel = null;
        }
        this.lastBlock = null;
        this.lastMode = (byte)-2;
    }

    private void updateState(BlockReference block) {
        this.lastBlock = block.getState();
        if (INVALID_API) {
            return;
        }
        TileEntity te = block.getTileEntity();
        if (!C_REACTOR_COMP.isInstance(te)) {
            this.mode = null;
            this.maxSatur = null;
            this.satur = null;
            this.maxShield = null;
            this.shield = null;
            this.temp = null;
            this.chaos = null;
            this.fuel = null;
            if (this.lastMode != -1) {
                this.lastMode = (byte)-1;
                this.host.syncSensorState();
            }
            return;
        }
        try {
            this.mode = new FieldWrapper(F_ENUM_VALUE, F_RS_MODE.get(te));
            Object core = M_GET_CORE.invoke((Object)te, new Object[0]);
            if (core != null) {
                this.fuel = new FieldWrapper(F_DOUBLE_VALUE, F_REACTABLE_FUEL.get(core));
                this.chaos = new FieldWrapper(F_DOUBLE_VALUE, F_CONVERTED_FUEL.get(core));
                this.temp = new FieldWrapper(F_DOUBLE_VALUE, F_TEMPERATURE.get(core));
                this.shield = new FieldWrapper(F_DOUBLE_VALUE, F_SHIELD.get(core));
                this.maxShield = new FieldWrapper(F_DOUBLE_VALUE, F_MAX_SHIELD.get(core));
                this.satur = new FieldWrapper(F_INT_VALUE, F_SATURATION.get(core));
                this.maxSatur = new FieldWrapper(F_INT_VALUE, F_MAX_SATURATION.get(core));
                if (this.lastMode < 0) {
                    this.lastMode = (byte)((Enum)this.mode.get()).ordinal();
                    this.host.syncSensorState();
                }
                return;
            }
            this.maxSatur = null;
            this.satur = null;
            this.maxShield = null;
            this.shield = null;
            this.temp = null;
            this.chaos = null;
            this.fuel = null;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            Main.LOG.error("API to Draconic Fusion Reactor is probably outdated: ", (Throwable)e);
            INVALID_API = true;
        }
        if (this.lastMode != -1) {
            this.lastMode = (byte)-1;
            this.host.syncSensorState();
        }
    }

    public String getTooltipString() {
        return TooltipUtil.translate((String)("sensor.rs_ctr.dfr" + this.lastMode));
    }

    public ResourceLocation getModel() {
        return MODEL;
    }

    public NBTBase serializeNBT() {
        return new NBTTagByte(this.lastMode);
    }

    public void deserializeNBT(NBTBase nbt) {
        this.lastMode = ((NBTPrimitive)nbt).func_150290_f();
    }

    static {
        if (F_RS_MODE == null || F_REACTABLE_FUEL == null || F_CONVERTED_FUEL == null || F_TEMPERATURE == null || F_SHIELD == null || F_MAX_SHIELD == null || F_SATURATION == null || F_MAX_SATURATION == null || F_ENUM_VALUE == null || F_DOUBLE_VALUE == null || F_INT_VALUE == null || M_GET_CORE == null) {
            INVALID_API = true;
            Main.LOG.warn("API to Draconic Fusion Reactor is probably outdated: some classes, methods or fields not found!");
        }
    }
}

