/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.render;

import cd4017be.api.rs_ctr.com.BlockReference;
import cd4017be.api.rs_ctr.port.Connector;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.ITagableConnector;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.api.rs_ctr.port.Port;
import cd4017be.lib.render.IHardCodedModel;
import cd4017be.lib.render.SpecialModelLoader;
import cd4017be.lib.util.TooltipUtil;
import com.google.common.collect.ImmutableList;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class SignalProbeRenderer
extends TileEntityItemStackRenderer
implements IHardCodedModel,
IModel,
IBakedModel {
    private final ResourceLocation parentName;
    private IBakedModel parent;
    private FontRenderer fr;
    int scroll;

    public SignalProbeRenderer(Item item) {
        ResourceLocation loc = item.getRegistryName();
        this.parentName = new ResourceLocation(loc.func_110624_b(), "item/" + loc.func_110623_a() + "_0");
        SpecialModelLoader.registerItemModel((Item)item, (IModel)this);
    }

    public void func_192838_a(ItemStack stack, float t) {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
        mc.func_175599_af().func_180454_a(stack, this.parent);
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            return;
        }
        GlStateManager.func_179109_b((float)-0.1875f, (float)0.4375f, (float)0.032f);
        GlStateManager.func_179139_a((double)0.00390625, (double)-0.00390625, (double)1.0);
        GlStateManager.func_179140_f();
        this.renderDisplay(nbt, mc.field_71476_x, (World)mc.field_71441_e, (EntityPlayer)mc.field_71439_g, t);
    }

    private void renderDisplay(NBTTagCompound data, RayTraceResult rtr, World world, EntityPlayer player, float t) {
        if (rtr == null || rtr.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockPos pos = rtr.func_178782_a();
        IBlockState state = world.func_180495_p(pos);
        ItemStack stack = state.func_177230_c().getPickBlock(state, rtr, world, pos, player);
        String s = ChatFormatting.stripFormatting((String)stack.func_82833_r());
        if (pos.hashCode() != data.func_74762_e("tgt")) {
            this.print("\u00a7l\u00a7k" + s, 4, 4, 152, -256);
            return;
        }
        this.print("\u00a7l" + s, 4, 4, 152, -256);
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof IPortProvider)) {
            this.fr.func_78276_b(TooltipUtil.translate((String)"sp.rs_ctr.invalid"), 4, 20, -1);
            return;
        }
        IPortProvider pp = (IPortProvider)te;
        Vec3d p = player.func_174824_e(t).func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        Vec3d d = player.func_70676_i(t).func_186678_a(16.0);
        NBTTagList list = data.func_150295_c("ports", 10);
        if (list.func_74745_c() <= 9) {
            this.scroll = 0;
        }
        int sel = -1;
        int y = 20;
        for (int i = 0; i < list.func_74745_c(); ++i) {
            Pair hit;
            Port port;
            NBTTagCompound nbt = list.func_150305_b(i);
            int pin = nbt.func_74762_e("id");
            try {
                port = pp.getPort(pin);
                if (port == null) {
                }
            }
            catch (Exception e) {}
            continue;
            if (port instanceof MountedPort && (hit = ((MountedPort)port).rayTrace(p, d)) != null) {
                d = (Vec3d)hit.getLeft();
                sel = i;
            }
            if (i < this.scroll || i >= this.scroll + 9) continue;
            this.printPortName(port, 4, y, 152);
            this.printValue(nbt, 4, y + 9, 152);
            y += 21;
        }
        if (sel >= 0) {
            if (sel < this.scroll) {
                this.scroll = sel;
            } else if (sel > this.scroll + 8) {
                this.scroll = sel - 8;
            }
            sel -= this.scroll;
            GlStateManager.func_179144_i((int)0);
            GlStateManager.func_179124_c((float)1.0f, (float)0.8f, (float)0.0f);
            GlStateManager.func_187447_r((int)3);
            GlStateManager.func_187435_e((float)2.0f, (float)(18 + (sel *= 21)), (float)0.0f);
            GlStateManager.func_187435_e((float)158.0f, (float)(18 + sel), (float)0.0f);
            GlStateManager.func_187435_e((float)158.0f, (float)(38 + sel), (float)0.0f);
            GlStateManager.func_187435_e((float)2.0f, (float)(38 + sel), (float)0.0f);
            GlStateManager.func_187435_e((float)2.0f, (float)(18 + sel), (float)0.0f);
            GlStateManager.func_187437_J();
        }
    }

    private void printPortName(Port p, int x, int y, int w) {
        StringBuilder sb = new StringBuilder();
        int i = p.getLink();
        if (i != 0) {
            String s;
            Connector c;
            if (p instanceof MountedPort && (c = ((MountedPort)p).getConnector()) instanceof ITagableConnector && (s = ((ITagableConnector)c).getTag()) != null) {
                sb.append("\u00a7e\u00a7o" + s + "\u00a7r");
            } else {
                sb.append(TooltipUtil.format((String)"sp.rs_ctr.id", (Object[])new Object[]{i}));
            }
        } else if (p instanceof MountedPort && ((MountedPort)p).getConnector() != null) {
            sb.append(TooltipUtil.translate((String)"sp.rs_ctr.plug"));
        } else {
            sb.append(TooltipUtil.translate((String)"sp.rs_ctr.none"));
        }
        sb.append(TooltipUtil.translate((String)(p.isMaster ? "sp.rs_ctr.o" : "sp.rs_ctr.i")));
        if (p instanceof MountedPort) {
            sb.append(TooltipUtil.translate((String)((MountedPort)p).name));
        } else {
            sb.append("\u00a7lPin ").append(p.pin);
        }
        this.print(sb.toString(), x, y, w, -1);
    }

    private void printValue(NBTTagCompound nbt, int x, int y, int w) {
        if (nbt.func_74764_b("val")) {
            switch (nbt.func_74771_c("type")) {
                case 0: {
                    this.print(TooltipUtil.format((String)"sp.rs_ctr.num", (Object[])new Object[]{nbt.func_74762_e("val")}), x, y, w, -32640);
                    break;
                }
                case 1: {
                    String s;
                    NBTTagCompound tag = nbt.func_74775_l("val");
                    if (tag.func_82582_d()) {
                        s = TooltipUtil.translate((String)"sp.rs_ctr.null");
                    } else {
                        BlockReference ref = new BlockReference(tag);
                        s = TooltipUtil.format((String)"sp.rs_ctr.block", (Object[])new Object[]{ref.pos.func_177958_n(), ref.pos.func_177956_o(), ref.pos.func_177952_p(), ref.dim, ref.face});
                    }
                    this.print(s, x, y, w, -12533568);
                }
            }
        } else {
            this.print(TooltipUtil.translate((String)"sp.rs_ctr.unknown"), x, y, w, -8355712);
        }
    }

    private void print(String s, int x, int y, int w, int c) {
        if (this.fr.func_78256_a(s) > w) {
            s = this.fr.func_78269_a(s, w - this.fr.func_78256_a("...")) + "...";
        }
        this.fr.func_78276_b(s, x, y, c);
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of((Object)this.parentName);
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IModel m = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)this.parentName, (String)"missing base model");
        this.parent = m.bake(state, format, bakedTextureGetter);
        this.fr = Minecraft.func_71410_x().field_71466_p;
        return this;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        return this.parent.func_188616_a(state, side, rand);
    }

    public boolean func_177555_b() {
        return this.parent.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.parent.func_177556_c();
    }

    public boolean func_188618_c() {
        return true;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.parent.func_177554_e();
    }

    public ItemOverrideList func_188617_f() {
        return this.parent.func_188617_f();
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType transform) {
        Pair p = this.parent.handlePerspective(transform);
        if (transform != ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND && transform != ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) {
            return p;
        }
        return Pair.of((Object)((Object)this), (Object)p.getRight());
    }

    public void onReload() {
        this.parent = null;
    }
}

