/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.render;

import cd4017be.api.rs_ctr.interact.InteractiveDeviceRenderer;
import cd4017be.lib.render.Util;
import cd4017be.lib.render.model.IntArrayModel;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr.render.ISpecialRenderComp;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PortRenderer
extends InteractiveDeviceRenderer {
    public static final PortRenderer PORT_RENDER = new PortRenderer();
    private final HashMap<String, IntArrayModel> cache = new HashMap();
    private final HashMap<String, BakedQuad[]> models = new HashMap();

    protected void renderSpecialPart(TileEntity te, double x, double y, double z, float t, int destroy, float alpha) {
        if (te instanceof ISpecialRenderComp) {
            ((ISpecialRenderComp)te).renderSpecial(x, y, z, t, this.func_147498_b());
            if (!PortRenderer.isAimedAt((TileEntity)te)) {
                return;
            }
        }
        super.renderSpecialPart(te, x, y, z, t, destroy, alpha);
    }

    public IntArrayModel getModel(String model) {
        IntArrayModel m = this.cache.get(model);
        if (m == null) {
            BakedQuad[] bqs = this.models.get(model);
            if (bqs == null) {
                m = new IntArrayModel(0);
            } else {
                m = new IntArrayModel(bqs.length);
                for (int i = 0; i < bqs.length; ++i) {
                    System.arraycopy(bqs[i].func_178209_a(), 0, m.vertexData, i * 28, 28);
                }
            }
            this.cache.put(model, m);
        }
        return m;
    }

    public void drawModel(BufferBuilder b, float x, float y, float z, Orientation o, int l, String model) {
        IntArrayModel m = this.getModel(model);
        m.setBrightness(l);
        if (o != Orientation.N) {
            m = m.rotated(o);
        }
        b.func_178981_a(m.translated((float)(x - 0.5f), (float)(y - 0.5f), (float)(z - 0.5f)).vertexData);
    }

    public void drawModel(List<BakedQuad> quads, float x, float y, float z, Orientation o, String model) {
        BakedQuad[] bqs;
        if (model != null && model.startsWith("rs_ctr:block/")) {
            model = model.substring("rs_ctr:block/".length());
        }
        if ((bqs = this.models.get(model)) == null) {
            return;
        }
        ModelRotation r = o.getModelRotation();
        for (BakedQuad bq : bqs) {
            int[] vd = (int[])bq.func_178209_a().clone();
            for (int i = 0; i < vd.length; i += 7) {
                Util.rotate((int[])vd, (int)i, (ModelRotation)r);
                vd[i + 0] = Float.floatToIntBits(Float.intBitsToFloat(vd[i + 0]) + x - 0.5f);
                vd[i + 1] = Float.floatToIntBits(Float.intBitsToFloat(vd[i + 1]) + y - 0.5f);
                vd[i + 2] = Float.floatToIntBits(Float.intBitsToFloat(vd[i + 2]) + z - 0.5f);
            }
            quads.add(new BakedQuad(vd, bq.func_178211_c(), o.rotate(bq.func_178210_d()), bq.func_187508_a(), false, bq.getFormat()));
        }
    }

    public void bake(VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        this.cache.clear();
        for (ResourceLocation loc : this.dependencies) {
            IModel m = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)loc, (String)"missing");
            List quads = m.bake(m.getDefaultState(), format, textureGetter).func_188616_a(null, null, 0L);
            String path = loc.func_110623_a();
            if (path.startsWith("block/")) {
                path = path.substring("block/".length());
            }
            if (loc.func_110624_b() != "rs_ctr") {
                path = loc.func_110624_b() + ":" + path;
            }
            this.models.put(path, quads.toArray(new BakedQuad[quads.size()]));
        }
    }

    public void register(String ... models) {
        for (String s : models) {
            this.dependencies.add(new ResourceLocation("rs_ctr", "block/" + s));
        }
    }
}

