/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.render;

import cd4017be.lib.render.Util;
import cd4017be.lib.render.model.IntArrayModel;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr.ClientProxy;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PanelRenderer {
    static IntArrayModel create(double rad0, double rad1, double angle0, double angle1, int div) {
        int[] data = new int[28 * div];
        int[] p = new int[4];
        int v0i = Float.floatToIntBits(14.0f);
        int v1i = Float.floatToIntBits(16.0f);
        PanelRenderer.vertex(p, rad0, rad1, angle0);
        for (int i = 0; i < div; ++i) {
            int j = i * 28;
            data[j] = p[2];
            data[j + 1] = p[3];
            data[j + 5] = v1i;
            data[j + 7] = p[0];
            data[j + 8] = p[1];
            data[j + 12] = v0i;
            PanelRenderer.vertex(p, rad0, rad1, angle0 + (angle1 - angle0) * (double)(i + 1) / (double)div);
            data[j + 14] = p[0];
            data[j + 15] = p[1];
            data[j + 19] = v0i;
            data[j + 21] = p[2];
            data[j + 22] = p[3];
            data[j + 26] = v1i;
        }
        return new IntArrayModel(data);
    }

    static void vertex(int[] v, double rad0, double rad1, double angle) {
        double sin = Math.sin(angle);
        double cos = Math.cos(angle);
        v[0] = Float.floatToIntBits((float)(rad0 * sin));
        v[1] = Float.floatToIntBits((float)(rad0 * cos));
        v[2] = Float.floatToIntBits((float)(rad1 * sin));
        v[3] = Float.floatToIntBits((float)(rad1 * cos));
    }

    static void drawPin(List<BakedQuad> quads, float x, float y, float z, float d, EnumFacing side) {
        int u0 = Float.floatToIntBits(ClientProxy.t_dial.func_94214_a(0.0));
        int u1 = Float.floatToIntBits(ClientProxy.t_dial.func_94214_a(0.5));
        int u2 = Float.floatToIntBits(ClientProxy.t_dial.func_94214_a(1.0));
        int v0 = Float.floatToIntBits(ClientProxy.t_dial.func_94207_b(13.0));
        int v1 = Float.floatToIntBits(ClientProxy.t_dial.func_94207_b(13.5));
        int v2 = Float.floatToIntBits(ClientProxy.t_dial.func_94207_b(14.0));
        int z0 = Float.floatToIntBits(z);
        int z1 = Float.floatToIntBits(z + 0.0625f);
        quads.add(new BakedQuad(new int[]{Float.floatToIntBits(x - d), Float.floatToIntBits(y + d), z0, -1, u0, v0, 0, Float.floatToIntBits(x - d), Float.floatToIntBits(y - d), z0, -1, u0, v2, 0, Float.floatToIntBits(x), Float.floatToIntBits(y), z1, -1, u1, v1, 0, Float.floatToIntBits(x + d), Float.floatToIntBits(y + d), z0, -1, u2, v0, 0}, -1, side, ClientProxy.t_dial, true, DefaultVertexFormats.field_176600_a));
        quads.add(new BakedQuad(new int[]{Float.floatToIntBits(x), Float.floatToIntBits(y), z1, -1, u1, v1, 0, Float.floatToIntBits(x - d), Float.floatToIntBits(y - d), z0, -1, u0, v2, 0, Float.floatToIntBits(x + d), Float.floatToIntBits(y - d), z0, -1, u2, v2, 0, Float.floatToIntBits(x + d), Float.floatToIntBits(y + d), z0, -1, u2, v0, 0}, -1, side, ClientProxy.t_dial, true, DefaultVertexFormats.field_176600_a));
    }

    static BakedQuad digit(float x, float y, float z, float h, int d, EnumFacing side, int color) {
        float w;
        float f;
        if (d < 0) {
            f = 15.25f;
            w = 0.75f;
            d = 0;
        } else if (d < 16) {
            f = 12.75f;
            w = 1.25f;
        } else {
            f = 13.25f;
            w = (float)(d >> 4) - 0.25f;
        }
        int zi = Float.floatToIntBits(z);
        int u0 = Float.floatToIntBits(ClientProxy.t_dial.func_94214_a((double)f));
        int u1 = Float.floatToIntBits(ClientProxy.t_dial.func_94214_a((double)(f + w)));
        f = (float)(d & 0xF) * 1.25f;
        int v0 = Float.floatToIntBits(ClientProxy.t_dial.func_94207_b((double)f));
        int v1 = Float.floatToIntBits(ClientProxy.t_dial.func_94207_b((double)(f + 1.25f)));
        w *= h / 1.25f;
        int[] data = new int[]{Float.floatToIntBits(x), Float.floatToIntBits(y + (h /= 2.0f)), zi, color, u0, v0, 0, Float.floatToIntBits(x), Float.floatToIntBits(y - h), zi, color, u0, v1, 0, Float.floatToIntBits(x + w), Float.floatToIntBits(y - h), zi, color, u1, v1, 0, Float.floatToIntBits(x + w), Float.floatToIntBits(y + h), zi, color, u1, v0, 0};
        return new BakedQuad(data, -1, side, ClientProxy.t_dial, true, DefaultVertexFormats.field_176600_a);
    }

    static float len(int i, int exp) {
        float l;
        if (i < 0) {
            return PanelRenderer.len(-i, exp) + 0.6f;
        }
        if (i == 0) {
            return 0.6f;
        }
        while (exp < 0 && i % 10 == 0) {
            ++exp;
            i /= 10;
        }
        float f = l = exp < 0 ? 0.4f : (float)exp * 0.8f;
        while (i >= 10) {
            l += 0.8f;
            i /= 10;
        }
        return l + 0.6f;
    }

    static float drawNumber(List<BakedQuad> quads, float x, float y, float z, float h, int n, int exp, int color, EnumFacing side) {
        if (n < 10) {
            quads.add(PanelRenderer.digit(x, y, z, h, n | exp + 1 << 4, side, color));
            return (exp < 0 ? 0.4f : (float)exp * 0.8f) + 0.8f;
        }
        float w = PanelRenderer.drawNumber(quads, x, y, z, h, n / 10, Math.min(exp + 1, 0), color, side);
        return w + PanelRenderer.drawNumber(quads, x + w * h, y, z, h, n % 10, exp < -1 ? 0 : exp, color, side);
    }

    public static enum Layout {
        QUARTER(0.3125, 0.375, -90.0, 0.0, 10, 10, new Vec3d(0.4375, 0.0625, 1.003)),
        HALF(0.3125, 0.375, -90.0, 90.0, 16, 20, new Vec3d(0.5, 0.0625, 1.003)),
        HALF_V(0.3125, 0.375, -180.0, 0.0, 16, 20, new Vec3d(0.4375, 0.4375, 1.003)),
        CIRCLE(0.3125, 0.375, -150.0, 150.0, 20, 32, new Vec3d(0.5, 0.4375, 1.003));

        public final double angle0;
        public final double angle1;
        public final double rad0;
        public final double rad1;
        public final int n_div;
        public final int precision;
        public final Vec3d offset;
        public final IntArrayModel model;

        private Layout(double rad0, double rad1, double angle0, double angle1, int precision, int n_div, Vec3d offset) {
            this.rad0 = rad0;
            this.rad1 = rad1;
            this.angle0 = Math.toRadians(angle0);
            this.angle1 = Math.toRadians(angle1);
            this.precision = precision;
            this.n_div = n_div;
            this.offset = offset;
            this.model = PanelRenderer.create(rad0, rad1, this.angle0, this.angle1, n_div).translated((float)offset.field_72450_a, (float)offset.field_72448_b, (float)offset.field_72449_c);
        }

        public static Layout of(int i) {
            return Layout.values()[i & 3];
        }

        public IntArrayModel getPointer(double f, int light, float ox, float oy) {
            f = this.angle0 + (this.angle1 - this.angle0) * MathHelper.func_151237_a((double)f, (double)-0.04, (double)1.04);
            float fy = (float)(Math.cos(f) * this.rad1);
            float fx = (float)(Math.sin(f) * this.rad1);
            float px = (float)this.offset.field_72450_a + ox;
            float py = (float)this.offset.field_72448_b + oy;
            int pz = Float.floatToIntBits((float)this.offset.field_72449_c + 0.03125f);
            TextureAtlasSprite tex = ClientProxy.t_dial;
            int u0 = Float.floatToIntBits(tex.func_94209_e());
            int u1 = Float.floatToIntBits(tex.func_94214_a(4.0));
            int u2 = Float.floatToIntBits(tex.func_94214_a(12.0));
            int v0 = Float.floatToIntBits(tex.func_94206_g());
            int v1 = Float.floatToIntBits(tex.func_94207_b(4.0));
            int v2 = Float.floatToIntBits(tex.func_94207_b(12.0));
            return new IntArrayModel(new int[]{Float.floatToIntBits(px + fx), Float.floatToIntBits(py + fy), pz, -1, u0, v0, light, Float.floatToIntBits(px + 0.5f * fy), Float.floatToIntBits(py - 0.5f * fx), pz, -1, u2, v1, light, Float.floatToIntBits(px - 0.5f * fx), Float.floatToIntBits(py - 0.5f * fy), pz, -1, u2, v2, light, Float.floatToIntBits(px - 0.5f * fy), Float.floatToIntBits(py + 0.5f * fx), pz, -1, u1, v2, light}, -1, light);
        }

        public void drawScale(List<BakedQuad> quads, Orientation o, int min, int max, int exp, int color, float ox, float oy) {
            EnumFacing side = o.back;
            int scale = 1;
            float mag = Math.abs((long)max - (long)min);
            while (mag > (float)this.precision) {
                mag /= 10.0f;
                scale *= 10;
                ++exp;
            }
            float f = (float)min / (float)scale;
            float df = (float)((long)max - (long)min) / (float)scale;
            int[] data = this.model.vertexData;
            float df1 = df / (float)this.n_div;
            float f1 = f;
            int i = 4;
            while (i < data.length) {
                float u = f1 % 1.0f;
                if (u < 0.0f) {
                    u += 1.0f;
                }
                if (df1 < 0.0f) {
                    u += 1.0f;
                }
                data[i] = data[i += 7] = Float.floatToIntBits(u * 7.5f + 0.125f);
                data[i += 7] = data[i += 7] = Float.floatToIntBits((u + df1) * 7.5f + 0.125f);
                i += 7;
                f1 += df1;
            }
            this.model.setColor(color);
            IntArrayModel model = this.model.withTexture(ClientProxy.t_dial);
            model.setOffset(ox, oy, 0.0f);
            data = model.vertexData;
            int q = quads.size();
            int i2 = 0;
            while (i2 < data.length) {
                quads.add(new BakedQuad(Arrays.copyOfRange(data, i2, i2 += 28), -1, side, ClientProxy.t_dial, true, DefaultVertexFormats.field_176600_a));
            }
            if (Math.abs(f) <= 1000.0f) {
                int j;
                int i3;
                int de = 0;
                for (float f_ = Math.max(Math.abs(f), Math.abs(f + df)); f_ >= 10.0f; f_ /= 10.0f) {
                    ++de;
                }
                exp = Math.floorMod(exp + de, 3) - de;
                int m = 1;
                if (mag > (float)(this.precision >> 1)) {
                    m = 2;
                } else if (mag <= (float)(this.precision >> 2)) {
                    m = 5;
                    f *= 10.0f;
                    df *= 10.0f;
                    --exp;
                }
                if (df >= 0.0f) {
                    i3 = (int)Math.ceil(f / (float)m) * m;
                    j = (int)Math.floor((f + df) / (float)m) * m;
                } else {
                    i3 = (int)Math.ceil((f + df) / (float)m) * m;
                    j = (int)Math.floor(f / (float)m) * m;
                }
                float w = exp < 0 ? 2.0f : (float)(exp * 4);
                for (int k = Math.max(Math.abs(i3), Math.abs(j)); k >= 10; k /= 10) {
                    w += 4.0f;
                }
                w = (w >= 8.0f ? 0.5f : 0.75f) * (float)(this.rad1 - this.rad0);
                while (i3 <= j) {
                    int e;
                    int k;
                    double a = this.angle0 + ((double)i3 - (double)f) / (double)df * (this.angle1 - this.angle0);
                    double sin = Math.sin(a);
                    double cos = Math.cos(a);
                    float l = w * PanelRenderer.len(i3, exp);
                    double r = this.rad0 - ((double)l * Math.abs(sin) + (double)w * Math.abs(cos)) / 2.0;
                    float x = (float)(this.offset.field_72450_a + (double)ox + r * sin) - l / 2.0f;
                    float y = (float)(this.offset.field_72448_b + (double)oy + r * cos);
                    float z = (float)this.offset.field_72449_c;
                    if (i3 < 0) {
                        quads.add(PanelRenderer.digit(x, y, z, w, -1, side, color));
                        x += 0.6f * w;
                        k = -i3;
                    } else {
                        k = i3;
                    }
                    if (k == 0) {
                        e = 0;
                    } else {
                        e = exp;
                        while (k % 10 == 0) {
                            ++e;
                            k /= 10;
                        }
                    }
                    PanelRenderer.drawNumber(quads, x, y, z, w, k, e, color, side);
                    i3 += m;
                }
            }
            float w = (float)(this.rad1 - this.rad0) * 0.25f;
            float x = (float)this.offset.field_72450_a + ox;
            float y = (float)this.offset.field_72448_b + oy;
            float z = (float)this.offset.field_72449_c;
            PanelRenderer.drawPin(quads, x, y, z, w, side);
            double da = (this.angle1 - this.angle0) * 0.046875;
            double a = this.angle0 - da;
            double r = (this.rad0 + this.rad1) / 2.0;
            PanelRenderer.drawPin(quads, x + (float)(r * Math.sin(a)), y + (float)(r * Math.cos(a)), z, w /= 2.0f, side);
            a = this.angle1 + da;
            PanelRenderer.drawPin(quads, x + (float)(r * Math.sin(a)), y + (float)(r * Math.cos(a)), z, w, side);
            ModelRotation rot = o.getModelRotation();
            while (q < quads.size()) {
                data = quads.get(q).func_178209_a();
                Util.rotate((int[])data, (int)0, (ModelRotation)rot);
                Util.rotate((int[])data, (int)7, (ModelRotation)rot);
                Util.rotate((int[])data, (int)14, (ModelRotation)rot);
                Util.rotate((int[])data, (int)21, (ModelRotation)rot);
                ++q;
            }
        }
    }
}

