/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.port;

import cd4017be.api.rs_ctr.interact.IInteractiveComponent;
import cd4017be.api.rs_ctr.port.Connector;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.ITagableConnector;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.api.rs_ctr.port.Port;
import cd4017be.lib.util.DimPos;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr.port.WireType;
import cd4017be.rs_ctr.render.PortRenderer;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WirelessConnection
extends Connector
implements ITagableConnector,
IInteractiveComponent.IBlockRenderComp {
    private final WireType type;
    private DimPos linkPos;
    private int linkPin;
    private boolean dropsItem;
    private String tag;

    public WirelessConnection(MountedPort port, WireType type) {
        super(port);
        this.type = type;
    }

    public WirelessConnection(MountedPort port, DimPos linkPos, int linkPin, boolean drop, WireType type) {
        this(port, type);
        this.linkPos = linkPos;
        this.linkPin = linkPin;
        this.dropsItem = drop;
    }

    protected String id() {
        return this.type.wirelessId;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74772_a("pos", this.linkPos.func_177986_g());
        nbt.func_74768_a("dim", this.linkPos.dimId);
        nbt.func_74768_a("pin", this.linkPin);
        nbt.func_74757_a("drop", this.dropsItem);
        if (this.tag != null) {
            nbt.func_74778_a("tag", this.tag);
        }
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.linkPos = new DimPos((Vec3i)BlockPos.func_177969_a((long)nbt.func_74763_f("pos")), nbt.func_74762_e("dim"));
        this.linkPin = nbt.func_74762_e("pin");
        this.dropsItem = nbt.func_74767_n("drop");
        this.tag = nbt.func_150297_b("tag", 8) ? nbt.func_74779_i("tag") : null;
    }

    public String displayInfo(MountedPort port, int linkID) {
        try {
            return (this.tag != null ? "\n\u00a7e" + this.tag : super.displayInfo(port, linkID)) + "\n[" + this.linkPos.func_177958_n() + ", " + this.linkPos.func_177956_o() + ", " + this.linkPos.func_177952_p() + "]\n" + DimensionManager.getProviderType((int)this.linkPos.dimId).func_186065_b();
        }
        catch (IllegalArgumentException e) {
            return "\n" + e.getMessage();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void render(List<BakedQuad> quads) {
        PortRenderer.PORT_RENDER.drawModel(quads, (float)this.port.pos.field_72450_a, (float)this.port.pos.field_72448_b, (float)this.port.pos.field_72449_c, Orientation.fromFacing((EnumFacing)this.port.face), this.type.wirelessModel());
    }

    public void onRemoved(EntityPlayer player) {
        Connector c;
        Port p = IPortProvider.getPort((World)this.linkPos.getWorldServer(), (BlockPos)this.linkPos, (int)this.linkPin);
        if (p != null && p.getLink() == this.port.getLink() && p instanceof MountedPort && (c = ((MountedPort)p).getConnector()) instanceof WirelessConnection) {
            WirelessConnection wc = (WirelessConnection)c;
            if (wc.dropsItem && !this.dropsItem) {
                this.dropsItem = true;
                wc.dropsItem = false;
            }
            ((MountedPort)p).setConnector(null, player);
        }
        if (this.dropsItem) {
            this.dropItem(new ItemStack(this.type.wirelessItem), player);
        }
        this.port.disconnect();
    }

    public void setTag(String tag) {
        Connector c;
        if (this.tag != null ? this.tag.equals(tag) : tag == null) {
            return;
        }
        this.tag = tag;
        this.port.owner.onPortModified((Port)this.port, 16);
        Port p = IPortProvider.getPort((World)this.linkPos.getWorldServer(), (BlockPos)this.linkPos, (int)this.linkPin);
        if (p instanceof MountedPort && (c = ((MountedPort)p).getConnector()) instanceof WirelessConnection) {
            ((WirelessConnection)c).tag = tag;
            p.owner.onPortModified(p, 16);
        }
    }

    public String getTag() {
        return this.tag;
    }

    public void onLinkLoad(Port link) {
        if (!(link instanceof MountedPort)) {
            return;
        }
        Connector con = ((MountedPort)link).getConnector();
        if (!(con instanceof WirelessConnection)) {
            return;
        }
        WirelessConnection wc = (WirelessConnection)con;
        DimPos pos = new DimPos((Vec3i)wc.port.getPos(), wc.port.getWorld());
        if (this.linkPin != wc.port.pin || !pos.equals((Object)this.linkPos)) {
            this.linkPin = wc.port.pin;
            this.linkPos = pos;
            this.port.owner.onPortModified((Port)this.port, 16);
        }
    }
}

