/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.port;

import cd4017be.api.rs_ctr.interact.IInteractiveComponent;
import cd4017be.api.rs_ctr.port.Connector;
import cd4017be.api.rs_ctr.port.IIntegratedConnector;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.ITagableConnector;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.api.rs_ctr.port.Port;
import cd4017be.api.rs_ctr.wire.WireLine;
import cd4017be.api.rs_ctr.wire.WiredConnector;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr.port.WireBranch;
import cd4017be.rs_ctr.port.WireType;
import cd4017be.rs_ctr.render.PortRenderer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class SplitPlug
extends Connector
implements IIntegratedConnector,
ITagableConnector,
IInteractiveComponent.ITESRenderComp,
IInteractiveComponent.IBlockRenderComp {
    public static int MAX_LINK_COUNT = 8;
    public final Port inPort;
    Port[] ports = new Port[0];
    protected WireBranch[] wires = new WireBranch[0];

    public SplitPlug(MountedPort port) {
        super(port);
        this.inPort = new Port((IPortProvider)this, 0, this.type().clazz, false);
    }

    protected abstract WireType type();

    protected String id() {
        return this.type().splitId;
    }

    public int addLinks(int n) {
        int l = this.ports.length;
        if ((n = Math.min(n, MAX_LINK_COUNT - l)) <= 0) {
            return 0;
        }
        this.ports = Arrays.copyOf(this.ports, l + n);
        this.wires = Arrays.copyOf(this.wires, l + n);
        for (int i = l; i < this.ports.length; ++i) {
            this.ports[i] = new Port((IPortProvider)this, i + 1, this.type().clazz, true);
        }
        return n;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_179237_a(this.inPort.serializeNBT());
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.ports.length; ++i) {
            NBTTagCompound tag = this.ports[i].serializeNBT();
            if (this.wires[i] != null) {
                tag.func_74782_a("wire", (NBTBase)this.wires[i].serializeNBT());
            }
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("ports", (NBTBase)list);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.inPort.deserializeNBT(nbt);
        if (nbt.func_150297_b("links", 9)) {
            this.deserializeOld(nbt);
            return;
        }
        NBTTagList list = nbt.func_150295_c("ports", 10);
        this.ports = new Port[list.func_74745_c()];
        this.wires = new WireBranch[list.func_74745_c()];
        for (int i = 0; i < this.ports.length; ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            this.ports[i] = new Port((IPortProvider)this, i + 1, this.type().clazz, true);
            this.ports[i].deserializeNBT(tag);
            if (!tag.func_150297_b("wire", 10)) continue;
            this.wires[i] = new WireBranch(this.port, this.type());
            this.wires[i].deserializeNBT(tag.func_74775_l("wire"));
        }
    }

    @Deprecated
    private void deserializeOld(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("links", 10);
        this.ports = new Port[list.func_74745_c()];
        this.wires = new WireBranch[list.func_74745_c()];
        for (int i = 0; i < this.ports.length; ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            this.ports[i] = new Port((IPortProvider)this, i + 1, this.type().clazz, true);
            this.ports[i].deserializeNBT(tag);
            if (!tag.func_150297_b("pos", 4)) continue;
            this.wires[i] = new WireBranch(this.port, this.type());
            this.wires[i].deserializeNBT(tag);
        }
    }

    public WiredConnector getLinkedWith(WiredConnector link) {
        for (WireBranch con : this.wires) {
            if (con == null || !con.isLinked(link)) continue;
            return con;
        }
        return null;
    }

    public boolean addWire(WiredConnector con, EntityPlayer player, boolean sim) {
        if (!(con instanceof WireBranch)) {
            return false;
        }
        for (int i = 0; i < this.wires.length; ++i) {
            if (this.wires[i] != null) continue;
            if (!sim) {
                this.wires[i] = (WireBranch)con;
            }
            return true;
        }
        ItemStack stack = this.drop();
        if (this.wires.length >= MAX_LINK_COUNT || !player.func_184812_l_() && !player.field_71071_by.func_70431_c(stack)) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.rs_ctr.split1", new Object[0]));
            return false;
        }
        if (sim) {
            return true;
        }
        if (!player.func_184812_l_()) {
            player.field_71071_by.func_174925_a(stack.func_77973_b(), stack.func_77960_j(), 1, null);
        }
        this.addLinks(1);
        return this.addWire(con, player, sim);
    }

    public void removeWire(WiredConnector con, EntityPlayer player) {
        for (int i = 0; i < this.wires.length; ++i) {
            if (this.wires[i] != con) continue;
            this.wires[i] = null;
            con.onRemoved(player);
        }
    }

    public Port getPort(WiredConnector con) {
        for (int i = 0; i < this.wires.length; ++i) {
            if (this.wires[i] != con) continue;
            return this.ports[i];
        }
        return null;
    }

    public void onLoad() {
        this.inPort.onLoad();
        for (Port port : this.ports) {
            port.onLoad();
        }
        for (WireBranch wireBranch : this.wires) {
            if (wireBranch == null) continue;
            wireBranch.onLoad();
        }
        if (this.inPort.getLink() == 0) {
            this.inPort.connect((Port)this.port);
        }
    }

    public void onUnload() {
        this.inPort.onUnload();
        for (Port port : this.ports) {
            port.onUnload();
        }
        for (WireBranch wireBranch : this.wires) {
            if (wireBranch == null) continue;
            wireBranch.onUnload();
        }
    }

    public void onRemoved(EntityPlayer player) {
        this.inPort.disconnect();
        for (int i = 0; i < this.wires.length; ++i) {
            WireBranch con = this.wires[i];
            if (con == null) continue;
            this.wires[i] = null;
            con.onRemoved(player);
        }
        this.dropItem(this.drop(), player);
    }

    public void onPortMove() {
        for (WireBranch con : this.wires) {
            if (con == null) continue;
            con.onPortMove();
        }
    }

    public String displayInfo(MountedPort port, int linkID) {
        int n = 0;
        for (WireBranch b : this.wires) {
            if (b == null) continue;
            ++n;
        }
        return "\n" + n + " / " + this.wires.length;
    }

    public void setTag(String tag) {
        for (WireBranch b : this.wires) {
            if (b == null || Objects.equals(tag, b.getTag())) continue;
            try {
                new WireLine((WiredConnector)b).forEach(con -> con.setTag(tag));
            }
            catch (WireLine.WireLoopException wireLoopException) {
                // empty catch block
            }
        }
    }

    public String getTag() {
        for (WireBranch b : this.wires) {
            String s;
            if (b == null || (s = b.getTag()) == null) continue;
            return s;
        }
        return null;
    }

    public Port getPort(int pin) {
        return pin == 0 ? this.inPort : this.ports[pin - 1];
    }

    public Object getPortCallback(int pin) {
        return this;
    }

    public void onPortModified(Port port, int event) {
        this.port.owner.onPortModified((Port)this.port, 16);
    }

    @SideOnly(value=Side.CLIENT)
    public void render(World world, BlockPos pos, double x, double y, double z, int light, BufferBuilder buffer) {
        for (WireBranch b : this.wires) {
            if (b == null) continue;
            b.render(world, pos, x, y, z, light, buffer);
        }
    }

    public AxisAlignedBB getRenderBB(World world, BlockPos pos) {
        AxisAlignedBB box = null;
        for (WireBranch b : this.wires) {
            AxisAlignedBB box1;
            if (b == null || (box1 = b.getRenderBB(world, pos)) == null) continue;
            box = box == null ? box1 : box.func_111270_a(box1);
        }
        return box;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(List<BakedQuad> quads) {
        for (WireBranch b : this.wires) {
            if (b == null) continue;
            b.render(quads);
        }
        PortRenderer.PORT_RENDER.drawModel(quads, (float)this.port.pos.field_72450_a, (float)this.port.pos.field_72448_b, (float)this.port.pos.field_72449_c, Orientation.fromFacing((EnumFacing)this.port.face), this.type().wireModel());
    }

    protected abstract ItemStack drop();
}

