/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.port;

import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.lib.util.Orientation;
import cd4017be.lib.util.TooltipUtil;
import cd4017be.rs_ctr.Objects;
import cd4017be.rs_ctr.port.LogicPlug;
import cd4017be.rs_ctr.render.PortRenderer;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class EdgeTrigger
extends LogicPlug {
    public static final String ID = "edge_trigger";
    int state;
    public boolean rising;

    public EdgeTrigger(MountedPort port) {
        super(port);
    }

    public void updateSignal(int value) {
        if (value <= 0 ^ (this.state & 0x10000) != 0) {
            return;
        }
        this.state ^= 0x10000;
        if (value <= 0 ^ this.rising) {
            this.out.updateSignal((this.state ^= 0xFFFF) & 0xFFFF);
        }
    }

    @Override
    protected int getOutput() {
        return this.state & 0xFFFF;
    }

    protected String id() {
        return ID;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74768_a("state", this.state);
        nbt.func_74757_a("mode", this.rising);
        return nbt;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        this.state = nbt.func_74762_e("state");
        this.rising = nbt.func_74767_n("mode");
    }

    @Override
    public void onRemoved(EntityPlayer player) {
        super.onRemoved(player);
        this.dropItem(new ItemStack((Item)Objects.edge_trigger, 1, this.rising ? 0 : 1), player);
    }

    public String displayInfo(MountedPort port, int linkID) {
        return TooltipUtil.translate((String)(this.rising ? "port.rs_ctr.edge0" : "port.rs_ctr.edge1")) + super.displayInfo(port, this.outPort.getLink());
    }

    @Override
    public void render(List<BakedQuad> quads) {
        super.render(quads);
        PortRenderer.PORT_RENDER.drawModel(quads, (float)this.port.pos.field_72450_a, (float)this.port.pos.field_72448_b, (float)this.port.pos.field_72449_c, Orientation.fromFacing((EnumFacing)this.port.face), "_plug.misc(4)");
    }
}

