/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.item;

import cd4017be.api.rs_ctr.port.Connector;
import cd4017be.api.rs_ctr.port.ITagableConnector;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.api.rs_ctr.wire.WireLine;
import cd4017be.api.rs_ctr.wire.WiredConnector;
import cd4017be.lib.Gui.AdvancedContainer;
import cd4017be.lib.Gui.ItemInteractionHandler;
import cd4017be.lib.Gui.ModularGui;
import cd4017be.lib.Gui.comp.GuiCompGroup;
import cd4017be.lib.Gui.comp.GuiFrame;
import cd4017be.lib.Gui.comp.IGuiComp;
import cd4017be.lib.Gui.comp.TextField;
import cd4017be.lib.item.BaseItem;
import cd4017be.lib.network.GuiNetworkHandler;
import cd4017be.lib.network.IGuiHandlerItem;
import cd4017be.lib.network.StateSyncClient;
import cd4017be.lib.network.StateSyncServer;
import cd4017be.lib.network.StateSynchronizer;
import cd4017be.rs_ctr.Objects;
import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWireTag
extends BaseItem
implements WiredConnector.IWiredConnectorItem,
IGuiHandlerItem {
    public ItemWireTag(String id) {
        super(id);
        this.func_77625_d(1);
    }

    public String func_77653_i(ItemStack item) {
        String s = super.func_77653_i(item);
        if (item.func_77942_o()) {
            s = s + " \u00a7e" + item.func_77978_p().func_74779_i("name");
        }
        return s;
    }

    public void doAttach(ItemStack stack, MountedPort port, EntityPlayer player) {
        Connector c = port.getConnector();
        if (!(c instanceof ITagableConnector)) {
            return;
        }
        ITagableConnector tc = (ITagableConnector)c;
        if (stack.func_77942_o()) {
            String tag = stack.func_77978_p().func_74779_i("name");
            if (!tag.equals(tc.getTag())) {
                if (tc instanceof WiredConnector) {
                    try {
                        new WireLine((WiredConnector)tc).forEach(con -> con.setTag(tag));
                    }
                    catch (WireLine.WireLoopException e) {
                        return;
                    }
                } else {
                    tc.setTag(tag);
                }
            }
            stack.func_77982_d(null);
        } else if (tc.getTag() != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("name", tc.getTag());
            stack.func_77982_d(nbt);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            stack.func_77982_d(null);
        } else {
            GuiNetworkHandler.openHeldItemGui((EntityPlayer)player, (EnumHand)hand, (int)0, (int)0, (int)0);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public AdvancedContainer getContainer(ItemStack stack, EntityPlayer player, int slot, int x, int y, int z) {
        return new StateInteractionHandler(slot).createContainer(player);
    }

    @SideOnly(value=Side.CLIENT)
    public ModularGui getGuiScreen(ItemStack stack, EntityPlayer player, int slot, int x, int y, int z) {
        StateInteractionHandler state = new StateInteractionHandler(slot);
        ModularGui gui = new ModularGui(state.createContainer(player));
        GuiFrame frame = new GuiFrame(gui, 144, 31, 1).title("gui.rs_ctr.tag.name", 0.5f).background(new ResourceLocation("rs_ctr", "textures/gui/small.png"), 80, 0);
        frame.add((IGuiComp)new TextField((GuiCompGroup)frame, 128, 7, 8, 16, 24, (Supplier)state, xva$0 -> gui.sendPkt(new Object[]{xva$0})));
        gui.compGroup = frame;
        return gui;
    }

    static class StateInteractionHandler
    extends ItemInteractionHandler
    implements Supplier<String> {
        String name = "";

        public StateInteractionHandler(int slot) {
            super((Item)Objects.tag, slot);
        }

        protected void initSync(StateSynchronizer.Builder sb) {
            sb.addVar(1);
        }

        public void writeState(StateSyncServer state, AdvancedContainer cont) {
            state.endFixed().putAll(new Object[]{this.getNBT(cont.player).func_74779_i("name")});
        }

        public void readState(StateSyncClient state, AdvancedContainer cont) {
            this.name = state.get(this.name);
        }

        public void handleAction(PacketBuffer pkt, EntityPlayerMP sender) throws Exception {
            this.getNBT((EntityPlayer)sender).func_74778_a("name", pkt.func_150789_c(24));
        }

        @Override
        public String get() {
            return this.name;
        }
    }
}

