/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.item;

import cd4017be.lib.item.BaseItemBlock;
import cd4017be.lib.util.ItemFluidUtil;
import cd4017be.lib.util.TooltipUtil;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemProcessor
extends BaseItemBlock {
    final int maxIn;
    final int maxOut;

    public ItemProcessor(Block id, int in, int out) {
        super(id);
        this.maxIn = in;
        this.maxOut = out;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74783_a("stats", new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, 0});
            ItemStack stack = new ItemStack((Item)this);
            stack.func_77982_d(nbt);
            items.add((Object)stack);
        }
    }

    public String func_77653_i(ItemStack item) {
        String name;
        if (item.func_77942_o() && !(name = item.func_77978_p().func_74779_i("name")).isEmpty()) {
            return "\u00a7o" + name;
        }
        return super.func_77653_i(item);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack item, World player, List<String> list, ITooltipFlag b) {
        if (item.func_77942_o()) {
            int[] stats;
            NBTTagCompound nbt = item.func_77978_p();
            int n = nbt.func_74759_k("in").length;
            int m = n + nbt.func_74759_k("out").length;
            if (m > 0) {
                int i;
                NBTTagList labels = nbt.func_150295_c("labels", 8);
                StringBuilder sb = new StringBuilder("(");
                for (i = 0; i < n; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append("\u00a71").append(labels.func_150307_f(i)).append("\u00a77");
                }
                sb.append(") -> (");
                for (i = n; i < m; ++i) {
                    if (i > n) {
                        sb.append(", ");
                    }
                    sb.append("\u00a72").append(labels.func_150307_f(i)).append("\u00a77");
                }
                sb.append(")");
                list.add(sb.toString());
            }
            if ((stats = nbt.func_74759_k("stats")).length < 4) {
                stats = Arrays.copyOf(stats, 4);
            }
            list.add(TooltipUtil.format((String)"item.rs_ctr.processor.stats", (Object[])new Object[]{stats[0], stats[1], stats[2], stats[3]}));
            if (b.func_194127_a() && nbt.func_74764_b("IDm")) {
                list.add("\u00a78" + new UUID(nbt.func_74763_f("IDm"), nbt.func_74763_f("IDl")).toString());
            }
        }
        super.func_77624_a(item, player, list, b);
    }

    public void loadIngredients(ItemStack stack, ItemStack[] ingreds) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            Arrays.fill(ingreds, ItemStack.field_190927_a);
        } else {
            ItemFluidUtil.loadItems((NBTTagList)nbt.func_150295_c("ingr", 10), (ItemStack[])ingreds);
        }
    }

    public void storeAll(ItemStack stack, ItemStack[] ingreds, int[] cmplx) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74783_a("stats", cmplx);
        nbt.func_74782_a("ingr", (NBTBase)ItemFluidUtil.saveItems((ItemStack[])ingreds));
        stack.func_77982_d(nbt);
    }

    public void loadStats(ItemStack stack, int[] stats) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            return;
        }
        int[] arr = nbt.func_74759_k("stats");
        System.arraycopy(arr, 0, stats, 0, Math.min(arr.length, stats.length));
    }

    public int maxInPorts(ItemStack stack) {
        return this.maxIn;
    }

    public int maxOutPorts(ItemStack stack) {
        return this.maxOut;
    }
}

