/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.item;

import cd4017be.api.rs_ctr.com.BlockReference;
import cd4017be.api.rs_ctr.port.Connector;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.lib.item.BaseItem;
import cd4017be.lib.util.TooltipUtil;
import cd4017be.rs_ctr.port.BlockProbe;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class ItemBlockProbe
extends BaseItem
implements Connector.IConnectorItem {
    public static int MAX_LENGTH = 8;

    public ItemBlockProbe(String id) {
        super(id);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af()) {
            return EnumActionResult.PASS;
        }
        ItemStack stack = player.func_184586_b(hand);
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        nbt.func_74768_a("lx", pos.func_177958_n());
        nbt.func_74768_a("ly", pos.func_177956_o());
        nbt.func_74768_a("lz", pos.func_177952_p());
        nbt.func_74774_a("lf", (byte)facing.func_176745_a());
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_70093_af()) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        stack.func_77982_d(null);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void doAttach(ItemStack stack, MountedPort port, EntityPlayer player) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (port.type != BlockReference.BlockHandler.class) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.rs_ctr.type", new Object[0]));
            return;
        }
        if (nbt == null) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.rs_ctr.probe0", new Object[0]));
            return;
        }
        if (port.isMaster) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.rs_ctr.probe1", new Object[0]));
            return;
        }
        boolean creative = player.func_184812_l_();
        EnumFacing side = EnumFacing.func_82600_a((int)nbt.func_74771_c("lf"));
        BlockPos pos = new BlockPos(nbt.func_74762_e("lx"), nbt.func_74762_e("ly"), nbt.func_74762_e("lz"));
        int d = (int)Math.ceil(Math.sqrt(pos.func_177972_a(side).func_177951_i((Vec3i)port.getPos())));
        if (d > MAX_LENGTH) {
            player.func_145747_a((ITextComponent)new TextComponentString(d > MAX_LENGTH ? TooltipUtil.format((String)"msg.rs_ctr.wire2", (Object[])new Object[]{MAX_LENGTH}) : TooltipUtil.translate((String)"msg.rs_ctr.wire1")));
            stack.func_77982_d(null);
            return;
        }
        port.setConnector((Connector)new BlockProbe(port, pos, side), player);
        stack.func_77982_d(null);
        if (!creative) {
            stack.func_190918_g(1);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!isSelected) {
            return;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            return;
        }
        Vec3d start = entity.func_174824_e(1.0f);
        RayTraceResult rt = world.func_72933_a(start, start.func_178787_e(entity.func_70676_i(1.0f).func_186678_a(3.0)));
        BlockPos pos = rt == null ? entity.func_180425_c() : rt.func_178782_a();
        EnumFacing side = EnumFacing.func_82600_a((int)nbt.func_74771_c("lf"));
        nbt.func_74768_a("n", (int)Math.ceil(pos.func_185332_f(nbt.func_74762_e("lx") + side.func_82601_c(), nbt.func_74762_e("ly") + side.func_96559_d(), nbt.func_74762_e("lz") + side.func_82599_e())));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77978_p() != null;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        return (double)nbt.func_74762_e("n") / (double)MAX_LENGTH;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.func_77969_a(newStack);
    }
}

