/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.gui.ramio;

import cd4017be.rs_ctr.gui.ramio.BMPImage;
import cd4017be.rs_ctr.gui.ramio.IntelHex;
import cd4017be.rs_ctr.gui.ramio.PNGImage;
import cd4017be.rs_ctr.gui.ramio.RawBinary;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import net.minecraft.network.PacketBuffer;

public interface RAMImageFormat {
    public static final ArrayList<RAMImageFormat> REGISTRY = new ArrayList();
    public static final RAMImageFormat RAW_BINARY = new RawBinary();
    public static final RAMImageFormat INTEL_HEX = new IntelHex();
    public static final RAMImageFormat PNG_IMAGE = new PNGImage();
    public static final RAMImageFormat BMP_IMAGE = new BMPImage();

    public boolean applies(String var1);

    public String infoMessage(boolean var1, String var2, int var3, int var4, int var5);

    public void exportFile(FileOutputStream var1, ByteBuffer var2, int var3, int var4, int var5) throws IOException;

    public void importFile(FileInputStream var1, PacketBuffer var2, int[] var3, int var4, int var5) throws IOException;

    public static RAMImageFormat get(String filename) {
        for (RAMImageFormat fmt : REGISTRY) {
            if (!fmt.applies(filename)) continue;
            return fmt;
        }
        return RAW_BINARY;
    }
}

