/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.gui;

import cd4017be.api.rs_ctr.interact.IInteractiveComponent;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr.render.PortRenderer;
import java.util.List;
import java.util.function.IntConsumer;
import java.util.function.Supplier;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class BlockButton
implements IInteractiveComponent,
IInteractiveComponent.IBlockRenderComp {
    final IntConsumer action;
    final Supplier<String> getModel;
    final Supplier<String> getText;
    Vec3d pos = Vec3d.field_186680_a;
    Orientation face = Orientation.N;
    float width;
    float height;
    public static final int A_HIT = 1;
    public static final int A_SNEAKING = 2;

    public BlockButton(IntConsumer action, Supplier<String> model, Supplier<String> text) {
        this.action = action;
        this.getModel = model;
        this.getText = text;
    }

    public BlockButton setSize(float width, float height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public BlockButton setLocation(double x, double y, double z, Orientation o) {
        this.pos = o.rotate(new Vec3d(x - 0.5, y - 0.5, z - 0.5)).func_72441_c(0.5, 0.5, 0.5);
        this.face = o;
        return this;
    }

    public Pair<Vec3d, EnumFacing> rayTrace(Vec3d start, Vec3d dir) {
        return IInteractiveComponent.rayTraceFlat((Vec3d)start, (Vec3d)dir, (Vec3d)this.pos, (EnumFacing)this.face.front, (float)this.width, (float)this.height);
    }

    public boolean onInteract(EntityPlayer player, boolean hit, EnumFacing side, Vec3d aim) {
        if (this.action == null) {
            return false;
        }
        this.action.accept((hit ? 1 : 0) | (player.func_70093_af() ? 2 : 0));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(List<BakedQuad> quads) {
        PortRenderer.PORT_RENDER.drawModel(quads, (float)this.pos.field_72450_a, (float)this.pos.field_72448_b, (float)this.pos.field_72449_c, this.face, this.getModel.get());
    }

    public Pair<Vec3d, String> getDisplayText(Vec3d aim) {
        return Pair.of((Object)this.pos, (Object)this.getText.get());
    }
}

