/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.circuit.editor;

import cd4017be.lib.script.obj.Error;
import cd4017be.lib.script.obj.IOperand;
import cd4017be.lib.script.obj.Vector;
import cd4017be.rs_ctr.Main;
import cd4017be.rs_ctr.circuit.editor.GeneratedType;
import cd4017be.rscpl.editor.GateType;
import cd4017be.rscpl.editor.InstructionSet;
import cd4017be.rscpl.gui.Category;
import cd4017be.rscpl.util.IOUtils;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.util.ResourceLocation;

public class CircuitInstructionSet
extends InstructionSet
implements IOperand {
    public static final CircuitInstructionSet INS_SET = new CircuitInstructionSet();
    public static Category[] TABS = new Category[10];
    public static int nextTabId = 0;
    public final char[] OP_COSTS = new char[256];

    public static void registerTab(String name) {
        CircuitInstructionSet.TABS[CircuitInstructionSet.nextTabId++] = new Category(name);
    }

    public int getCost(GateType t) {
        return this.OP_COSTS[this.id(t)];
    }

    public boolean asBool() throws Error {
        return true;
    }

    public Object value() {
        return this;
    }

    public void put(IOperand idx, IOperand val) {
        Integer id;
        String key = idx.toString();
        if (key.indexOf(58) < 0) {
            key = "rs_ctr:" + key;
        }
        if ((id = (Integer)this.IDS.get(key)) == null || !(val instanceof Vector)) {
            return;
        }
        double[] v = ((Vector)val).value;
        this.OP_COSTS[id.intValue()] = (char)((int)v[0] & 0xFF | (int)v[1] << 8);
    }

    public void loadTabs() {
        for (Category c : TABS) {
            if (c == null) continue;
            InputStream is = IOUtils.getClassResource(new ResourceLocation(c.name), "/logic/tabs/", ".json");
            if (is == null) {
                Main.LOG.error("missing tab definition for {}", (Object)c.name);
                continue;
            }
            try (JsonReader jr = IOUtils.readJson(is);){
                jr.beginArray();
                while (jr.hasNext()) {
                    GateType t = this.getType(jr.nextString());
                    if (t == null) continue;
                    c.add(new GateType[]{t});
                }
                jr.endArray();
            }
            catch (IOException | IllegalStateException e) {
                Main.LOG.error("failed to load tab definition of " + c.name, (Throwable)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GateType getType(String name) {
        Integer id = (Integer)this.IDS.get(name);
        if (id != null) {
            return this.REGISTRY[id];
        }
        InputStream is = IOUtils.getClassResource(new ResourceLocation(name), "/logic/gates/", ".json");
        if (is == null) {
            Main.LOG.error("missing gate definition for {}", (Object)name);
            return null;
        }
        try (JsonReader jr = IOUtils.readJson(is);){
            GeneratedType generatedType = GeneratedType.read(name, jr, this);
            return generatedType;
        }
        catch (IOException e) {
            Main.LOG.error("failed to load gate definition of " + name, (Throwable)e);
            return null;
        }
    }
}

