/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.circuit;

import cd4017be.rs_ctr.Main;
import cd4017be.rscpl.util.IStateSerializable;
import cd4017be.rscpl.util.StateBuffer;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class Circuit
implements INBTSerializable<NBTTagCompound>,
IStateSerializable {
    protected UUID ID;
    protected int interruptPins;
    public int[] inputs;
    public int[] outputs;

    public abstract int tick();

    public boolean isInterrupt(int pin) {
        return (this.interruptPins >> pin & 1) != 0;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.ID != null) {
            nbt.func_74774_a("intpin", (byte)this.interruptPins);
            nbt.func_74783_a("in", this.inputs);
            nbt.func_74783_a("out", this.outputs);
            nbt.func_74782_a("state", (NBTBase)this.getState().nbt);
            nbt.func_74772_a("IDm", this.ID.getMostSignificantBits());
            nbt.func_74772_a("IDl", this.ID.getLeastSignificantBits());
        }
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.interruptPins = nbt.func_74771_c("intpin") & 0xFF;
        this.inputs = nbt.func_74759_k("in");
        this.outputs = nbt.func_74759_k("out");
        this.setState(new StateBuffer(nbt.func_74775_l("state")));
        if (nbt.func_74764_b("IDm")) {
            this.ID = new UUID(nbt.func_74763_f("IDm"), nbt.func_74763_f("IDl"));
        }
    }

    public String toString() {
        NBTTagCompound nbt;
        StringBuilder sb = new StringBuilder();
        sb.append("Serial-ID = ").append(this.ID);
        sb.append("\nInput signals = ").append(Arrays.toString(this.inputs));
        sb.append("\nOutput signals = ").append(Arrays.toString(this.outputs));
        try {
            nbt = this.getState().nbt;
        }
        catch (Exception e) {
            nbt = null;
        }
        sb.append("\nMemory states = ").append(nbt);
        return sb.toString();
    }

    public Circuit load() {
        return this;
    }

    public String processError(Throwable e, TileEntity host) {
        if (e instanceof ArithmeticException) {
            return e.getMessage();
        }
        if (e instanceof IndexOutOfBoundsException) {
            return "invalid index " + e.getMessage();
        }
        Main.LOG.error("Critical processor failure!", e);
        Main.LOG.error("Location: {}\nDevice details:\n{}", (Object)(host == null ? "debug environment" : host.func_174877_v()), (Object)this);
        return null;
    }
}

