/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import li.cil.oc.api.Driver;
import li.cil.oc.api.driver.DriverItem;
import li.cil.oc.api.internal.Colored;
import li.cil.oc.client.KeyBindings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.computronics.util.StringUtil;
import pl.asie.lib.reference.Capabilities;
import pl.asie.lib.util.ColorUtils;
import pl.asie.lib.util.internal.IColorable;

public class OCUtils {
    private static final int maxWidth = 220;
    private static final EnumRarity[] rarities = new EnumRarity[]{EnumRarity.COMMON, EnumRarity.UNCOMMON, EnumRarity.RARE, EnumRarity.EPIC};
    @CapabilityInject(value=Colored.class)
    public static Capability<Colored> COLORED_CAPABILITY;

    public static NBTTagCompound dataTag(ItemStack stack) {
        NBTTagCompound nbt;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!(nbt = stack.func_77978_p()).func_74764_b("oc:data")) {
            nbt.func_74782_a("oc:data", (NBTBase)new NBTTagCompound());
        }
        return nbt.func_74775_l("oc:data");
    }

    @SideOnly(value=Side.CLIENT)
    public static void addTooltip(ItemStack stack, List<String> tooltip, ITooltipFlag flag) {
        NBTTagCompound data;
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        String key = stack.func_77977_a() + ".tip";
        String tip = StringUtil.localize(key);
        if (!tip.equals(key)) {
            String[] lines = tip.split("\n");
            if (font == null) {
                Collections.addAll(tooltip, lines);
            } else {
                boolean shouldShorten;
                boolean bl = shouldShorten = font.func_78256_a(tip) > 220 && !KeyBindings.showExtendedTooltips();
                if (shouldShorten) {
                    tooltip.add(StringUtil.localizeAndFormat("oc:tooltip.toolong", KeyBindings.getKeyBindingName((KeyBinding)KeyBindings.extendedTooltip())));
                } else {
                    for (String line : lines) {
                        List list = font.func_78271_c(line, 220);
                        tooltip.addAll(list);
                    }
                }
            }
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("oc:data") && (data = stack.func_77978_p().func_74775_l("oc:data")).func_74764_b("node") && data.func_74775_l("node").func_74764_b("address")) {
            tooltip.add(TextFormatting.DARK_GRAY + data.func_74775_l("node").func_74779_i("address").substring(0, 13) + "..." + TextFormatting.GRAY);
        }
        if (flag.func_194127_a()) {
            DriverItem item = Driver.driverFor((ItemStack)stack);
            tooltip.add(StringUtil.localizeAndFormat("oc:tooltip.tier", item != null ? item.tier(stack) + 1 : 0));
        }
    }

    public static EnumRarity getRarityByTier(ItemStack stack) {
        DriverItem item = Driver.driverFor((ItemStack)stack);
        int tier = item != null ? Math.min(Math.max(item.tier(stack), 0), rarities.length - 1) : 0;
        return rarities[tier];
    }

    public static EnumRarity getRarityByTier(int tier) {
        return rarities[Math.min(Math.max(tier, 0), rarities.length - 1)];
    }

    @Nullable
    public static IColorable getColorable(@Nullable ICapabilityProvider provider, EnumFacing side) {
        if (provider != null && provider.hasCapability(Capabilities.COLORABLE_CAPABILITY, side)) {
            return (IColorable)provider.getCapability(Capabilities.COLORABLE_CAPABILITY, side);
        }
        if (provider != null && provider.hasCapability(COLORED_CAPABILITY, side)) {
            return new ConvertedColorable((Colored)provider.getCapability(COLORED_CAPABILITY, side));
        }
        return null;
    }

    public static class ConvertedColorable
    implements IColorable {
        private final Colored colored;

        public ConvertedColorable(Colored colored) {
            this.colored = colored;
        }

        @Override
        public boolean canBeColored() {
            return this.colored.controlsConnectivity();
        }

        @Override
        public int getColor() {
            return this.colored.getColor();
        }

        @Override
        public int getDefaultColor() {
            return ColorUtils.Color.LightGray.color;
        }

        @Override
        public void setColor(int color) {
            this.colored.setColor(color);
        }
    }

    public static final class Vendors {
        public static final String ACME = "ACME Co.";
        public static final String BuildCraft = "BuildCraft, Inc.";
        public static final String DFKI = "DFKI GmbH";
        public static final String Hosencorp = "Hosencorp AG";
        public static final String HuggingCreeper = "Hugging Creeper Industries";
        public static final String Lumiose = "Lumiose Lighting";
        public static final String NSA = "National Security Agency";
        public static final String Railcraft = "Railcraft, Inc.";
        public static final String Siekierka = "Siekierka Innovations";
        public static final String Soluna = "Soluna Technologies";
        public static final String Trumbour = "Trumbour Technology";
        public static final String Yanaki = "Yanaki Sound Systems";

        private Vendors() {
        }
    }

    public static class Device {
        private final String Class;
        private final String Description;
        private final String Vendor;
        private final String Product;
        private final String[] other;

        public Device(String Class2, String Description, String Vendor, String Product, String ... other) {
            this.Class = Class2;
            this.Description = Description;
            this.Vendor = Vendor;
            this.Product = Product;
            this.other = other;
        }

        public Map<String, String> deviceInfo() {
            HashMap<String, String> deviceInfo = new HashMap<String, String>();
            deviceInfo.put("class", this.Class);
            deviceInfo.put("description", this.Description);
            deviceInfo.put("vendor", this.Vendor);
            deviceInfo.put("product", this.Product);
            int i = 0;
            while (i + 1 < this.other.length) {
                deviceInfo.put(this.other[i], this.other[i + 1]);
                i += 2;
            }
            return deviceInfo;
        }
    }
}

