/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.tile;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nullable;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.properties.IProperty;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Optional;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.api.audio.AudioPacket;
import pl.asie.computronics.api.audio.AudioPacketDFPWM;
import pl.asie.computronics.api.audio.IAudioReceiver;
import pl.asie.computronics.api.audio.IAudioSource;
import pl.asie.computronics.audio.AudioUtils;
import pl.asie.computronics.audio.tts.TextToSpeech;
import pl.asie.computronics.integration.charset.audio.IntegrationCharsetAudio;
import pl.asie.computronics.reference.Capabilities;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.reference.Mods;
import pl.asie.computronics.tile.TileEntityPeripheralBase;
import pl.asie.computronics.util.ColorUtils;
import pl.asie.computronics.util.OCUtils;
import pl.asie.lib.util.internal.IColorable;

public class TileSpeechBox
extends TileEntityPeripheralBase
implements IAudioSource,
ITickable,
TextToSpeech.ICanSpeak {
    private final IAudioReceiver internalSpeaker = new IAudioReceiver(){

        @Override
        public boolean connectsAudio(EnumFacing side) {
            return true;
        }

        @Override
        public World getSoundWorld() {
            return TileSpeechBox.this.field_145850_b;
        }

        @Override
        public Vec3d getSoundPos() {
            return new Vec3d((double)TileSpeechBox.this.field_174879_c.func_177958_n() + 0.5, (double)TileSpeechBox.this.field_174879_c.func_177956_o() + 0.5, (double)TileSpeechBox.this.field_174879_c.func_177952_p() + 0.5);
        }

        @Override
        public int getSoundDistance() {
            return Config.TAPEDRIVE_DISTANCE;
        }

        @Override
        public void receivePacket(AudioPacket packet, @Nullable EnumFacing direction) {
            packet.addReceiver(this);
        }

        @Override
        public String getID() {
            return AudioUtils.positionId(TileSpeechBox.this.func_174877_v());
        }
    };
    private long lastCodecTime;
    private int codecId = -1;
    protected int packetSize = 1500;
    protected int soundVolume = 127;
    private boolean locked = false;
    private ByteArrayInputStream storage;

    public TileSpeechBox() {
        super("speech_box");
    }

    public void func_73660_a() {
        super.update();
        AudioPacket pkt = null;
        long time = System.nanoTime();
        if (time - 250000000L > this.lastCodecTime) {
            this.lastCodecTime += 250000000L;
            pkt = this.createMusicPacket(this);
        }
        if (pkt != null) {
            int receivers = 0;
            boolean sent = false;
            if (Mods.API.hasAPI("CharsetAPI|Audio")) {
                int oldReceivers = receivers;
                if ((receivers += IntegrationCharsetAudio.send((IBlockAccess)this.func_145831_w(), this.func_174877_v(), pkt, this.getVolume(), true)) > oldReceivers) {
                    sent = true;
                }
            }
            if (!sent) {
                for (EnumFacing dir : EnumFacing.field_82609_l) {
                    IColorable targetCol;
                    TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(dir));
                    if (tile == null || !tile.hasCapability(Capabilities.AUDIO_RECEIVER_CAPABILITY, dir.func_176734_d()) || (targetCol = ColorUtils.getColorable((ICapabilityProvider)tile, dir.func_176734_d())) != null && targetCol.canBeColored() && !ColorUtils.isSameOrDefault(this, targetCol)) continue;
                    ((IAudioReceiver)tile.getCapability(Capabilities.AUDIO_RECEIVER_CAPABILITY, dir.func_176734_d())).receivePacket(pkt, dir.func_176734_d());
                    ++receivers;
                }
                if (receivers == 0) {
                    this.internalSpeaker.receivePacket(pkt, null);
                }
                pkt.sendPacket();
            }
        }
    }

    @Override
    public void startTalking(byte[] data) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.storage = new ByteArrayInputStream(data);
        this.codecId = Computronics.instance.audio.newPlayer();
        Computronics.instance.audio.getPlayer(this.codecId);
        this.lastCodecTime = System.nanoTime();
    }

    private void stopTalking() {
        if (this.func_145830_o() && this.field_145850_b.field_72995_K) {
            return;
        }
        AudioUtils.removePlayer(Computronics.instance.managerId, this.codecId);
        this.locked = false;
        this.storage = null;
    }

    private Object[] sendNewText(String text) throws IOException {
        if (Computronics.tts == null) {
            return new Object[]{false, "text-to-speech system not available"};
        }
        this.locked = true;
        Computronics.tts.say(this, text);
        return new Object[]{true};
    }

    @Nullable
    private AudioPacket createMusicPacket(IAudioSource source) {
        if (this.storage == null) {
            return null;
        }
        byte[] pktData = new byte[this.packetSize];
        int amount = this.storage.read(pktData, 0, pktData.length);
        if (amount > 0) {
            return new AudioPacketDFPWM(source, (byte)this.soundVolume, this.packetSize * 8 * 4, amount == this.packetSize ? pktData : Arrays.copyOf(pktData, amount));
        }
        this.stopTalking();
        return null;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.soundVolume = tag.func_74764_b("vo") ? (int)tag.func_74771_c("vo") : 127;
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (this.soundVolume != 127) {
            tag.func_74774_a("vo", (byte)this.soundVolume);
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.stopTalking();
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        this.stopTalking();
    }

    public void setVolume(float volume) {
        if (volume < 0.0f) {
            volume = 0.0f;
        }
        if (volume > 1.0f) {
            volume = 1.0f;
        }
        this.soundVolume = (int)Math.floor(volume * 127.0f);
    }

    @Callback(doc="function(text:string):boolean; Say the specified message. Returns true on success, false and an error message otherwise.")
    @Optional.Method(modid="opencomputers")
    public Object[] say(Context context, Arguments args) {
        if (this.locked || this.storage != null) {
            return new Object[]{false, "already processing"};
        }
        String text = args.checkString(0);
        if (text.length() > Config.TTS_MAX_LENGTH) {
            return new Object[]{false, "text too long"};
        }
        try {
            return this.sendNewText(text);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("could not send string");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Callback(doc="function():boolean; Stops the currently spoken phrase. Returns true on success, false and an error message otherwise.")
    @Optional.Method(modid="opencomputers")
    public Object[] stop(Context context, Arguments args) {
        if (this.locked || this.storage != null) {
            this.stopTalking();
            return new Object[]{true};
        }
        return new Object[]{false, "not talking"};
    }

    @Callback(doc="function():boolean; Returns true if the device is currently processing text.", direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] isProcessing(Context context, Arguments args) {
        return new Object[]{this.locked || this.storage != null};
    }

    @Callback(doc="function(speed:number); Sets the volume of the speech box. Needs to be beween 0 and 1")
    @Optional.Method(modid="opencomputers")
    public Object[] setVolume(Context context, Arguments args) {
        this.setVolume((float)args.checkDouble(0));
        return new Object[0];
    }

    @Optional.Method(modid="computercraft")
    public String[] getMethodNames() {
        return new String[]{"say", "stop", "isProcessing", "setVolume"};
    }

    @Optional.Method(modid="computercraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        switch (method) {
            case 0: {
                if (arguments.length < 1 || !(arguments[0] instanceof String)) {
                    throw new LuaException("first argument needs to be a string");
                }
                if (this.locked || this.storage != null) {
                    return new Object[]{false, "already processing"};
                }
                String text = (String)arguments[0];
                if (text.length() > Config.TTS_MAX_LENGTH) {
                    return new Object[]{false, "text too long"};
                }
                try {
                    return this.sendNewText(text);
                }
                catch (IOException e) {
                    throw new LuaException("could not send string");
                }
            }
            case 1: {
                if (this.locked || this.storage != null) {
                    this.stopTalking();
                    return new Object[]{true};
                }
                return new Object[]{false, "not talking"};
            }
            case 2: {
                return new Object[]{this.locked || this.storage != null};
            }
            case 3: {
                if (arguments.length < 1 || !(arguments[0] instanceof Number)) {
                    throw new LuaException("first argument needs to be a number");
                }
                this.setVolume(((Number)arguments[0]).floatValue());
                return new Object[0];
            }
        }
        return new Object[0];
    }

    @Override
    @Optional.Method(modid="opencomputers")
    protected OCUtils.Device deviceInfo() {
        return new OCUtils.Device("multimedia", "Text-To-Speech Interface", "DFKI GmbH", "Mary", new String[0]);
    }

    @Override
    public int getSourceId() {
        return this.codecId;
    }

    @Override
    public boolean connectsAudio(EnumFacing side) {
        return this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)Computronics.speechBox.rotation.FACING) != side;
    }
}

