/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.tile;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.fml.common.Optional;
import pl.asie.computronics.api.chat.ChatAPI;
import pl.asie.computronics.api.chat.IChatListener;
import pl.asie.computronics.block.BlockChatBox;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.reference.Mods;
import pl.asie.computronics.tile.TileEntityPeripheralBase;
import pl.asie.computronics.util.ChatBoxUtils;
import pl.asie.computronics.util.OCUtils;

public class TileChatBox
extends TileEntityPeripheralBase
implements IChatListener,
ITickable {
    private int distance = Config.CHATBOX_DISTANCE;
    private boolean hasDistance = false;
    private int ticksUntilOff = 0;
    private boolean mustRefresh = false;
    private String name = "";

    public TileChatBox() {
        super("chat_box");
    }

    @Override
    public int requestCurrentRedstoneValue(EnumFacing side) {
        return this.ticksUntilOff > 0 ? 15 : 0;
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState != newState;
    }

    public boolean isCreative() {
        BlockPos pos = this.func_174877_v();
        if (Config.CHATBOX_CREATIVE && this.field_145850_b != null && this.field_145850_b.func_175667_e(pos)) {
            IBlockState state = this.field_145850_b.func_180495_p(pos);
            return (Boolean)state.func_177229_b((IProperty)BlockChatBox.CREATIVE);
        }
        return false;
    }

    public void func_73660_a() {
        super.update();
        if (Config.REDSTONE_REFRESH && this.ticksUntilOff > 0) {
            --this.ticksUntilOff;
            if (this.ticksUntilOff == 0 || this.mustRefresh) {
                this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q(), true);
            }
        }
    }

    public int getDistance() {
        return this.distance;
    }

    public void setDistance(int dist) {
        if (dist > Short.MAX_VALUE) {
            dist = Short.MAX_VALUE;
        }
        this.distance = !this.isCreative() ? Math.min(Config.CHATBOX_DISTANCE, dist) : dist;
        this.hasDistance = true;
        if (this.distance < 0) {
            this.distance = Config.CHATBOX_DISTANCE;
            this.hasDistance = false;
        }
    }

    @Override
    public void receiveChatMessage(ServerChatEvent event) {
        if (!this.field_145850_b.func_175667_e(this.func_174877_v())) {
            return;
        }
        if (!(Config.CHATBOX_MAGIC || this.isCreative() || event.getPlayer().field_70170_p == this.field_145850_b && !(event.getPlayer().func_174818_b(this.func_174877_v()) > (double)(this.distance * this.distance)))) {
            return;
        }
        if (Config.REDSTONE_REFRESH) {
            this.ticksUntilOff = 5;
            this.mustRefresh = true;
        }
        if (Mods.isLoaded("opencomputers")) {
            this.eventOC(event);
        }
        if (Mods.isLoaded("computercraft")) {
            this.eventCC(event);
        }
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        ChatAPI.registry.registerChatListener(this);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        ChatAPI.registry.unregisterChatListener(this);
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        ChatAPI.registry.unregisterChatListener(this);
    }

    @Optional.Method(modid="opencomputers")
    public void eventOC(ServerChatEvent event) {
        if (this.node() != null) {
            this.node().sendToReachable("computer.signal", new Object[]{"chat_message", event.getUsername(), event.getMessage()});
        }
    }

    @Optional.Method(modid="computercraft")
    public void eventCC(ServerChatEvent event) {
        if (this.attachedComputersCC != null) {
            for (IComputerAccess computer : this.attachedComputersCC) {
                computer.queueEvent("chat_message", new Object[]{computer.getAttachmentName(), event.getUsername(), event.getMessage()});
            }
        }
    }

    @Override
    @Optional.Method(modid="opencomputers")
    protected OCUtils.Device deviceInfo() {
        return new OCUtils.Device("multimedia", "Chat interface", "National Security Agency", "[CLASSIFIED]", new String[0]);
    }

    @Callback(doc="function(text:string [, distance:number]):boolean; Makes the chat box say some text with the currently set or the specified distance. Returns true on success")
    @Optional.Method(modid="opencomputers")
    public Object[] say(Context context, Arguments args) {
        int d = this.distance;
        if (args.count() >= 1) {
            boolean isCreative = this.isCreative();
            boolean hasDistance = this.hasDistance;
            if (args.isInteger(1)) {
                int n = d = isCreative ? args.checkInteger(1) : Math.min(Config.CHATBOX_DISTANCE, args.checkInteger(1));
                if (d <= 0) {
                    d = this.distance;
                }
                hasDistance = true;
            }
            if (args.isString(0)) {
                ChatBoxUtils.sendChatMessage(this, d, this.name.length() > 0 ? this.name : Config.CHATBOX_PREFIX, args.checkString(0), !hasDistance && (Config.CHATBOX_MAGIC || isCreative));
                return new Object[]{true};
            }
        }
        return new Object[]{false};
    }

    @Callback(doc="function():number; Returns the chat distance the chat box is currently set to", direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getDistance(Context context, Arguments args) {
        return new Object[]{this.distance};
    }

    @Callback(doc="function(distance:number):number; Sets the distance of the chat box. Returns the new distance", direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] setDistance(Context context, Arguments args) {
        this.setDistance(args.checkInteger(0));
        return new Object[]{this.distance};
    }

    @Callback(doc="function():string; Returns the name of the chat box", direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getName(Context context, Arguments args) {
        return new Object[]{this.name};
    }

    @Callback(doc="function(name:string):string; Sets the name of the chat box. Returns the new name", direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] setName(Context context, Arguments args) {
        this.name = args.checkString(0);
        return new Object[]{this.name};
    }

    @Override
    public boolean canBeColored() {
        return !this.isCreative() && super.canBeColored();
    }

    @Override
    public int getColor() {
        int color = super.getColor();
        if (this.isCreative()) {
            return 0xFF60FF;
        }
        return color;
    }

    @Override
    public void setColor(int color) {
        if (this.isCreative()) {
            super.setColor(0xFF60FF);
        } else {
            super.setColor(color);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("d")) {
            this.distance = nbt.func_74765_d("d");
        }
        if (nbt.func_74764_b("hd")) {
            this.hasDistance = nbt.func_74767_n("hd");
        }
        if (nbt.func_74764_b("n")) {
            this.name = nbt.func_74779_i("n");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74777_a("d", (short)this.distance);
        nbt.func_74757_a("hd", this.hasDistance);
        if (this.name.length() > 0) {
            nbt.func_74778_a("n", this.name);
        }
        return nbt;
    }

    @Optional.Method(modid="computercraft")
    public String[] getMethodNames() {
        return new String[]{"say", "getDistance", "setDistance", "getName", "setName"};
    }

    @Optional.Method(modid="computercraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        switch (method) {
            case 0: {
                if (arguments.length >= 1 && arguments[0] instanceof String) {
                    int d = this.distance;
                    boolean hasDistance = this.hasDistance;
                    boolean isCreative = this.isCreative();
                    if (arguments.length >= 2 && arguments[1] instanceof Double) {
                        int n = d = isCreative ? ((Double)arguments[1]).intValue() : Math.min(Config.CHATBOX_DISTANCE, ((Double)arguments[1]).intValue());
                        if (d <= 0) {
                            d = this.distance;
                        }
                        hasDistance = true;
                    }
                    ChatBoxUtils.sendChatMessage(this, d, this.name.length() > 0 ? this.name : Config.CHATBOX_PREFIX, (String)arguments[0], !hasDistance && (Config.CHATBOX_MAGIC || isCreative));
                    return new Object[]{true};
                }
                return new Object[]{false};
            }
            case 1: {
                return new Object[]{this.distance};
            }
            case 2: {
                if (arguments.length == 1 && arguments[0] instanceof Double) {
                    this.setDistance(((Double)arguments[0]).intValue());
                    return new Object[]{this.distance};
                }
                throw new LuaException("first argument needs to be a number");
            }
            case 3: {
                return new Object[]{this.name};
            }
            case 4: {
                if (arguments.length == 1 && arguments[0] instanceof String) {
                    this.name = (String)arguments[0];
                    return new Object[]{this.name};
                }
                throw new LuaException("first argument needs to be a string");
            }
        }
        return null;
    }
}

