/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.oc.manual;

import java.util.ArrayList;
import java.util.Collections;
import li.cil.oc.api.Manual;
import li.cil.oc.api.manual.ContentProvider;
import li.cil.oc.api.manual.PathProvider;
import li.cil.oc.api.manual.TabIconRenderer;
import li.cil.oc.api.prefab.ItemStackTabIconRenderer;
import li.cil.oc.api.prefab.ResourceContentProvider;
import li.cil.oc.api.prefab.TextureTabIconRenderer;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.oc.manual.IBlockWithDocumentation;
import pl.asie.computronics.oc.manual.IBlockWithPrefix;
import pl.asie.computronics.oc.manual.IItemWithDocumentation;
import pl.asie.computronics.oc.manual.IItemWithPrefix;

public class ComputronicsPathProvider
implements PathProvider {
    public static void initialize() {
        Manual.addProvider((PathProvider)new ComputronicsPathProvider());
        Manual.addProvider((ContentProvider)new ResourceContentProvider("computronics", "doc/opencomputers/"));
        Manual.addTab((TabIconRenderer)ComputronicsPathProvider.findTabIconRenderer(), (String)"tooltip.computronics.manual.oc.tab.blocks", (String)"computronics/%LANGUAGE%/block/index.md");
        Manual.addTab((TabIconRenderer)new TextureTabIconRenderer(new ResourceLocation("computronics", "textures/items/tape_steel.png")), (String)"tooltip.computronics.manual.oc.tab.items", (String)"computronics/%LANGUAGE%/item/index.md");
    }

    private static TabIconRenderer findTabIconRenderer() {
        ArrayList blocks = new ArrayList();
        Collections.addAll(blocks, Computronics.tapeReader, Computronics.colorfulLamp, Computronics.camera, Computronics.chatBox, Computronics.ironNote, Computronics.cipher, Computronics.radar, Computronics.cipher_advanced);
        for (Block block : blocks) {
            if (block == null) continue;
            return new ItemStackTabIconRenderer(new ItemStack(block));
        }
        return new TextureTabIconRenderer(new ResourceLocation("computronics", "textures/blocks/tape_drive_front.png"));
    }

    public String pathFor(ItemStack stack) {
        Block block;
        if (stack.func_190926_b() || stack.func_77973_b() == null) {
            return null;
        }
        if (stack.func_77973_b() instanceof IItemWithDocumentation) {
            return this.makePath("item", stack.func_77973_b() instanceof IItemWithPrefix ? ((IItemWithPrefix)stack.func_77973_b()).getPrefix(stack) + ((IItemWithDocumentation)stack.func_77973_b()).getDocumentationName(stack) : ((IItemWithDocumentation)stack.func_77973_b()).getDocumentationName(stack));
        }
        if (stack.func_77973_b() instanceof ItemBlock && (block = Block.func_149634_a((Item)stack.func_77973_b())) != null && block instanceof IBlockWithDocumentation) {
            return this.makePath("block", block instanceof IBlockWithPrefix ? ((IBlockWithPrefix)block).getPrefix(stack) + ((IBlockWithDocumentation)block).getDocumentationName(stack) : ((IBlockWithDocumentation)block).getDocumentationName(stack));
        }
        return null;
    }

    public String pathFor(World world, BlockPos pos) {
        if (world == null) {
            return null;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block instanceof IBlockWithDocumentation) {
            return this.makePath("block", block instanceof IBlockWithPrefix ? ((IBlockWithPrefix)block).getPrefix(world, pos) + ((IBlockWithDocumentation)block).getDocumentationName(world, pos) : ((IBlockWithDocumentation)block).getDocumentationName(world, pos));
        }
        return null;
    }

    private String makePath(String type, String documentationName) {
        return "computronics/%LANGUAGE%/" + type + "/" + documentationName + ".md";
    }
}

