/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.oc.driver;

import javax.annotation.Nullable;
import li.cil.oc.api.Network;
import li.cil.oc.api.internal.Rotatable;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.EnvironmentHost;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Visibility;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Optional;
import pl.asie.charset.api.audio.IAudioSource;
import pl.asie.computronics.api.audio.AudioPacket;
import pl.asie.computronics.api.audio.IAudioReceiver;
import pl.asie.computronics.audio.AudioUtils;
import pl.asie.computronics.audio.SoundCardPacket;
import pl.asie.computronics.integration.charset.audio.IntegrationCharsetAudio;
import pl.asie.computronics.oc.driver.ManagedEnvironmentWithComponentConnector;
import pl.asie.computronics.reference.Capabilities;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.reference.Mods;
import pl.asie.computronics.util.ColorUtils;
import pl.asie.computronics.util.OCUtils;
import pl.asie.computronics.util.sound.Instruction;
import pl.asie.computronics.util.sound.SoundBoard;
import pl.asie.lib.util.internal.IColorable;

public class DriverCardSound
extends ManagedEnvironmentWithComponentConnector
implements pl.asie.computronics.api.audio.IAudioSource,
ICapabilityProvider,
SoundBoard.ISoundHost {
    protected final EnvironmentHost host;
    protected final SoundBoard board;
    private final IAudioReceiver internalSpeaker = new IAudioReceiver(){

        @Override
        public boolean connectsAudio(EnumFacing side) {
            return true;
        }

        @Override
        public World getSoundWorld() {
            return DriverCardSound.this.host.world();
        }

        @Override
        public Vec3d getSoundPos() {
            return new Vec3d(DriverCardSound.this.host.xPosition(), DriverCardSound.this.host.yPosition(), DriverCardSound.this.host.zPosition());
        }

        @Override
        public int getSoundDistance() {
            return Config.SOUND_RADIUS;
        }

        @Override
        public void receivePacket(AudioPacket packet, @Nullable EnumFacing direction) {
            packet.addReceiver(this);
        }

        @Override
        public String getID() {
            return DriverCardSound.this.host instanceof TileEntity ? AudioUtils.positionId(DriverCardSound.this.host.xPosition(), DriverCardSound.this.host.yPosition(), DriverCardSound.this.host.zPosition()) : "";
        }
    };
    private Object charsetAudioSource;

    public DriverCardSound(EnvironmentHost host) {
        this.host = host;
        this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Neighbors).withComponent("sound").withConnector().create());
        this.board = new SoundBoard(this);
    }

    public boolean canUpdate() {
        return !this.host.world().field_72995_K;
    }

    public void update() {
        this.board.update();
    }

    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        this.board.load(nbt);
    }

    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        if (this.host.world().field_72995_K) {
            this.board.save(nbt);
        }
    }

    public void onMessage(Message message) {
        if ((message.name().equals("computer.stopped") || message.name().equals("computer.started")) && this.node().isNeighborOf(message.source())) {
            this.board.clearAndStop();
        }
    }

    protected int checkChannel(Arguments args, int index) {
        return this.board.checkChannel(args.checkInteger(index));
    }

    protected int checkChannel(Arguments args) {
        return this.checkChannel(args, 0);
    }

    @Callback(doc="This is a bidirectional table of all valid modes.", direct=true, getter=true)
    public Object[] modes(Context context, Arguments args) {
        return new Object[]{SoundBoard.compileModes()};
    }

    @Callback(doc="This is the number of channels this card provides.", direct=true, getter=true)
    public Object[] channel_count(Context context, Arguments args) {
        return new Object[]{this.board.process.states.size()};
    }

    @Callback(doc="function(volume:number); Sets the general volume of the entire sound card to a value between 0 and 1. Not an instruction, this affects all channels directly.", direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] setTotalVolume(Context context, Arguments args) {
        this.board.setTotalVolume(args.checkDouble(0));
        return new Object[0];
    }

    @Callback(doc="function(); Clears the instruction queue.", direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] clear(Context context, Arguments args) {
        this.board.clear();
        return new Object[0];
    }

    @Callback(doc="function(channel:number); Instruction; Opens the specified channel, allowing sound to be generated.", direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] open(Context context, Arguments args) {
        return this.board.tryAdd(new Instruction.Open(this.checkChannel(args)));
    }

    @Callback(doc="function(channel:number); Instruction; Closes the specified channel, stopping sound from being generated.", direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] close(Context context, Arguments args) {
        return this.board.tryAdd(new Instruction.Close(this.checkChannel(args)));
    }

    @Callback(doc="function(channel:number, type:number); Instruction; Sets the wave type on the specified channel.", direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] setWave(Context context, Arguments args) {
        return this.board.setWave(args.checkInteger(0), args.checkInteger(1));
    }

    @Callback(doc="function(channel:number, frequency:number); Instruction; Sets the frequency on the specified channel.", direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] setFrequency(Context context, Arguments args) {
        return this.board.tryAdd(new Instruction.SetFrequency(this.checkChannel(args), (float)args.checkDouble(1)));
    }

    @Callback(doc="function(channel:number, initial:number, mask:number); Instruction; Makes the specified channel generate LFSR noise. Functions like a wave type.", direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] setLFSR(Context context, Arguments args) {
        return this.board.tryAdd(new Instruction.SetLFSR(this.checkChannel(args), args.checkInteger(1), args.checkInteger(2)));
    }

    @Callback(doc="function(duration:number); Instruction; Adds a delay of the specified duration in milliseconds, allowing sound to generate.", direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] delay(Context context, Arguments args) {
        return this.board.delay(args.checkInteger(0));
    }

    @Callback(doc="function(channel:number, modIndex:number, intensity:number); Instruction; Assigns a frequency modulator channel to the specified channel with the specified intensity.", direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] setFM(Context context, Arguments args) {
        return this.board.tryAdd(new Instruction.SetFM(this.checkChannel(args), this.checkChannel(args, 1), (float)args.checkDouble(2)));
    }

    @Callback(doc="function(channel:number); Instruction; Removes the specified channel's frequency modulator.", direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] resetFM(Context context, Arguments args) {
        return this.board.tryAdd(new Instruction.ResetFM(this.checkChannel(args)));
    }

    @Callback(doc="function(channel:number, modIndex:number); Instruction; Assigns an amplitude modulator channel to the specified channel.", direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] setAM(Context context, Arguments args) {
        return this.board.tryAdd(new Instruction.SetAM(this.checkChannel(args), this.checkChannel(args, 1)));
    }

    @Callback(doc="function(channel:number); Instruction; Removes the specified channel's amplitude modulator.", direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] resetAM(Context context, Arguments args) {
        return this.board.tryAdd(new Instruction.ResetAM(this.checkChannel(args)));
    }

    @Callback(doc="function(channel:number, attack:number, decay:number, attenuation:number, release:number); Instruction; Assigns ADSR to the specified channel with the specified phase durations in milliseconds and attenuation between 0 and 1.", direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] setADSR(Context context, Arguments args) {
        return this.board.tryAdd(new Instruction.SetADSR(this.checkChannel(args), args.checkInteger(1), args.checkInteger(2), (float)args.checkDouble(3), args.checkInteger(4)));
    }

    @Callback(doc="function(channel:number); Instruction; Removes ADSR from the specified channel.", direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] resetEnvelope(Context context, Arguments args) {
        return this.board.tryAdd(new Instruction.ResetEnvelope(this.checkChannel(args)));
    }

    @Callback(doc="function(channel:number, volume:number); Instruction; Sets the volume of the channel between 0 and 1.", direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] setVolume(Context context, Arguments args) {
        return this.board.tryAdd(new Instruction.SetVolume(this.checkChannel(args), (float)args.checkDouble(1)));
    }

    @Callback(doc="function(); Starts processing the queue; Returns true is processing began, false if there is still a queue being processed.", direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] process(Context context, Arguments args) {
        return this.board.process();
    }

    @Override
    public void sendMusicPacket(SoundCardPacket pkt) {
        int receivers = 0;
        boolean sent = false;
        if (this.host instanceof TileEntity && Mods.API.hasAPI("CharsetAPI|Audio")) {
            int oldReceivers = receivers;
            if ((receivers += IntegrationCharsetAudio.send((IBlockAccess)this.host.world(), ((TileEntity)this.host).func_174877_v(), pkt, 1.0f, true)) > oldReceivers) {
                sent = true;
            }
        }
        if (!sent) {
            if (this.host instanceof TileEntity) {
                for (EnumFacing dir : EnumFacing.field_82609_l) {
                    TileEntity tile = this.host.world().func_175625_s(((TileEntity)this.host).func_174877_v().func_177972_a(dir));
                    if (tile == null || !tile.hasCapability(Capabilities.AUDIO_RECEIVER_CAPABILITY, dir.func_176734_d())) continue;
                    IColorable hostCol = ColorUtils.getColorable((ICapabilityProvider)((TileEntity)this.host), dir);
                    IColorable targetCol = ColorUtils.getColorable((ICapabilityProvider)tile, dir.func_176734_d());
                    if (hostCol != null && targetCol != null && hostCol.canBeColored() && targetCol.canBeColored() && !ColorUtils.isSameOrDefault(hostCol, targetCol)) continue;
                    ((IAudioReceiver)tile.getCapability(Capabilities.AUDIO_RECEIVER_CAPABILITY, dir.func_176734_d())).receivePacket(pkt, dir.func_176734_d());
                    ++receivers;
                }
            }
            if (receivers == 0) {
                this.internalSpeaker.receivePacket(pkt, null);
            }
            pkt.sendPacket();
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        EnumFacing enumFacing = facing = this.host instanceof Rotatable ? ((Rotatable)this.host).toGlobal(facing) : facing;
        if (Mods.API.hasAPI("CharsetAPI|Audio") && capability == IntegrationCharsetAudio.SOURCE_CAPABILITY && facing != null && this.connectsAudio(facing)) {
            return true;
        }
        return capability == Capabilities.AUDIO_SOURCE_CAPABILITY && facing != null && this.connectsAudio(facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        EnumFacing enumFacing = facing = this.host instanceof Rotatable ? ((Rotatable)this.host).toGlobal(facing) : facing;
        if (Mods.API.hasAPI("CharsetAPI|Audio") && capability == IntegrationCharsetAudio.SOURCE_CAPABILITY && facing != null && this.connectsAudio(facing)) {
            if (this.charsetAudioSource == null) {
                this.charsetAudioSource = new IAudioSource(){};
            }
            return (T)IntegrationCharsetAudio.SOURCE_CAPABILITY.cast((Object)((IAudioSource)this.charsetAudioSource));
        }
        if (capability == Capabilities.AUDIO_SOURCE_CAPABILITY && facing != null && this.connectsAudio(facing)) {
            return (T)Capabilities.AUDIO_SOURCE_CAPABILITY.cast((Object)this);
        }
        return null;
    }

    @Override
    public boolean connectsAudio(EnumFacing side) {
        if (this.host instanceof TileEntity) {
            IColorable hostCol = ColorUtils.getColorable((ICapabilityProvider)((TileEntity)this.host), side);
            IColorable targetCol = ColorUtils.getColorable((ICapabilityProvider)this.host.world().func_175625_s(((TileEntity)this.host).func_174877_v().func_177972_a(side)), side.func_176734_d());
            if (hostCol != null && targetCol != null && hostCol.canBeColored() && targetCol.canBeColored()) {
                return ColorUtils.isSameOrDefault(hostCol, targetCol);
            }
        }
        return true;
    }

    @Override
    public int getSourceId() {
        return this.board.codecId;
    }

    @Override
    protected OCUtils.Device deviceInfo() {
        return new OCUtils.Device("multimedia", "Audio interface", "Yanaki Sound Systems", "MinoSound 244-X", new String[0]);
    }

    @Override
    public World world() {
        return this.host.world();
    }

    @Override
    public boolean tryConsumeEnergy(double energy) {
        return this.node.tryChangeBuffer(-energy);
    }

    @Override
    public String address() {
        return this.node().address();
    }

    @Override
    public Vec3d position() {
        return new Vec3d(this.host.xPosition(), this.host.yPosition(), this.host.zPosition());
    }

    @Override
    public void setDirty() {
    }
}

