/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.railcraft.tile;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.SidedEnvironment;
import mods.railcraft.api.carts.CartToolsAPI;
import mods.railcraft.common.carts.EntityLocomotive;
import mods.railcraft.common.carts.IRailcraftCartContainer;
import mods.railcraft.common.carts.RailcraftCarts;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import pl.asie.computronics.cc.ISidedPeripheral;
import pl.asie.computronics.reference.Mods;
import pl.asie.computronics.tile.TileEntityPeripheralBase;
import pl.asie.computronics.util.OCUtils;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SidedEnvironment", modid="opencomputers")})
public class TileDigitalDetector
extends TileEntityPeripheralBase
implements SidedEnvironment,
ISidedPeripheral,
ITickable {
    public EnumFacing direction;
    private List<EntityMinecart> currentCarts = new ArrayList<EntityMinecart>();

    public TileDigitalDetector() {
        super("digital_detector");
        this.direction = EnumFacing.UP;
    }

    public void func_73660_a() {
        super.update();
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        List carts = CartToolsAPI.getMinecartsOnAllSides((World)this.field_145850_b, (BlockPos)this.func_174877_v(), (float)0.2f);
        for (EntityMinecart cart : carts) {
            if (this.currentCarts.contains(cart)) continue;
            ArrayList<Object> info = new ArrayList<Object>();
            this.appendCartType(info, cart);
            this.appendLocomotiveInformation(info, cart);
            if (Mods.isLoaded("opencomputers")) {
                this.eventOC(info);
            }
            if (!Mods.isLoaded("computercraft")) continue;
            this.eventCC(info);
        }
        this.currentCarts.clear();
        this.currentCarts = carts;
    }

    @Override
    public boolean canBeColored() {
        return false;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        data = super.func_189515_b(data);
        data.func_74774_a("direction", (byte)this.direction.ordinal());
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.direction = data.func_74764_b("direction") ? EnumFacing.func_82600_a((int)data.func_74771_c("direction")) : EnumFacing.UP;
    }

    @Override
    public NBTTagCompound writeToRemoteNBT(NBTTagCompound tag) {
        tag.func_74774_a("direction", (byte)this.direction.ordinal());
        return tag;
    }

    @Override
    public void readFromRemoteNBT(NBTTagCompound tag) {
        EnumFacing oldDir = this.direction;
        EnumFacing enumFacing = this.direction = tag.func_74764_b("direction") ? EnumFacing.func_82600_a((int)tag.func_74771_c("direction")) : EnumFacing.UP;
        if (oldDir != this.direction) {
            this.notifyBlockUpdate();
        }
    }

    private void appendCartType(ArrayList<Object> info, EntityMinecart cart) {
        IRailcraftCartContainer type = RailcraftCarts.fromCart((EntityMinecart)cart);
        info.add(type.getBaseTag().toLowerCase(Locale.ENGLISH));
        String entityName = cart.func_70005_c_();
        info.add(entityName);
    }

    private void appendLocomotiveInformation(ArrayList<Object> info, EntityMinecart cart) {
        if (cart instanceof EntityLocomotive) {
            EntityLocomotive locomotive = (EntityLocomotive)cart;
            GameProfile owner = locomotive.getOwner();
            info.add(Math.max(15 - locomotive.getPrimaryColor().ordinal(), -1));
            info.add(Math.max(15 - locomotive.getSecondaryColor().ordinal(), -1));
            String destination = locomotive.getDestination();
            info.add(destination);
            info.add(owner.getName());
        }
    }

    @Optional.Method(modid="opencomputers")
    public void eventOC(ArrayList<Object> info) {
        ArrayList<Object> extendedInfo = new ArrayList<Object>();
        extendedInfo.add("minecart");
        extendedInfo.addAll(info);
        this.node().sendToReachable("computer.signal", extendedInfo.toArray());
    }

    @Optional.Method(modid="computercraft")
    public void eventCC(ArrayList<Object> info) {
        if (this.attachedComputersCC != null) {
            for (IComputerAccess computer : this.attachedComputersCC) {
                ArrayList<Object> extendedInfo = new ArrayList<Object>();
                extendedInfo.add(computer.getAttachmentName());
                extendedInfo.addAll(info);
                computer.queueEvent("minecart", extendedInfo.toArray());
            }
        }
    }

    @Override
    @Optional.Method(modid="opencomputers")
    protected OCUtils.Device deviceInfo() {
        return new OCUtils.Device("generic", "Cart detector", "Railcraft, Inc.", "Digitized Detector A12", new String[0]);
    }

    @Nullable
    @Optional.Method(modid="opencomputers")
    public Node sidedNode(EnumFacing side) {
        return side == this.direction ? this.node() : null;
    }

    @Optional.Method(modid="opencomputers")
    public boolean canConnect(EnumFacing side) {
        return side == this.direction;
    }

    @Optional.Method(modid="computercraft")
    public String[] getMethodNames() {
        return new String[0];
    }

    @Nullable
    @Optional.Method(modid="computercraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        return null;
    }

    @Override
    public boolean canConnectPeripheralOnSide(EnumFacing side) {
        return side == this.direction;
    }
}

