/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.materials.MaterialCache;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.SchematicaSchematic;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacementManager;
import fi.dy.masa.litematica.selection.AreaSelection;
import fi.dy.masa.litematica.selection.Box;
import fi.dy.masa.litematica.tool.ToolMode;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.InventoryUtils;
import fi.dy.masa.litematica.util.ItemUtils;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.util.RayTraceUtils;
import fi.dy.masa.litematica.util.SchematicWorldRefresher;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.config.values.InfoType;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.hotkeys.KeybindMulti;
import fi.dy.masa.malilib.interfaces.IRangeChangeListener;
import fi.dy.masa.malilib.interfaces.IStringConsumer;
import fi.dy.masa.malilib.util.BlockUtils;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.SubChunkPos;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneComparator;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;

public class WorldUtils {
    private static final List<PositionCache> EASY_PLACE_POSITIONS = new ArrayList<PositionCache>();
    private static boolean preventOnBlockAdded;

    public static boolean shouldPreventOnBlockAdded() {
        return preventOnBlockAdded;
    }

    public static void setShouldPreventOnBlockAdded(boolean prevent) {
        preventOnBlockAdded = prevent;
    }

    public static boolean convertSchematicaSchematicToLitematicaSchematic(File inputDir, String inputFileName, File outputDir, String outputFileName, boolean ignoreEntities, boolean override, IStringConsumer feedback) {
        LitematicaSchematic litematicaSchematic = WorldUtils.convertSchematicaSchematicToLitematicaSchematic(inputDir, inputFileName, ignoreEntities, feedback);
        return litematicaSchematic != null && litematicaSchematic.writeToFile(outputDir, outputFileName, override);
    }

    @Nullable
    public static LitematicaSchematic convertSchematicaSchematicToLitematicaSchematic(File inputDir, String inputFileName, boolean ignoreEntities, IStringConsumer feedback) {
        SchematicaSchematic schematic = SchematicaSchematic.createFromFile(new File(inputDir, inputFileName));
        if (schematic == null) {
            feedback.setString("litematica.error.schematic_conversion.schematic_to_litematica.failed_to_read_schematic");
            return null;
        }
        WorldSettings settings = new WorldSettings(0L, GameType.CREATIVE, false, false, WorldType.field_77138_c);
        WorldSchematic world = new WorldSchematic(null, settings, 0, EnumDifficulty.NORMAL, Minecraft.func_71410_x().field_71424_I);
        WorldUtils.loadChunksClientWorld(world, BlockPos.field_177992_a, schematic.getSize());
        PlacementSettings placementSettings = new PlacementSettings();
        placementSettings.func_186222_a(ignoreEntities);
        schematic.placeSchematicDirectlyToChunks((World)world, BlockPos.field_177992_a, placementSettings);
        String subRegionName = FileUtils.getNameWithoutExtension((String)inputFileName) + " (Converted Schematic)";
        AreaSelection area = new AreaSelection();
        area.setName(subRegionName);
        subRegionName = area.createNewSubRegionBox(BlockPos.field_177992_a, subRegionName);
        area.setSelectedSubRegionBox(subRegionName);
        Box box = area.getSelectedSubRegionBox();
        area.setSubRegionCornerPos(box, PositionUtils.Corner.CORNER_1, BlockPos.field_177992_a);
        area.setSubRegionCornerPos(box, PositionUtils.Corner.CORNER_2, new BlockPos(schematic.getSize()).func_177982_a(-1, -1, -1));
        LitematicaSchematic litematicaSchematic = LitematicaSchematic.createFromWorld((World)world, area, false, "?", feedback);
        if (litematicaSchematic != null && !ignoreEntities) {
            litematicaSchematic.takeEntityDataFromSchematicaSchematic(schematic, subRegionName);
        } else {
            feedback.setString("litematica.error.schematic_conversion.schematic_to_litematica.failed_to_create_schematic");
        }
        return litematicaSchematic;
    }

    public static boolean convertStructureToLitematicaSchematic(File structureDir, String structureFileName, File outputDir, String outputFileName, boolean ignoreEntities, boolean override, IStringConsumer feedback) {
        LitematicaSchematic litematicaSchematic = WorldUtils.convertStructureToLitematicaSchematic(structureDir, structureFileName, ignoreEntities, feedback);
        return litematicaSchematic != null && litematicaSchematic.writeToFile(outputDir, outputFileName, override);
    }

    @Nullable
    public static LitematicaSchematic convertStructureToLitematicaSchematic(File structureDir, String structureFileName, boolean ignoreEntities, IStringConsumer feedback) {
        DataFixer fixer = Minecraft.func_71410_x().func_184126_aj();
        File file = new File(structureDir, structureFileName);
        try {
            FileInputStream is = new FileInputStream(file);
            Template template = WorldUtils.readTemplateFromStream(is, fixer);
            ((InputStream)is).close();
            WorldSettings settings = new WorldSettings(0L, GameType.CREATIVE, false, false, WorldType.field_77138_c);
            WorldSchematic world = new WorldSchematic(null, settings, 0, EnumDifficulty.NORMAL, Minecraft.func_71410_x().field_71424_I);
            WorldUtils.loadChunksClientWorld(world, BlockPos.field_177992_a, (Vec3i)template.func_186259_a());
            PlacementSettings placementSettings = new PlacementSettings();
            placementSettings.func_186222_a(ignoreEntities);
            template.func_189960_a((World)world, BlockPos.field_177992_a, null, placementSettings, 18);
            String subRegionName = FileUtils.getNameWithoutExtension((String)structureFileName) + " (Converted Structure)";
            AreaSelection area = new AreaSelection();
            area.setName(subRegionName);
            subRegionName = area.createNewSubRegionBox(BlockPos.field_177992_a, subRegionName);
            area.setSelectedSubRegionBox(subRegionName);
            Box box = area.getSelectedSubRegionBox();
            area.setSubRegionCornerPos(box, PositionUtils.Corner.CORNER_1, BlockPos.field_177992_a);
            area.setSubRegionCornerPos(box, PositionUtils.Corner.CORNER_2, template.func_186259_a().func_177982_a(-1, -1, -1));
            LitematicaSchematic litematicaSchematic = LitematicaSchematic.createFromWorld((World)world, area, ignoreEntities, template.func_186261_b(), feedback);
            if (litematicaSchematic == null) {
                feedback.setString("litematica.error.schematic_conversion.structure_to_litematica_failed");
            }
            return litematicaSchematic;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static boolean convertLitematicaSchematicToSchematicaSchematic(File inputDir, String inputFileName, File outputDir, String outputFileName, boolean ignoreEntities, boolean override, IStringConsumer feedback) {
        SchematicaSchematic schematic = WorldUtils.convertLitematicaSchematicToSchematicaSchematic(inputDir, inputFileName, ignoreEntities, feedback);
        return schematic != null && schematic.writeToFile(outputDir, outputFileName, override, feedback);
    }

    @Nullable
    public static SchematicaSchematic convertLitematicaSchematicToSchematicaSchematic(File inputDir, String inputFileName, boolean ignoreEntities, IStringConsumer feedback) {
        LitematicaSchematic litematicaSchematic = LitematicaSchematic.createFromFile(inputDir, inputFileName);
        if (litematicaSchematic == null) {
            feedback.setString("litematica.error.schematic_conversion.litematica_to_schematic.failed_to_read_schematic");
            return null;
        }
        WorldSettings settings = new WorldSettings(0L, GameType.CREATIVE, false, false, WorldType.field_77138_c);
        WorldSchematic world = new WorldSchematic(null, settings, 0, EnumDifficulty.NORMAL, Minecraft.func_71410_x().field_71424_I);
        BlockPos size = new BlockPos(litematicaSchematic.getTotalSize());
        WorldUtils.loadChunksClientWorld(world, BlockPos.field_177992_a, (Vec3i)size);
        SchematicPlacement schematicPlacement = SchematicPlacement.createForSchematicConversion(litematicaSchematic, BlockPos.field_177992_a);
        LayerRange range = new LayerRange((IRangeChangeListener)SchematicWorldRefresher.INSTANCE);
        litematicaSchematic.placeToWorld((World)world, schematicPlacement, range, false);
        SchematicaSchematic schematic = SchematicaSchematic.createFromWorld((World)world, BlockPos.field_177992_a, size, ignoreEntities);
        if (schematic == null) {
            feedback.setString("litematica.error.schematic_conversion.litematica_to_schematic.failed_to_create_schematic");
        }
        return schematic;
    }

    public static boolean convertLitematicaSchematicToVanillaStructure(File inputDir, String inputFileName, File outputDir, String outputFileName, boolean ignoreEntities, boolean override, IStringConsumer feedback) {
        Template template = WorldUtils.convertLitematicaSchematicToVanillaStructure(inputDir, inputFileName, ignoreEntities, feedback);
        return WorldUtils.writeVanillaStructureToFile(template, outputDir, outputFileName, override, feedback);
    }

    @Nullable
    public static Template convertLitematicaSchematicToVanillaStructure(File inputDir, String inputFileName, boolean ignoreEntities, IStringConsumer feedback) {
        LitematicaSchematic litematicaSchematic = LitematicaSchematic.createFromFile(inputDir, inputFileName);
        if (litematicaSchematic == null) {
            feedback.setString("litematica.error.schematic_conversion.litematica_to_schematic.failed_to_read_schematic");
            return null;
        }
        WorldSettings settings = new WorldSettings(0L, GameType.CREATIVE, false, false, WorldType.field_77138_c);
        WorldSchematic world = new WorldSchematic(null, settings, 0, EnumDifficulty.NORMAL, Minecraft.func_71410_x().field_71424_I);
        BlockPos size = new BlockPos(litematicaSchematic.getTotalSize());
        WorldUtils.loadChunksClientWorld(world, BlockPos.field_177992_a, (Vec3i)size);
        SchematicPlacement schematicPlacement = SchematicPlacement.createForSchematicConversion(litematicaSchematic, BlockPos.field_177992_a);
        LayerRange range = new LayerRange((IRangeChangeListener)SchematicWorldRefresher.INSTANCE);
        litematicaSchematic.placeToWorld((World)world, schematicPlacement, range, false);
        Template template = new Template();
        template.func_186254_a((World)world, BlockPos.field_177992_a, size, !ignoreEntities, Blocks.field_189881_dj);
        return template;
    }

    private static boolean writeVanillaStructureToFile(Template template, File dir, String fileNameIn, boolean override, IStringConsumer feedback) {
        String fileName = fileNameIn;
        String extension = ".nbt";
        if (!fileName.endsWith(extension)) {
            fileName = fileName + extension;
        }
        File file = new File(dir, fileName);
        FileOutputStream os = null;
        try {
            if (!dir.exists() && !dir.mkdirs()) {
                feedback.setString(StringUtils.translate((String)"litematica.error.schematic_write_to_file_failed.directory_creation_failed", (Object[])new Object[]{dir.getAbsolutePath()}));
                return false;
            }
            if (!override && file.exists()) {
                feedback.setString(StringUtils.translate((String)"litematica.error.structure_write_to_file_failed.exists", (Object[])new Object[]{file.getAbsolutePath()}));
                return false;
            }
            NBTTagCompound tag = template.func_189552_a(new NBTTagCompound());
            os = new FileOutputStream(file);
            CompressedStreamTools.func_74799_a((NBTTagCompound)tag, (OutputStream)os);
            os.close();
            return true;
        }
        catch (Exception e) {
            feedback.setString(StringUtils.translate((String)"litematica.error.structure_write_to_file_failed.exception", (Object[])new Object[]{file.getAbsolutePath()}));
            return false;
        }
    }

    private static Template readTemplateFromStream(InputStream stream, DataFixer fixer) throws IOException {
        NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)stream);
        Template template = new Template();
        template.func_186256_b(fixer.func_188257_a((IFixType)FixTypes.STRUCTURE, nbt));
        return template;
    }

    public static void loadChunksClientWorld(WorldClient world, BlockPos origin, Vec3i areaSize) {
        BlockPos posEnd = origin.func_177971_a((Vec3i)PositionUtils.getRelativeEndPositionFromAreaSize(areaSize));
        BlockPos posMin = PositionUtils.getMinCorner(origin, posEnd);
        BlockPos posMax = PositionUtils.getMaxCorner(origin, posEnd);
        int cxMin = posMin.func_177958_n() >> 4;
        int czMin = posMin.func_177952_p() >> 4;
        int cxMax = posMax.func_177958_n() >> 4;
        int czMax = posMax.func_177952_p() >> 4;
        for (int cz = czMin; cz <= czMax; ++cz) {
            for (int cx = cxMin; cx <= cxMax; ++cx) {
                world.func_72863_F().func_73158_c(cx, cz);
            }
        }
    }

    public static void setToolModeBlockState(ToolMode mode, boolean primary, Minecraft mc) {
        RayTraceResult trace;
        IBlockState state = Blocks.field_150350_a.func_176223_P();
        RayTraceUtils.RayTraceWrapper wrapper = RayTraceUtils.getGenericTrace((World)mc.field_71441_e, (Entity)mc.field_71439_g, 6.0, true);
        if (wrapper != null && (trace = wrapper.getRayTraceResult()) != null) {
            BlockPos pos = trace.func_178782_a();
            if (wrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
                state = SchematicWorldHandler.getSchematicWorld().func_180495_p(pos);
            } else if (wrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.VANILLA) {
                state = mc.field_71441_e.func_180495_p(pos).func_185899_b((IBlockAccess)mc.field_71441_e, pos);
            }
        }
        if (primary) {
            mode.setPrimaryBlock(state);
        } else {
            mode.setSecondaryBlock(state);
        }
    }

    public static boolean doSchematicWorldPickBlock(boolean closest, Minecraft mc) {
        BlockPos pos = null;
        pos = closest ? RayTraceUtils.getSchematicWorldTraceIfClosest((World)mc.field_71441_e, (Entity)mc.field_71439_g, 6.0) : RayTraceUtils.getFurthestSchematicWorldTrace((World)mc.field_71441_e, (Entity)mc.field_71439_g, 6.0);
        if (pos != null) {
            WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
            IBlockState state = world.func_180495_p(pos);
            ItemStack stack = MaterialCache.getInstance().getRequiredBuildItemForState(state, (World)world, pos);
            boolean ignoreNBT = Configs.Generic.PICK_BLOCK_IGNORE_NBT.getBooleanValue();
            if (!stack.func_190926_b()) {
                InventoryPlayer inv = mc.field_71439_g.field_71071_by;
                int slotNum = InventoryUtils.findSlotWithItem(inv, stack, false, ignoreNBT);
                if (mc.field_71439_g.field_71075_bZ.field_75098_d) {
                    TileEntity te = world.func_175625_s(pos);
                    if (GuiBase.isCtrlDown() && te != null && mc.field_71441_e.func_175623_d(pos)) {
                        ItemUtils.storeTEInStack(stack, te);
                    }
                    InventoryUtils.setPickedItemToHand(slotNum, stack, ignoreNBT, mc);
                    mc.field_71442_b.func_78761_a(mc.field_71439_g.func_184586_b(EnumHand.MAIN_HAND), 36 + inv.field_70461_c);
                } else if (slotNum != -1 && inv.field_70461_c != slotNum) {
                    InventoryUtils.setPickedItemToHand(slotNum, stack, ignoreNBT, mc);
                }
            }
            return true;
        }
        return false;
    }

    public static void insertSignTextFromSchematic(TileEntitySign teClient) {
        TileEntity te;
        WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
        if (worldSchematic != null && (te = worldSchematic.func_175625_s(teClient.func_174877_v())) instanceof TileEntitySign) {
            ITextComponent[] textSchematic = ((TileEntitySign)te).field_145915_a;
            ITextComponent[] textClient = teClient.field_145915_a;
            if (textClient != null && textSchematic != null) {
                int size = Math.min(textSchematic.length, textClient.length);
                for (int i = 0; i < size; ++i) {
                    if (textSchematic[i] == null) continue;
                    textClient[i] = textSchematic[i].func_150259_f();
                }
            }
        }
    }

    public static void easyPlaceOnUseTick(Minecraft mc) {
        if (mc.field_71439_g != null && Configs.Generic.EASY_PLACE_HOLD_ENABLED.getBooleanValue() && Configs.Generic.EASY_PLACE_MODE.getBooleanValue() && Hotkeys.EASY_PLACE_ACTIVATION.getKeybind().isKeybindHeld() && KeybindMulti.isKeyDown((int)mc.field_71474_y.field_74313_G.func_151463_i())) {
            WorldUtils.doEasyPlaceAction(mc);
        }
    }

    public static boolean handleEasyPlace(Minecraft mc) {
        EnumActionResult result = WorldUtils.doEasyPlaceAction(mc);
        if (result == EnumActionResult.FAIL) {
            InfoUtils.showMessage((InfoType)((InfoType)Configs.InfoOverlays.EASY_PLACE_WARNINGS.getOptionListValue()), (Message.MessageType)Message.MessageType.WARNING, (String)"litematica.message.easy_place_fail", (Object[])new Object[0]);
            return true;
        }
        return result != EnumActionResult.PASS;
    }

    private static EnumActionResult doEasyPlaceAction(Minecraft mc) {
        RayTraceUtils.RayTraceWrapper traceWrapper = RayTraceUtils.getGenericTrace((World)mc.field_71441_e, (Entity)mc.field_71439_g, 6.0, true);
        if (traceWrapper == null) {
            return EnumActionResult.PASS;
        }
        if (traceWrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
            RayTraceResult trace = traceWrapper.getRayTraceResult();
            RayTraceResult traceVanilla = RayTraceUtils.getRayTraceFromEntity((World)mc.field_71441_e, (Entity)mc.field_71439_g, false, 6.0);
            BlockPos pos = trace.func_178782_a();
            WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
            IBlockState stateSchematic = world.func_180495_p(pos);
            ItemStack stack = MaterialCache.getInstance().getRequiredBuildItemForState(stateSchematic);
            if (WorldUtils.easyPlaceIsPositionCached(pos)) {
                return EnumActionResult.FAIL;
            }
            if (!stack.func_190926_b()) {
                BlockPos posVanilla;
                IBlockState stateVanilla;
                IBlockState stateClient = mc.field_71441_e.func_180495_p(pos).func_185899_b((IBlockAccess)mc.field_71441_e, pos);
                if (stateSchematic == stateClient) {
                    return EnumActionResult.FAIL;
                }
                if (WorldUtils.easyPlaceBlockChecksCancel(stateSchematic, stateClient, (World)mc.field_71441_e, pos)) {
                    return EnumActionResult.FAIL;
                }
                if (!WorldUtils.doSchematicWorldPickBlock(true, mc)) {
                    return EnumActionResult.FAIL;
                }
                EnumHand hand = EntityUtils.getUsedHandForItem((EntityPlayer)mc.field_71439_g, stack);
                if (hand == null) {
                    return EnumActionResult.FAIL;
                }
                Vec3d hitPos = trace.field_72307_f;
                EnumFacing sideOrig = trace.field_178784_b;
                if (traceVanilla != null && traceVanilla.field_72313_a == RayTraceResult.Type.BLOCK && !(stateVanilla = mc.field_71441_e.func_180495_p(posVanilla = traceVanilla.func_178782_a())).func_177230_c().func_176200_f((IBlockAccess)mc.field_71441_e, posVanilla) && pos.equals((Object)(posVanilla = posVanilla.func_177972_a(traceVanilla.field_178784_b)))) {
                    hitPos = traceVanilla.field_72307_f;
                    sideOrig = traceVanilla.field_178784_b;
                }
                EnumFacing side = WorldUtils.applyPlacementFacing(stateSchematic, sideOrig, stateClient);
                hitPos = WorldUtils.applyCarpetProtocolHitVec(pos, stateSchematic, hitPos);
                WorldUtils.cacheEasyPlacePosition(pos);
                if (!stateClient.func_177230_c().func_176200_f((IBlockAccess)mc.field_71441_e, pos) && stateClient.func_185904_a().func_76224_d()) {
                    pos = pos.func_177967_a(side, -1);
                }
                mc.field_71442_b.func_187099_a(mc.field_71439_g, mc.field_71441_e, pos, side, hitPos, hand);
                if (stateSchematic.func_177230_c() instanceof BlockSlab && ((BlockSlab)stateSchematic.func_177230_c()).func_176552_j() && (stateClient = mc.field_71441_e.func_180495_p(pos).func_185899_b((IBlockAccess)mc.field_71441_e, pos)).func_177230_c() instanceof BlockSlab && !((BlockSlab)stateClient.func_177230_c()).func_176552_j()) {
                    side = WorldUtils.applyPlacementFacing(stateSchematic, sideOrig, stateClient);
                    mc.field_71442_b.func_187099_a(mc.field_71439_g, mc.field_71441_e, pos, side, hitPos, hand);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        if (traceWrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.VANILLA) {
            return WorldUtils.placementRestrictionInEffect(mc) ? EnumActionResult.FAIL : EnumActionResult.PASS;
        }
        return EnumActionResult.PASS;
    }

    private static boolean easyPlaceBlockChecksCancel(IBlockState stateSchematic, IBlockState stateClient, World worldClient, BlockPos pos) {
        Block blockSchematic = stateSchematic.func_177230_c();
        if (blockSchematic instanceof BlockSlab && ((BlockSlab)blockSchematic).func_176552_j() && stateClient.func_177230_c() instanceof BlockSlab && !((BlockSlab)stateClient.func_177230_c()).func_176552_j()) {
            IProperty propClient;
            IProperty propSchematic = ((BlockSlab)stateSchematic.func_177230_c()).func_176551_l();
            return propSchematic != (propClient = ((BlockSlab)stateClient.func_177230_c()).func_176551_l()) || stateSchematic.func_177229_b(propSchematic) != stateClient.func_177229_b(propClient);
        }
        return !stateClient.func_177230_c().func_176200_f((IBlockAccess)worldClient, pos) && !stateClient.func_185904_a().func_76224_d();
    }

    public static Vec3d applyCarpetProtocolHitVec(BlockPos pos, IBlockState state, Vec3d hitVecIn) {
        double x = hitVecIn.field_72450_a;
        double y = hitVecIn.field_72448_b;
        double z = hitVecIn.field_72449_c;
        Block block = state.func_177230_c();
        EnumFacing facing = BlockUtils.getFirstPropertyFacingValue((IBlockState)state);
        if (facing != null) {
            x = facing.ordinal() + 2 + pos.func_177958_n();
        }
        if (block instanceof BlockRedstoneRepeater) {
            x += (double)(((Integer)state.func_177229_b((IProperty)BlockRedstoneRepeater.field_176410_b) - 1) * 10);
        } else if (block instanceof BlockTrapDoor && state.func_177229_b((IProperty)BlockTrapDoor.field_176285_M) == BlockTrapDoor.DoorHalf.TOP) {
            x += 10.0;
        } else if (block instanceof BlockRedstoneComparator && state.func_177229_b((IProperty)BlockRedstoneComparator.field_176463_b) == BlockRedstoneComparator.Mode.SUBTRACT) {
            x += 10.0;
        } else if (block instanceof BlockStairs && state.func_177229_b((IProperty)BlockStairs.field_176308_b) == BlockStairs.EnumHalf.TOP) {
            x += 10.0;
        } else if (block instanceof BlockSlab && !((BlockSlab)block).func_176552_j()) {
            y = state.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.TOP ? (double)pos.func_177956_o() + 0.9 : (double)pos.func_177956_o();
        }
        return new Vec3d(x, y, z);
    }

    private static EnumFacing applyPlacementFacing(IBlockState stateSchematic, EnumFacing side, IBlockState stateClient) {
        Block blockSchematic = stateSchematic.func_177230_c();
        Block blockClient = stateClient.func_177230_c();
        if (blockSchematic instanceof BlockSlab) {
            if (((BlockSlab)blockSchematic).func_176552_j() && blockClient instanceof BlockSlab && !((BlockSlab)blockClient).func_176552_j()) {
                if (stateClient.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
                    return EnumFacing.DOWN;
                }
                return EnumFacing.UP;
            }
            return EnumFacing.NORTH;
        }
        return side;
    }

    public static boolean handlePlacementRestriction(Minecraft mc) {
        boolean cancel = WorldUtils.placementRestrictionInEffect(mc);
        if (cancel) {
            InfoUtils.showMessage((InfoType)((InfoType)Configs.InfoOverlays.EASY_PLACE_WARNINGS.getOptionListValue()), (Message.MessageType)Message.MessageType.WARNING, (String)"litematica.message.placement_restriction_fail", (Object[])new Object[0]);
        }
        return cancel;
    }

    private static boolean placementRestrictionInEffect(Minecraft mc) {
        RayTraceResult trace = mc.field_71476_x;
        if (trace != null && trace.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = trace.func_178782_a();
            IBlockState stateClient = mc.field_71441_e.func_180495_p(pos);
            if (!stateClient.func_177230_c().func_176200_f((IBlockAccess)mc.field_71441_e, pos)) {
                pos = pos.func_177972_a(trace.field_178784_b);
                stateClient = mc.field_71441_e.func_180495_p(pos);
            }
            if (!stateClient.func_177230_c().func_176200_f((IBlockAccess)mc.field_71441_e, pos) && !stateClient.func_185904_a().func_76224_d()) {
                return true;
            }
            WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
            LayerRange range = DataManager.getRenderLayerRange();
            if (!worldSchematic.func_175623_d(pos) && !range.isPositionWithinRange(pos)) {
                return true;
            }
            if (worldSchematic.func_175623_d(pos) && WorldUtils.isPositionWithinRangeOfSchematicRegions(pos, 2)) {
                return true;
            }
            IBlockState stateSchematic = worldSchematic.func_180495_p(pos);
            ItemStack stack = MaterialCache.getInstance().getRequiredBuildItemForState(stateSchematic);
            if (!stack.func_190926_b() && EntityUtils.getUsedHandForItem((EntityPlayer)mc.field_71439_g, stack) == null) {
                return true;
            }
        }
        return false;
    }

    public static boolean isPositionWithinRangeOfSchematicRegions(BlockPos pos, int range) {
        SchematicPlacementManager manager = DataManager.getSchematicPlacementManager();
        int minCX = pos.func_177958_n() - range >> 4;
        int minCY = pos.func_177956_o() - range >> 4;
        int minCZ = pos.func_177952_p() - range >> 4;
        int maxCX = pos.func_177958_n() + range >> 4;
        int maxCY = pos.func_177956_o() + range >> 4;
        int maxCZ = pos.func_177952_p() + range >> 4;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        for (int cy = minCY; cy <= maxCY; ++cy) {
            for (int cz = minCZ; cz <= maxCZ; ++cz) {
                for (int cx = minCX; cx <= maxCX; ++cx) {
                    List<IntBoundingBox> boxes = manager.getTouchedBoxesInSubChunk(new SubChunkPos(cx, cy, cz));
                    for (int i = 0; i < boxes.size(); ++i) {
                        IntBoundingBox box = boxes.get(i);
                        if (x < box.minX - range || x > box.maxX + range || y < box.minY - range || y > box.maxY + range || z < box.minZ - range || z > box.maxZ + range) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean isSliceEmpty(World world, EnumFacing.Axis axis, BlockPos pos1, BlockPos pos2) {
        switch (axis) {
            case Z: {
                int x1 = Math.min(pos1.func_177958_n(), pos2.func_177958_n());
                int x2 = Math.max(pos1.func_177958_n(), pos2.func_177958_n());
                int y1 = Math.min(pos1.func_177956_o(), pos2.func_177956_o());
                int y2 = Math.max(pos1.func_177956_o(), pos2.func_177956_o());
                int z = pos1.func_177952_p();
                int cxMin = x1 >> 4;
                int cxMax = x2 >> 4;
                for (int cx = cxMin; cx <= cxMax; ++cx) {
                    Chunk chunk = world.func_72964_e(cx, z >> 4);
                    int xMin = Math.max(x1, cx << 4);
                    int xMax = Math.min(x2, (cx << 4) + 15);
                    int yMax = Math.min(y2, chunk.func_76625_h() + 15);
                    for (int x = xMin; x <= xMax; ++x) {
                        for (int y = y1; y <= yMax; ++y) {
                            if (chunk.func_186032_a(x, y, z).func_185904_a() == Material.field_151579_a) continue;
                            return false;
                        }
                    }
                }
                break;
            }
            case Y: {
                int x1 = Math.min(pos1.func_177958_n(), pos2.func_177958_n());
                int x2 = Math.max(pos1.func_177958_n(), pos2.func_177958_n());
                int y = pos1.func_177956_o();
                int z1 = Math.min(pos1.func_177952_p(), pos2.func_177952_p());
                int z2 = Math.max(pos1.func_177952_p(), pos2.func_177952_p());
                int cxMin = x1 >> 4;
                int cxMax = x2 >> 4;
                int czMin = z1 >> 4;
                int czMax = z2 >> 4;
                for (int cz = czMin; cz <= czMax; ++cz) {
                    for (int cx = cxMin; cx <= cxMax; ++cx) {
                        Chunk chunk = world.func_72964_e(cx, cz);
                        if (y > chunk.func_76625_h() + 15) continue;
                        int xMin = Math.max(x1, cx << 4);
                        int xMax = Math.min(x2, (cx << 4) + 15);
                        int zMin = Math.max(z1, cz << 4);
                        int zMax = Math.min(z2, (cz << 4) + 15);
                        for (int z = zMin; z <= zMax; ++z) {
                            for (int x = xMin; x <= xMax; ++x) {
                                if (chunk.func_186032_a(x, y, z).func_185904_a() == Material.field_151579_a) continue;
                                return false;
                            }
                        }
                    }
                }
                break;
            }
            case X: {
                int x = pos1.func_177958_n();
                int z1 = Math.min(pos1.func_177952_p(), pos2.func_177952_p());
                int z2 = Math.max(pos1.func_177952_p(), pos2.func_177952_p());
                int y1 = Math.min(pos1.func_177956_o(), pos2.func_177956_o());
                int y2 = Math.max(pos1.func_177956_o(), pos2.func_177956_o());
                int czMin = z1 >> 4;
                int czMax = z2 >> 4;
                for (int cz = czMin; cz <= czMax; ++cz) {
                    Chunk chunk = world.func_72964_e(x >> 4, cz);
                    int zMin = Math.max(z1, cz << 4);
                    int zMax = Math.min(z2, (cz << 4) + 15);
                    int yMax = Math.min(y2, chunk.func_76625_h() + 15);
                    for (int z = zMin; z <= zMax; ++z) {
                        for (int y = y1; y <= yMax; ++y) {
                            if (chunk.func_186032_a(x, y, z).func_185904_a() == Material.field_151579_a) continue;
                            return false;
                        }
                    }
                }
                break;
            }
        }
        return true;
    }

    public static boolean easyPlaceIsPositionCached(BlockPos pos) {
        long currentTime = System.nanoTime();
        boolean cached = false;
        for (int i = 0; i < EASY_PLACE_POSITIONS.size(); ++i) {
            PositionCache val = EASY_PLACE_POSITIONS.get(i);
            boolean expired = val.hasExpired(currentTime);
            if (expired) {
                EASY_PLACE_POSITIONS.remove(i);
                --i;
                continue;
            }
            if (!val.getPos().equals((Object)pos)) continue;
            cached = true;
            if (EASY_PLACE_POSITIONS.size() < 16) break;
        }
        return cached;
    }

    private static void cacheEasyPlacePosition(BlockPos pos) {
        EASY_PLACE_POSITIONS.add(new PositionCache(pos, System.nanoTime(), 2000000000L));
    }

    public static class PositionCache {
        private final BlockPos pos;
        private final long time;
        private final long timeout;

        private PositionCache(BlockPos pos, long time, long timeout) {
            this.pos = pos;
            this.time = time;
            this.timeout = timeout;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public boolean hasExpired(long currentTime) {
            return currentTime - this.time > this.timeout;
        }
    }
}

