/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import fi.dy.masa.litematica.interfaces.IMixinChunkProviderClient;
import fi.dy.masa.litematica.render.LitematicaRenderer;
import fi.dy.masa.litematica.render.schematic.RenderGlobalSchematic;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.interfaces.IRangeChangeListener;
import fi.dy.masa.malilib.util.SubChunkPos;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;

public class SchematicWorldRefresher
implements IRangeChangeListener {
    public static final SchematicWorldRefresher INSTANCE = new SchematicWorldRefresher();

    public void updateAll() {
        this.updateBetweenY(0, 255);
    }

    public void updateBetweenX(int minX, int maxX) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        if (world != null) {
            int xMin = Math.min(minX, maxX);
            int xMax = Math.max(minX, maxX);
            int cxMin = xMin >> 4;
            int cxMax = xMax >> 4;
            RenderGlobalSchematic rg = LitematicaRenderer.getInstance().getWorldRenderer();
            Long2ObjectMap<Chunk> schematicChunks = ((IMixinChunkProviderClient)world.func_72863_F()).getLoadedChunks();
            Long2ObjectMap<Chunk> clientChunks = ((IMixinChunkProviderClient)Minecraft.func_71410_x().field_71441_e.func_72863_F()).getLoadedChunks();
            for (Chunk chunk : schematicChunks.values()) {
                if (chunk.field_76635_g < cxMin || chunk.field_76635_g > cxMax || chunk.func_76621_g() || !clientChunks.containsKey(ChunkPos.func_77272_a((int)chunk.field_76635_g, (int)chunk.field_76647_h))) continue;
                minX = Math.max(chunk.field_76635_g << 4, xMin);
                maxX = Math.min((chunk.field_76635_g << 4) + 15, xMax);
                rg.func_147585_a(minX, 0, chunk.field_76647_h << 4, maxX, 255, (chunk.field_76647_h << 4) + 15);
            }
        }
    }

    public void updateBetweenY(int minY, int maxY) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        if (world != null) {
            RenderGlobalSchematic rg = LitematicaRenderer.getInstance().getWorldRenderer();
            Long2ObjectMap<Chunk> schematicChunks = ((IMixinChunkProviderClient)world.func_72863_F()).getLoadedChunks();
            Long2ObjectMap<Chunk> clientChunks = ((IMixinChunkProviderClient)Minecraft.func_71410_x().field_71441_e.func_72863_F()).getLoadedChunks();
            for (Chunk chunk : schematicChunks.values()) {
                if (chunk.func_76621_g() || !clientChunks.containsKey(ChunkPos.func_77272_a((int)chunk.field_76635_g, (int)chunk.field_76647_h))) continue;
                rg.func_147585_a((chunk.field_76635_g << 4) - 1, minY, (chunk.field_76647_h << 4) - 1, (chunk.field_76635_g << 4) + 16, maxY, (chunk.field_76647_h << 4) + 16);
            }
        }
    }

    public void updateBetweenZ(int minZ, int maxZ) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        if (world != null) {
            int zMin = Math.min(minZ, maxZ);
            int zMax = Math.max(minZ, maxZ);
            int czMin = zMin >> 4;
            int czMax = zMax >> 4;
            RenderGlobalSchematic rg = LitematicaRenderer.getInstance().getWorldRenderer();
            Long2ObjectMap<Chunk> schematicChunks = ((IMixinChunkProviderClient)world.func_72863_F()).getLoadedChunks();
            Long2ObjectMap<Chunk> clientChunks = ((IMixinChunkProviderClient)Minecraft.func_71410_x().field_71441_e.func_72863_F()).getLoadedChunks();
            for (Chunk chunk : schematicChunks.values()) {
                if (chunk.field_76647_h < czMin || chunk.field_76647_h > czMax || chunk.func_76621_g() || !clientChunks.containsKey(ChunkPos.func_77272_a((int)chunk.field_76635_g, (int)chunk.field_76647_h))) continue;
                minZ = Math.max(chunk.field_76647_h << 4, zMin);
                maxZ = Math.min((chunk.field_76647_h << 4) + 15, zMax);
                rg.func_147585_a(chunk.field_76635_g << 4, 0, minZ, (chunk.field_76635_g << 4) + 15, 255, maxZ);
            }
        }
    }

    public static void markSchematicChunkForRenderUpdate(SubChunkPos chunkPos) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        if (world != null) {
            Long2ObjectMap<Chunk> schematicChunks = ((IMixinChunkProviderClient)world.func_72863_F()).getLoadedChunks();
            Long2ObjectMap<Chunk> clientChunks = ((IMixinChunkProviderClient)Minecraft.func_71410_x().field_71441_e.func_72863_F()).getLoadedChunks();
            long key = ChunkPos.func_77272_a((int)chunkPos.func_177958_n(), (int)chunkPos.func_177952_p());
            if (schematicChunks.containsKey(key) && clientChunks.containsKey(key)) {
                RenderGlobalSchematic rg = LitematicaRenderer.getInstance().getWorldRenderer();
                rg.func_147585_a((chunkPos.func_177958_n() << 4) - 1, (chunkPos.func_177956_o() << 4) - 1, (chunkPos.func_177952_p() << 4) - 1, (chunkPos.func_177958_n() << 4) + 1, (chunkPos.func_177956_o() << 4) + 1, (chunkPos.func_177952_p() << 4) + 1);
            }
        }
    }

    public static void markSchematicChunksForRenderUpdate(ChunkPos chunkPos) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        if (world != null) {
            Long2ObjectMap<Chunk> schematicChunks = ((IMixinChunkProviderClient)world.func_72863_F()).getLoadedChunks();
            Long2ObjectMap<Chunk> clientChunks = ((IMixinChunkProviderClient)Minecraft.func_71410_x().field_71441_e.func_72863_F()).getLoadedChunks();
            long key = ChunkPos.func_77272_a((int)chunkPos.field_77276_a, (int)chunkPos.field_77275_b);
            if (schematicChunks.containsKey(key) && clientChunks.containsKey(key)) {
                RenderGlobalSchematic rg = LitematicaRenderer.getInstance().getWorldRenderer();
                rg.func_147585_a((chunkPos.field_77276_a << 4) - 1, 0, (chunkPos.field_77275_b << 4) - 1, (chunkPos.field_77276_a << 4) + 1, 255, (chunkPos.field_77275_b << 4) + 1);
            }
        }
    }

    public static void markSchematicChunkForRenderUpdate(BlockPos pos) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        if (world != null) {
            Long2ObjectMap<Chunk> schematicChunks = ((IMixinChunkProviderClient)world.func_72863_F()).getLoadedChunks();
            Long2ObjectMap<Chunk> clientChunks = ((IMixinChunkProviderClient)Minecraft.func_71410_x().field_71441_e.func_72863_F()).getLoadedChunks();
            long key = ChunkPos.func_77272_a((int)(pos.func_177958_n() >> 4), (int)(pos.func_177952_p() >> 4));
            if (schematicChunks.containsKey(key) && clientChunks.containsKey(key)) {
                RenderGlobalSchematic rg = LitematicaRenderer.getInstance().getWorldRenderer();
                rg.func_147585_a(pos.func_177958_n() - 1, pos.func_177956_o() - 1, pos.func_177952_p() - 1, pos.func_177958_n() + 1, pos.func_177956_o() + 1, pos.func_177952_p() + 1);
            }
        }
    }
}

