/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SubRegionPlacement;
import fi.dy.masa.litematica.schematic.verifier.SchematicVerifier;
import fi.dy.masa.litematica.selection.AreaSelection;
import fi.dy.masa.litematica.selection.Box;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.util.LayerRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RayTraceUtils {
    private static RayTraceWrapper closestBox;
    private static RayTraceWrapper closestCorner;
    private static RayTraceWrapper closestOrigin;
    private static double closestBoxDistance;
    private static double closestCornerDistance;
    private static double closestOriginDistance;
    private static RayTraceWrapper.HitType originType;

    @Nullable
    public static BlockPos getTargetedPosition(World world, EntityPlayer player, double maxDistance, boolean sneakToOffset) {
        RayTraceResult trace = RayTraceUtils.getRayTraceFromEntity(world, (Entity)player, false, maxDistance);
        if (trace.field_72313_a != RayTraceResult.Type.BLOCK) {
            return null;
        }
        BlockPos pos = trace.func_178782_a();
        if (sneakToOffset == player.func_70093_af()) {
            pos = pos.func_177972_a(trace.field_178784_b);
        }
        return pos;
    }

    @Nonnull
    public static RayTraceWrapper getWrappedRayTraceFromEntity(World world, Entity entity, double range) {
        Vec3d eyesPos = entity.func_174824_e(1.0f);
        Vec3d rangedLookRot = entity.func_70676_i(1.0f).func_186678_a(range);
        Vec3d lookEndPos = eyesPos.func_178787_e(rangedLookRot);
        RayTraceResult result = RayTraceUtils.getRayTraceFromEntity(world, entity, false, range);
        double closestVanilla = result.field_72313_a != RayTraceResult.Type.MISS ? result.field_72307_f.func_72438_d(eyesPos) : -1.0;
        AreaSelection area = DataManager.getSelectionManager().getCurrentSelection();
        RayTraceWrapper wrapper = null;
        RayTraceUtils.clearTraceVars();
        if (!DataManager.getToolMode().getUsesSchematic() && area != null) {
            for (Box box : area.getAllSubRegionBoxes()) {
                boolean hitCorner = false;
                hitCorner |= RayTraceUtils.traceToSelectionBoxCorner(box, PositionUtils.Corner.CORNER_1, eyesPos, lookEndPos);
                if (hitCorner |= RayTraceUtils.traceToSelectionBoxCorner(box, PositionUtils.Corner.CORNER_2, eyesPos, lookEndPos)) continue;
                RayTraceUtils.traceToSelectionBoxBody(box, eyesPos, lookEndPos);
            }
            BlockPos origin = area.getExplicitOrigin();
            if (origin != null) {
                RayTraceUtils.traceToOrigin(origin, eyesPos, lookEndPos, RayTraceWrapper.HitType.SELECTION_ORIGIN, null);
            }
        }
        if (DataManager.getToolMode().getUsesSchematic()) {
            for (SchematicPlacement placement : DataManager.getSchematicPlacementManager().getAllSchematicsPlacements()) {
                if (!placement.isEnabled()) continue;
                RayTraceUtils.traceToPlacementBox(placement, eyesPos, lookEndPos);
                RayTraceUtils.traceToOrigin(placement.getOrigin(), eyesPos, lookEndPos, RayTraceWrapper.HitType.PLACEMENT_ORIGIN, placement);
            }
        }
        double closestDistance = closestVanilla;
        if (closestBoxDistance >= 0.0 && (closestVanilla < 0.0 || closestBoxDistance <= closestVanilla)) {
            closestDistance = closestBoxDistance;
            wrapper = closestBox;
        }
        if (closestCornerDistance >= 0.0 && (closestVanilla < 0.0 || closestCornerDistance <= closestVanilla)) {
            closestDistance = closestCornerDistance;
            wrapper = closestCorner;
        }
        if (closestOriginDistance >= 0.0 && (closestVanilla < 0.0 || closestOriginDistance <= closestVanilla)) {
            closestDistance = closestOriginDistance;
            wrapper = originType == RayTraceWrapper.HitType.PLACEMENT_ORIGIN ? closestOrigin : new RayTraceWrapper(RayTraceWrapper.HitType.SELECTION_ORIGIN);
        }
        RayTraceUtils.clearTraceVars();
        if (wrapper == null || closestDistance < 0.0) {
            wrapper = new RayTraceWrapper();
        }
        return wrapper;
    }

    private static void clearTraceVars() {
        closestBox = null;
        closestCorner = null;
        closestOrigin = null;
        closestBoxDistance = -1.0;
        closestCornerDistance = -1.0;
        closestOriginDistance = -1.0;
    }

    private static boolean traceToSelectionBoxCorner(Box box, PositionUtils.Corner corner, Vec3d start, Vec3d end) {
        AxisAlignedBB bb;
        RayTraceResult hit;
        BlockPos pos;
        Object object = corner == PositionUtils.Corner.CORNER_1 ? box.getPos1() : (pos = corner == PositionUtils.Corner.CORNER_2 ? box.getPos2() : null);
        if (pos != null && (hit = (bb = PositionUtils.createAABBForPosition(pos)).func_72327_a(start, end)) != null) {
            double dist = hit.field_72307_f.func_72438_d(start);
            if (closestCornerDistance < 0.0 || dist < closestCornerDistance) {
                closestCornerDistance = dist;
                closestCorner = new RayTraceWrapper(box, corner, hit.field_72307_f);
            }
            return true;
        }
        return false;
    }

    private static boolean traceToSelectionBoxBody(Box box, Vec3d start, Vec3d end) {
        AxisAlignedBB bb;
        RayTraceResult hit;
        if (box.getPos1() != null && box.getPos2() != null && (hit = (bb = PositionUtils.createEnclosingAABB(box.getPos1(), box.getPos2())).func_72327_a(start, end)) != null) {
            double dist = hit.field_72307_f.func_72438_d(start);
            if (closestBoxDistance < 0.0 || dist < closestBoxDistance) {
                closestBoxDistance = dist;
                closestBox = new RayTraceWrapper(box, PositionUtils.Corner.NONE, hit.field_72307_f);
            }
            return true;
        }
        return false;
    }

    private static boolean traceToPlacementBox(SchematicPlacement placement, Vec3d start, Vec3d end) {
        ImmutableMap<String, Box> boxes = placement.getSubRegionBoxes(SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED);
        boolean hitSomething = false;
        for (Map.Entry entry : boxes.entrySet()) {
            AxisAlignedBB bb;
            RayTraceResult trace;
            String boxName = (String)entry.getKey();
            Box box = (Box)entry.getValue();
            if (box.getPos1() == null || box.getPos2() == null || (trace = (bb = PositionUtils.createEnclosingAABB(box.getPos1(), box.getPos2())).func_72327_a(start, end)) == null) continue;
            double dist = trace.field_72307_f.func_72438_d(start);
            if (!(closestBoxDistance < 0.0) && !(dist < closestBoxDistance)) continue;
            closestBoxDistance = dist;
            closestBox = new RayTraceWrapper(placement, trace.field_72307_f, boxName);
            hitSomething = true;
        }
        return hitSomething;
    }

    private static boolean traceToOrigin(BlockPos pos, Vec3d start, Vec3d end, RayTraceWrapper.HitType type, @Nullable SchematicPlacement placement) {
        AxisAlignedBB bb;
        RayTraceResult trace;
        if (pos != null && (trace = (bb = PositionUtils.createAABBForPosition(pos)).func_72327_a(start, end)) != null) {
            double dist = trace.field_72307_f.func_72438_d(start);
            if (closestOriginDistance < 0.0 || dist < closestOriginDistance) {
                closestOriginDistance = dist;
                originType = type;
                if (type == RayTraceWrapper.HitType.PLACEMENT_ORIGIN) {
                    closestOrigin = new RayTraceWrapper(placement, trace.field_72307_f, null);
                }
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static RayTraceResult traceToPositions(List<BlockPos> posList, Entity entity, double range) {
        if (posList.isEmpty()) {
            return null;
        }
        Vec3d eyesPos = entity.func_174824_e(1.0f);
        Vec3d rangedLookRot = entity.func_70676_i(1.0f).func_186678_a(range);
        Vec3d lookEndPos = eyesPos.func_178787_e(rangedLookRot);
        double closest = -1.0;
        RayTraceResult trace = null;
        for (BlockPos pos : posList) {
            AxisAlignedBB bb;
            RayTraceResult hit;
            if (pos == null || (hit = (bb = PositionUtils.createAABBForPosition(pos)).func_72327_a(eyesPos, lookEndPos)) == null) continue;
            double dist = hit.field_72307_f.func_72438_d(eyesPos);
            if (!(closest < 0.0) && !(dist < closest)) continue;
            trace = new RayTraceResult(RayTraceResult.Type.BLOCK, hit.field_72307_f, hit.field_178784_b, pos);
            closest = dist;
        }
        return trace;
    }

    @Nullable
    public static RayTraceResult traceToSchematicWorld(Entity entity, double range, boolean respectRenderRange) {
        boolean invert = Hotkeys.INVERT_GHOST_BLOCK_RENDER_STATE.getKeybind().isKeybindHeld();
        if (respectRenderRange && (!Configs.Visuals.ENABLE_RENDERING.getBooleanValue() || Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getBooleanValue() == invert)) {
            return null;
        }
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        if (world == null) {
            return null;
        }
        Vec3d eyesPos = entity.func_174824_e(1.0f);
        Vec3d rangedLookRot = entity.func_70676_i(1.0f).func_186678_a(range);
        Vec3d lookEndPos = eyesPos.func_178787_e(rangedLookRot);
        return RayTraceUtils.rayTraceSchematicWorldBlocks((World)world, eyesPos, lookEndPos, false, true, respectRenderRange, 200);
    }

    @Nullable
    public static RayTraceWrapper getGenericTrace(World worldClient, Entity entity, double range, boolean respectRenderRange) {
        return RayTraceUtils.getGenericTrace(worldClient, entity, range, respectRenderRange, false);
    }

    @Nullable
    public static RayTraceWrapper getGenericTrace(World worldClient, Entity entity, double range, boolean respectRenderRange, boolean includeVerifier) {
        SchematicVerifier verifier;
        List<BlockPos> posList;
        RayTraceResult traceMismatch;
        double dist;
        RayTraceResult traceClient = RayTraceUtils.getRayTraceFromEntity(worldClient, entity, true, range);
        RayTraceResult traceSchematic = RayTraceUtils.traceToSchematicWorld(entity, range, respectRenderRange);
        double distClosest = -1.0;
        RayTraceWrapper.HitType type = RayTraceWrapper.HitType.MISS;
        Vec3d eyesPos = entity.func_174824_e(1.0f);
        RayTraceResult trace = null;
        if (traceSchematic != null && traceSchematic.field_72313_a == RayTraceResult.Type.BLOCK) {
            dist = eyesPos.func_72436_e(traceSchematic.field_72307_f);
            if (distClosest < 0.0 || dist < distClosest) {
                trace = traceSchematic;
                distClosest = eyesPos.func_72436_e(traceSchematic.field_72307_f);
                type = RayTraceWrapper.HitType.SCHEMATIC_BLOCK;
            }
        }
        if (traceClient != null && traceClient.field_72313_a == RayTraceResult.Type.BLOCK) {
            dist = eyesPos.func_72436_e(traceClient.field_72307_f);
            if (distClosest < 0.0 || dist < distClosest) {
                trace = traceClient;
                distClosest = dist;
                type = RayTraceWrapper.HitType.VANILLA;
            }
        }
        SchematicPlacement placement = DataManager.getSchematicPlacementManager().getSelectedSchematicPlacement();
        if (includeVerifier && placement != null && placement.hasVerifier() && (traceMismatch = RayTraceUtils.traceToPositions(posList = (verifier = placement.getSchematicVerifier()).getSelectedMismatchBlockPositionsForRender(), entity, range)) != null) {
            trace = traceMismatch;
            type = RayTraceWrapper.HitType.MISMATCH_OVERLAY;
        }
        if (trace != null) {
            return new RayTraceWrapper(type, trace);
        }
        return null;
    }

    @Nullable
    public static RayTraceWrapper getSchematicWorldTraceWrapperIfClosest(World worldClient, Entity entity, double range) {
        RayTraceWrapper trace = RayTraceUtils.getGenericTrace(worldClient, entity, range, true);
        if (trace != null && trace.getHitType() == RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
            return trace;
        }
        return null;
    }

    @Nullable
    public static BlockPos getSchematicWorldTraceIfClosest(World worldClient, Entity entity, double range) {
        RayTraceWrapper trace = RayTraceUtils.getSchematicWorldTraceWrapperIfClosest(worldClient, entity, range);
        return trace != null ? trace.getRayTraceResult().func_178782_a() : null;
    }

    @Nullable
    public static BlockPos getFurthestSchematicWorldTrace(World worldClient, Entity entity, double maxRange) {
        Vec3d eyesPos = entity.func_174824_e(1.0f);
        Vec3d rangedLookRot = entity.func_70676_i(1.0f).func_186678_a(maxRange);
        Vec3d lookEndPos = eyesPos.func_178787_e(rangedLookRot);
        RayTraceResult traceVanilla = RayTraceUtils.getRayTraceFromEntity(worldClient, entity, false, maxRange);
        if (traceVanilla.field_72313_a != RayTraceResult.Type.BLOCK) {
            return null;
        }
        double closestVanilla = traceVanilla.field_72307_f.func_72436_e(eyesPos);
        BlockPos closestVanillaPos = traceVanilla.func_178782_a();
        WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
        List<RayTraceResult> list = RayTraceUtils.rayTraceSchematicWorldBlocksToList((World)worldSchematic, eyesPos, lookEndPos, false, false, false, true, 200);
        RayTraceResult furthestTrace = null;
        double furthestDist = -1.0;
        if (!list.isEmpty()) {
            for (RayTraceResult trace : list) {
                double dist = trace.field_72307_f.func_72436_e(eyesPos);
                if ((furthestDist < 0.0 || dist > furthestDist) && (dist < closestVanilla || closestVanilla < 0.0) && !trace.func_178782_a().equals((Object)closestVanillaPos)) {
                    furthestDist = dist;
                    furthestTrace = trace;
                }
                if (!(closestVanilla >= 0.0) || !(dist > closestVanilla)) continue;
                break;
            }
        }
        if (furthestTrace == null) {
            BlockPos pos = closestVanillaPos.func_177972_a(traceVanilla.field_178784_b);
            LayerRange layerRange = DataManager.getRenderLayerRange();
            if (layerRange.isPositionWithinRange(pos) && worldSchematic.func_180495_p(pos).func_185904_a() != Material.field_151579_a && worldClient.func_180495_p(pos).func_185904_a() == Material.field_151579_a) {
                return pos;
            }
        }
        return furthestTrace != null ? furthestTrace.func_178782_a() : null;
    }

    @Nonnull
    public static RayTraceResult getRayTraceFromEntity(World world, Entity entity, boolean useLiquids, double range) {
        Vec3d rangedLookRot;
        Vec3d lookEndPos;
        Vec3d eyesPos = entity.func_174824_e(1.0f);
        RayTraceResult result = RayTraceUtils.rayTraceBlocks(world, eyesPos, lookEndPos = eyesPos.func_178787_e(rangedLookRot = entity.func_70676_i(1.0f).func_186678_a(range)), useLiquids, false, false, 1000);
        if (result == null) {
            result = new RayTraceResult(RayTraceResult.Type.MISS, Vec3d.field_186680_a, EnumFacing.UP, BlockPos.field_177992_a);
        }
        AxisAlignedBB bb = entity.func_174813_aQ().func_72321_a(rangedLookRot.field_72450_a, rangedLookRot.field_72448_b, rangedLookRot.field_72449_c).func_72321_a(1.0, 1.0, 1.0);
        List list = world.func_72839_b(entity, bb);
        double closest = result.field_72313_a == RayTraceResult.Type.BLOCK ? eyesPos.func_72438_d(result.field_72307_f) : Double.MAX_VALUE;
        RayTraceResult entityTrace = null;
        Entity targetEntity = null;
        for (int i = 0; i < list.size(); ++i) {
            double distance;
            Entity entityTmp = (Entity)list.get(i);
            bb = entityTmp.func_174813_aQ();
            RayTraceResult traceTmp = bb.func_72327_a(lookEndPos, eyesPos);
            if (traceTmp == null || !((distance = eyesPos.func_72438_d(traceTmp.field_72307_f)) <= closest)) continue;
            targetEntity = entityTmp;
            entityTrace = traceTmp;
            closest = distance;
        }
        if (targetEntity != null) {
            result = new RayTraceResult(targetEntity, entityTrace.field_72307_f);
        }
        if (eyesPos.func_72438_d(result.field_72307_f) > range) {
            result = new RayTraceResult(RayTraceResult.Type.MISS, Vec3d.field_186680_a, EnumFacing.UP, BlockPos.field_177992_a);
        }
        return result;
    }

    @Nullable
    public static RayTraceResult rayTraceBlocks(World world, Vec3d vec31, Vec3d vec32, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock, int maxSteps) {
        RayTraceResult raytraceresult;
        if (Double.isNaN(vec31.field_72450_a) || Double.isNaN(vec31.field_72448_b) || Double.isNaN(vec31.field_72449_c) || Double.isNaN(vec32.field_72450_a) || Double.isNaN(vec32.field_72448_b) || Double.isNaN(vec32.field_72449_c)) {
            return null;
        }
        int xEnd = MathHelper.func_76128_c((double)vec32.field_72450_a);
        int yEnd = MathHelper.func_76128_c((double)vec32.field_72448_b);
        int zEnd = MathHelper.func_76128_c((double)vec32.field_72449_c);
        int x = MathHelper.func_76128_c((double)vec31.field_72450_a);
        int y = MathHelper.func_76128_c((double)vec31.field_72448_b);
        int z = MathHelper.func_76128_c((double)vec31.field_72449_c);
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if ((!ignoreBlockWithoutBoundingBox || state.func_185890_d((IBlockAccess)world, pos) != Block.field_185506_k) && block.func_176209_a(state, stopOnLiquid) && (raytraceresult = state.func_185910_a(world, pos, vec31, vec32)) != null) {
            return raytraceresult;
        }
        RayTraceResult trace = null;
        while (--maxSteps >= 0) {
            EnumFacing enumfacing;
            if (Double.isNaN(vec31.field_72450_a) || Double.isNaN(vec31.field_72448_b) || Double.isNaN(vec31.field_72449_c)) {
                return null;
            }
            if (x == xEnd && y == yEnd && z == zEnd) {
                return returnLastUncollidableBlock ? trace : null;
            }
            boolean flag2 = true;
            boolean flag = true;
            boolean flag1 = true;
            double d0 = 999.0;
            double d1 = 999.0;
            double d2 = 999.0;
            if (xEnd > x) {
                d0 = (double)x + 1.0;
            } else if (xEnd < x) {
                d0 = (double)x + 0.0;
            } else {
                flag2 = false;
            }
            if (yEnd > y) {
                d1 = (double)y + 1.0;
            } else if (yEnd < y) {
                d1 = (double)y + 0.0;
            } else {
                flag = false;
            }
            if (zEnd > z) {
                d2 = (double)z + 1.0;
            } else if (zEnd < z) {
                d2 = (double)z + 0.0;
            } else {
                flag1 = false;
            }
            double d3 = 999.0;
            double d4 = 999.0;
            double d5 = 999.0;
            double d6 = vec32.field_72450_a - vec31.field_72450_a;
            double d7 = vec32.field_72448_b - vec31.field_72448_b;
            double d8 = vec32.field_72449_c - vec31.field_72449_c;
            if (flag2) {
                d3 = (d0 - vec31.field_72450_a) / d6;
            }
            if (flag) {
                d4 = (d1 - vec31.field_72448_b) / d7;
            }
            if (flag1) {
                d5 = (d2 - vec31.field_72449_c) / d8;
            }
            if (d3 == -0.0) {
                d3 = -1.0E-4;
            }
            if (d4 == -0.0) {
                d4 = -1.0E-4;
            }
            if (d5 == -0.0) {
                d5 = -1.0E-4;
            }
            if (d3 < d4 && d3 < d5) {
                enumfacing = xEnd > x ? EnumFacing.WEST : EnumFacing.EAST;
                vec31 = new Vec3d(d0, vec31.field_72448_b + d7 * d3, vec31.field_72449_c + d8 * d3);
            } else if (d4 < d5) {
                enumfacing = yEnd > y ? EnumFacing.DOWN : EnumFacing.UP;
                vec31 = new Vec3d(vec31.field_72450_a + d6 * d4, d1, vec31.field_72449_c + d8 * d4);
            } else {
                enumfacing = zEnd > z ? EnumFacing.NORTH : EnumFacing.SOUTH;
                vec31 = new Vec3d(vec31.field_72450_a + d6 * d5, vec31.field_72448_b + d7 * d5, d2);
            }
            x = MathHelper.func_76128_c((double)vec31.field_72450_a) - (enumfacing == EnumFacing.EAST ? 1 : 0);
            y = MathHelper.func_76128_c((double)vec31.field_72448_b) - (enumfacing == EnumFacing.UP ? 1 : 0);
            z = MathHelper.func_76128_c((double)vec31.field_72449_c) - (enumfacing == EnumFacing.SOUTH ? 1 : 0);
            pos = new BlockPos(x, y, z);
            IBlockState iblockstate1 = world.func_180495_p(pos);
            Block block1 = iblockstate1.func_177230_c();
            if (ignoreBlockWithoutBoundingBox && iblockstate1.func_185904_a() != Material.field_151567_E && iblockstate1.func_185890_d((IBlockAccess)world, pos) == Block.field_185506_k) continue;
            if (block1.func_176209_a(iblockstate1, stopOnLiquid)) {
                RayTraceResult raytraceresult1 = iblockstate1.func_185910_a(world, pos, vec31, vec32);
                if (raytraceresult1 == null) continue;
                return raytraceresult1;
            }
            trace = new RayTraceResult(RayTraceResult.Type.MISS, vec31, enumfacing, pos);
        }
        return returnLastUncollidableBlock ? trace : null;
    }

    @Nullable
    public static RayTraceResult rayTraceSchematicWorldBlocks(World world, Vec3d posStart, Vec3d posEnd, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock, boolean respectRenderRange, int maxSteps) {
        RayTraceResult trace;
        if (Double.isNaN(posStart.field_72450_a) || Double.isNaN(posStart.field_72448_b) || Double.isNaN(posStart.field_72449_c) || Double.isNaN(posEnd.field_72450_a) || Double.isNaN(posEnd.field_72448_b) || Double.isNaN(posEnd.field_72449_c)) {
            return null;
        }
        int xEnd = MathHelper.func_76128_c((double)posEnd.field_72450_a);
        int yEnd = MathHelper.func_76128_c((double)posEnd.field_72448_b);
        int zEnd = MathHelper.func_76128_c((double)posEnd.field_72449_c);
        RayTraceCalcsData data = new RayTraceCalcsData(posStart, posEnd);
        LayerRange range = DataManager.getRenderLayerRange();
        data.x = MathHelper.func_76128_c((double)((RayTraceCalcsData)data).posStart.field_72450_a);
        data.y = MathHelper.func_76128_c((double)((RayTraceCalcsData)data).posStart.field_72448_b);
        data.z = MathHelper.func_76128_c((double)((RayTraceCalcsData)data).posStart.field_72449_c);
        data.pos = new BlockPos(data.x, data.y, data.z);
        IBlockState state = world.func_180495_p(data.pos);
        if (!(state.func_185904_a() == Material.field_151579_a || respectRenderRange && !range.isPositionWithinRange(data.x, data.y, data.z) || ignoreBlockWithoutBoundingBox && state.func_185890_d((IBlockAccess)world, data.pos) == Block.field_185506_k || (trace = state.func_185910_a(world, data.pos, data.posStart, posEnd)) == null)) {
            return trace;
        }
        trace = null;
        while (--maxSteps >= 0) {
            RayTraceResult traceTmp;
            if (Double.isNaN(((RayTraceCalcsData)data).posStart.field_72450_a) || Double.isNaN(((RayTraceCalcsData)data).posStart.field_72448_b) || Double.isNaN(((RayTraceCalcsData)data).posStart.field_72449_c)) {
                return null;
            }
            if (data.x == xEnd && data.y == yEnd && data.z == zEnd) {
                return returnLastUncollidableBlock ? trace : null;
            }
            RayTraceUtils.rayTraceCalcs(data);
            state = world.func_180495_p(data.pos);
            if (state.func_185904_a() == Material.field_151579_a || respectRenderRange && !range.isPositionWithinRange(data.x, data.y, data.z) || ignoreBlockWithoutBoundingBox && state.func_185904_a() != Material.field_151567_E && state.func_185890_d((IBlockAccess)world, data.pos) == Block.field_185506_k || (traceTmp = state.func_185910_a(world, data.pos, data.posStart, posEnd)) == null) continue;
            return traceTmp;
        }
        return returnLastUncollidableBlock ? trace : null;
    }

    public static List<RayTraceResult> rayTraceSchematicWorldBlocksToList(World world, Vec3d posStart, Vec3d posEnd, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock, boolean respectRenderRange, int maxSteps) {
        RayTraceResult traceTmp;
        if (Double.isNaN(posStart.field_72450_a) || Double.isNaN(posStart.field_72448_b) || Double.isNaN(posStart.field_72449_c) || Double.isNaN(posEnd.field_72450_a) || Double.isNaN(posEnd.field_72448_b) || Double.isNaN(posEnd.field_72449_c)) {
            return ImmutableList.of();
        }
        int xEnd = MathHelper.func_76128_c((double)posEnd.field_72450_a);
        int yEnd = MathHelper.func_76128_c((double)posEnd.field_72448_b);
        int zEnd = MathHelper.func_76128_c((double)posEnd.field_72449_c);
        RayTraceCalcsData data = new RayTraceCalcsData(posStart, posEnd);
        LayerRange range = DataManager.getRenderLayerRange();
        data.x = MathHelper.func_76128_c((double)((RayTraceCalcsData)data).posStart.field_72450_a);
        data.y = MathHelper.func_76128_c((double)((RayTraceCalcsData)data).posStart.field_72448_b);
        data.z = MathHelper.func_76128_c((double)((RayTraceCalcsData)data).posStart.field_72449_c);
        data.pos = new BlockPos(data.x, data.y, data.z);
        IBlockState state = world.func_180495_p(data.pos);
        Block block = state.func_177230_c();
        ArrayList<RayTraceResult> hits = new ArrayList<RayTraceResult>();
        if (!(respectRenderRange && !range.isPositionWithinRange(data.x, data.y, data.z) || ignoreBlockWithoutBoundingBox && state.func_185890_d((IBlockAccess)world, data.pos) == Block.field_185506_k || !block.func_176209_a(state, stopOnLiquid) || (traceTmp = state.func_185910_a(world, data.pos, data.posStart, posEnd)) == null)) {
            hits.add(traceTmp);
        }
        while (--maxSteps >= 0) {
            if (Double.isNaN(((RayTraceCalcsData)data).posStart.field_72450_a) || Double.isNaN(((RayTraceCalcsData)data).posStart.field_72448_b) || Double.isNaN(((RayTraceCalcsData)data).posStart.field_72449_c)) {
                return hits;
            }
            if (data.x == xEnd && data.y == yEnd && data.z == zEnd) {
                return hits;
            }
            RayTraceUtils.rayTraceCalcs(data);
            state = world.func_180495_p(data.pos);
            block = state.func_177230_c();
            if (respectRenderRange && !range.isPositionWithinRange(data.x, data.y, data.z) || ignoreBlockWithoutBoundingBox && state.func_185904_a() != Material.field_151567_E && state.func_185890_d((IBlockAccess)world, data.pos) == Block.field_185506_k || !block.func_176209_a(state, stopOnLiquid) || (traceTmp = state.func_185910_a(world, data.pos, data.posStart, posEnd)) == null) continue;
            hits.add(traceTmp);
        }
        return hits;
    }

    private static void rayTraceCalcs(RayTraceCalcsData data) {
        boolean xDiffers = true;
        boolean yDiffers = true;
        boolean zDiffers = true;
        double nextX = 999.0;
        double nextY = 999.0;
        double nextZ = 999.0;
        if (data.xEnd > data.x) {
            nextX = (double)data.x + 1.0;
        } else if (data.xEnd < data.x) {
            nextX = (double)data.x + 0.0;
        } else {
            xDiffers = false;
        }
        if (data.yEnd > data.y) {
            nextY = (double)data.y + 1.0;
        } else if (data.yEnd < data.y) {
            nextY = (double)data.y + 0.0;
        } else {
            yDiffers = false;
        }
        if (data.zEnd > data.z) {
            nextZ = (double)data.z + 1.0;
        } else if (data.zEnd < data.z) {
            nextZ = (double)data.z + 0.0;
        } else {
            zDiffers = false;
        }
        double d3 = 999.0;
        double d4 = 999.0;
        double d5 = 999.0;
        double d6 = ((RayTraceCalcsData)data).posEnd.field_72450_a - ((RayTraceCalcsData)data).posStart.field_72450_a;
        double d7 = ((RayTraceCalcsData)data).posEnd.field_72448_b - ((RayTraceCalcsData)data).posStart.field_72448_b;
        double d8 = ((RayTraceCalcsData)data).posEnd.field_72449_c - ((RayTraceCalcsData)data).posStart.field_72449_c;
        if (xDiffers) {
            d3 = (nextX - ((RayTraceCalcsData)data).posStart.field_72450_a) / d6;
        }
        if (yDiffers) {
            d4 = (nextY - ((RayTraceCalcsData)data).posStart.field_72448_b) / d7;
        }
        if (zDiffers) {
            d5 = (nextZ - ((RayTraceCalcsData)data).posStart.field_72449_c) / d8;
        }
        if (d3 == -0.0) {
            d3 = -1.0E-4;
        }
        if (d4 == -0.0) {
            d4 = -1.0E-4;
        }
        if (d5 == -0.0) {
            d5 = -1.0E-4;
        }
        if (d3 < d4 && d3 < d5) {
            data.facing = data.xEnd > data.x ? EnumFacing.WEST : EnumFacing.EAST;
            data.posStart = new Vec3d(nextX, ((RayTraceCalcsData)data).posStart.field_72448_b + d7 * d3, ((RayTraceCalcsData)data).posStart.field_72449_c + d8 * d3);
        } else if (d4 < d5) {
            data.facing = data.yEnd > data.y ? EnumFacing.DOWN : EnumFacing.UP;
            data.posStart = new Vec3d(((RayTraceCalcsData)data).posStart.field_72450_a + d6 * d4, nextY, ((RayTraceCalcsData)data).posStart.field_72449_c + d8 * d4);
        } else {
            data.facing = data.zEnd > data.z ? EnumFacing.NORTH : EnumFacing.SOUTH;
            data.posStart = new Vec3d(((RayTraceCalcsData)data).posStart.field_72450_a + d6 * d5, ((RayTraceCalcsData)data).posStart.field_72448_b + d7 * d5, nextZ);
        }
        data.x = MathHelper.func_76128_c((double)((RayTraceCalcsData)data).posStart.field_72450_a) - (data.facing == EnumFacing.EAST ? 1 : 0);
        data.y = MathHelper.func_76128_c((double)((RayTraceCalcsData)data).posStart.field_72448_b) - (data.facing == EnumFacing.UP ? 1 : 0);
        data.z = MathHelper.func_76128_c((double)((RayTraceCalcsData)data).posStart.field_72449_c) - (data.facing == EnumFacing.SOUTH ? 1 : 0);
        data.pos = new BlockPos(data.x, data.y, data.z);
    }

    public static class RayTraceWrapper {
        private final HitType type;
        private final PositionUtils.Corner corner;
        private final Vec3d hitVec;
        @Nullable
        private final RayTraceResult trace;
        @Nullable
        private final Box box;
        @Nullable
        private final SchematicPlacement schematicPlacement;
        @Nullable
        private final String placementRegionName;

        public RayTraceWrapper() {
            this.type = HitType.MISS;
            this.corner = PositionUtils.Corner.NONE;
            this.hitVec = Vec3d.field_186680_a;
            this.trace = null;
            this.box = null;
            this.schematicPlacement = null;
            this.placementRegionName = null;
        }

        public RayTraceWrapper(RayTraceResult trace) {
            this.type = HitType.VANILLA;
            this.corner = PositionUtils.Corner.NONE;
            this.hitVec = trace.field_72307_f;
            this.trace = trace;
            this.box = null;
            this.schematicPlacement = null;
            this.placementRegionName = null;
        }

        public RayTraceWrapper(HitType type) {
            this.type = type;
            this.corner = PositionUtils.Corner.NONE;
            this.hitVec = Vec3d.field_186680_a;
            this.trace = null;
            this.box = null;
            this.schematicPlacement = null;
            this.placementRegionName = null;
        }

        public RayTraceWrapper(HitType type, RayTraceResult trace) {
            this.type = type;
            this.corner = PositionUtils.Corner.NONE;
            this.hitVec = trace.field_72307_f;
            this.trace = trace;
            this.box = null;
            this.schematicPlacement = null;
            this.placementRegionName = null;
        }

        public RayTraceWrapper(Box box, PositionUtils.Corner corner, Vec3d hitVec) {
            this.type = corner == PositionUtils.Corner.NONE ? HitType.SELECTION_BOX_BODY : HitType.SELECTION_BOX_CORNER;
            this.corner = corner;
            this.hitVec = hitVec;
            this.trace = null;
            this.box = box;
            this.schematicPlacement = null;
            this.placementRegionName = null;
        }

        public RayTraceWrapper(SchematicPlacement placement, Vec3d hitVec, @Nullable String regionName) {
            this.type = regionName != null ? HitType.PLACEMENT_SUBREGION : HitType.PLACEMENT_ORIGIN;
            this.corner = PositionUtils.Corner.NONE;
            this.hitVec = hitVec;
            this.trace = null;
            this.box = null;
            this.schematicPlacement = placement;
            this.placementRegionName = regionName;
        }

        public HitType getHitType() {
            return this.type;
        }

        @Nullable
        public RayTraceResult getRayTraceResult() {
            return this.trace;
        }

        @Nullable
        public Box getHitSelectionBox() {
            return this.box;
        }

        @Nullable
        public SchematicPlacement getHitSchematicPlacement() {
            return this.schematicPlacement;
        }

        @Nullable
        public String getHitSchematicPlacementRegionName() {
            return this.placementRegionName;
        }

        public Vec3d getHitVec() {
            return this.hitVec;
        }

        public PositionUtils.Corner getHitCorner() {
            return this.corner;
        }

        public static enum HitType {
            MISS,
            VANILLA,
            SELECTION_BOX_BODY,
            SELECTION_BOX_CORNER,
            SELECTION_ORIGIN,
            PLACEMENT_SUBREGION,
            PLACEMENT_ORIGIN,
            SCHEMATIC_BLOCK,
            MISMATCH_OVERLAY;

        }
    }

    private static class RayTraceCalcsData {
        private Vec3d posStart;
        private final Vec3d posEnd;
        private final int xEnd;
        private final int yEnd;
        private final int zEnd;
        private int x;
        private int y;
        private int z;
        private BlockPos pos;
        private EnumFacing facing;

        private RayTraceCalcsData(Vec3d posStart, Vec3d posEnd) {
            this.posStart = posStart;
            this.posEnd = posEnd;
            this.xEnd = MathHelper.func_76128_c((double)posEnd.field_72450_a);
            this.yEnd = MathHelper.func_76128_c((double)posEnd.field_72448_b);
            this.zEnd = MathHelper.func_76128_c((double)posEnd.field_72449_c);
            this.x = MathHelper.func_76128_c((double)posStart.field_72450_a);
            this.x = MathHelper.func_76128_c((double)posStart.field_72450_a);
            this.x = MathHelper.func_76128_c((double)posStart.field_72450_a);
            this.pos = new BlockPos(this.x, this.y, this.z);
        }
    }
}

