/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import java.util.IdentityHashMap;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemUtils {
    private static final IdentityHashMap<IBlockState, ItemStack> ITEMS_FOR_STATES = new IdentityHashMap();

    public static ItemStack getItemForState(IBlockState state) {
        ItemStack stack = ITEMS_FOR_STATES.get(state);
        return stack != null ? stack : ItemStack.field_190927_a;
    }

    public static void setItemForBlock(World world, BlockPos pos, IBlockState state) {
        if (!ITEMS_FOR_STATES.containsKey(state)) {
            ITEMS_FOR_STATES.put(state, ItemUtils.getItemForBlock(world, pos, state, false));
        }
    }

    public static ItemStack getItemForBlock(World world, BlockPos pos, IBlockState state, boolean checkCache) {
        ItemStack stack;
        if (checkCache && (stack = ITEMS_FOR_STATES.get(state)) != null) {
            return stack;
        }
        if (state.func_185904_a() == Material.field_151579_a) {
            return ItemStack.field_190927_a;
        }
        stack = ItemUtils.getStateToItemOverride(state);
        if (stack.func_190926_b()) {
            stack = state.func_177230_c().func_185473_a(world, pos, state);
        }
        if (stack.func_190926_b()) {
            stack = ItemStack.field_190927_a;
        } else {
            ItemUtils.overrideStackSize(state, stack);
        }
        ITEMS_FOR_STATES.put(state, stack);
        return stack;
    }

    public static ItemStack getStateToItemOverride(IBlockState state) {
        if (state.func_177230_c() == Blocks.field_150353_l || state.func_177230_c() == Blocks.field_150356_k) {
            return new ItemStack(Items.field_151129_at);
        }
        if (state.func_177230_c() == Blocks.field_150355_j || state.func_177230_c() == Blocks.field_150358_i) {
            return new ItemStack(Items.field_151131_as);
        }
        return ItemStack.field_190927_a;
    }

    private static void overrideStackSize(IBlockState state, ItemStack stack) {
        if (state.func_177230_c() instanceof BlockSlab && ((BlockSlab)state.func_177230_c()).func_176552_j()) {
            stack.func_190920_e(2);
        }
    }

    public static ItemStack storeTEInStack(ItemStack stack, TileEntity te) {
        NBTTagCompound nbt = te.func_189515_b(new NBTTagCompound());
        if (stack.func_77973_b() == Items.field_151144_bL && nbt.func_74764_b("Owner")) {
            NBTTagCompound tagOwner = nbt.func_74775_l("Owner");
            NBTTagCompound tagSkull = new NBTTagCompound();
            tagSkull.func_74782_a("SkullOwner", (NBTBase)tagOwner);
            stack.func_77982_d(tagSkull);
            return stack;
        }
        NBTTagCompound tagLore = new NBTTagCompound();
        NBTTagList tagList = new NBTTagList();
        tagList.func_74742_a((NBTBase)new NBTTagString("(+NBT)"));
        tagLore.func_74782_a("Lore", (NBTBase)tagList);
        stack.func_77983_a("display", (NBTBase)tagLore);
        stack.func_77983_a("BlockEntityTag", (NBTBase)nbt);
        return stack;
    }

    public static String getStackString(ItemStack stack) {
        if (!stack.func_190926_b()) {
            ResourceLocation rl = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b());
            return String.format("[%s @ %d - display: %s - NBT: %s] (%s)", rl != null ? rl.toString() : "null", stack.func_77960_j(), stack.func_82833_r(), stack.func_77978_p() != null ? stack.func_77978_p().toString() : "<no NBT>", stack.toString());
        }
        return "<empty>";
    }
}

