/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class InventoryUtils {
    private static final List<Integer> PICK_BLOCKABLE_SLOTS = new ArrayList<Integer>();
    private static int nextPickSlotIndex;

    public static void setPickBlockableSlots(String configStr) {
        String[] parts;
        PICK_BLOCKABLE_SLOTS.clear();
        for (String str : parts = configStr.split(",")) {
            try {
                int slotNum = Integer.parseInt(str);
                if (!InventoryPlayer.func_184435_e((int)slotNum) || PICK_BLOCKABLE_SLOTS.contains(slotNum)) continue;
                PICK_BLOCKABLE_SLOTS.add(slotNum);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Nullable
    public static IInventory getInventory(World world, BlockPos pos) {
        IInventory inv = null;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IInventory) {
            ILockableContainer cont;
            if (te instanceof TileEntityLockableLoot && !(world instanceof WorldServer)) {
                ((TileEntityLockableLoot)te).func_189404_a(null, 0L);
            }
            inv = (IInventory)te;
            Block block = world.func_180495_p(pos).func_177230_c();
            if (block instanceof BlockChest && (cont = ((BlockChest)block).func_180676_d(world, pos)) instanceof InventoryLargeChest) {
                inv = (InventoryLargeChest)cont;
            }
        }
        return inv;
    }

    public static int findSlotWithItem(InventoryPlayer inv, ItemStack stackReference, boolean reverse, boolean ignoreNBT) {
        int startSlot = reverse ? inv.func_70302_i_() - 1 : 0;
        int endSlot = reverse ? -1 : inv.func_70302_i_();
        int increment = reverse ? -1 : 1;
        for (int slotNum = startSlot; slotNum != endSlot; slotNum += increment) {
            ItemStack stack = inv.func_70301_a(slotNum);
            if (ignoreNBT && ItemStack.func_179545_c((ItemStack)stack, (ItemStack)stackReference)) {
                return slotNum;
            }
            if (ignoreNBT || !fi.dy.masa.malilib.util.InventoryUtils.areStacksEqual((ItemStack)stack, (ItemStack)stackReference)) continue;
            return slotNum;
        }
        return -1;
    }

    public static void setPickedItemToHand(int slotNum, ItemStack stack, boolean ignoreNBT, Minecraft mc) {
        EntityPlayerSP player = mc.field_71439_g;
        InventoryPlayer inventory = player.field_71071_by;
        if (InventoryPlayer.func_184435_e((int)slotNum)) {
            player.field_71071_by.field_70461_c = slotNum;
        } else {
            if (PICK_BLOCKABLE_SLOTS.size() == 0) {
                return;
            }
            if (slotNum == -1 || !InventoryPlayer.func_184435_e((int)slotNum)) {
                slotNum = InventoryUtils.getEmptyPickBlockableHotbarSlot(inventory);
            }
            if (slotNum == -1) {
                slotNum = InventoryUtils.getNextPickBlockableHotbarSlot(inventory);
            }
            if (slotNum != -1) {
                inventory.field_70461_c = slotNum;
                if (player.field_71075_bZ.field_75098_d) {
                    inventory.field_70462_a.set(slotNum, (Object)stack.func_77946_l());
                } else {
                    fi.dy.masa.malilib.util.InventoryUtils.swapItemToMainHand((ItemStack)stack, (Minecraft)mc);
                }
            }
        }
    }

    private static int getEmptyPickBlockableHotbarSlot(InventoryPlayer inventory) {
        if (PICK_BLOCKABLE_SLOTS.contains(inventory.field_70461_c + 1) && ((ItemStack)inventory.field_70462_a.get(inventory.field_70461_c)).func_190926_b()) {
            return inventory.field_70461_c;
        }
        for (int i = 0; i < PICK_BLOCKABLE_SLOTS.size(); ++i) {
            ItemStack stack;
            int slotNum = PICK_BLOCKABLE_SLOTS.get(i) - 1;
            if (slotNum < 0 || slotNum >= inventory.field_70462_a.size() || !(stack = (ItemStack)inventory.field_70462_a.get(slotNum)).func_190926_b()) continue;
            return slotNum;
        }
        return -1;
    }

    private static int getNextPickBlockableHotbarSlot(InventoryPlayer inventory) {
        ItemStack stack;
        if (PICK_BLOCKABLE_SLOTS.contains(inventory.field_70461_c + 1) && ((stack = (ItemStack)inventory.field_70462_a.get(inventory.field_70461_c)).func_190926_b() || !(stack.func_77973_b() instanceof ItemTool))) {
            return inventory.field_70461_c;
        }
        if (nextPickSlotIndex >= PICK_BLOCKABLE_SLOTS.size()) {
            nextPickSlotIndex = 0;
        }
        int slotNum = -1;
        for (int i = 0; i < PICK_BLOCKABLE_SLOTS.size(); ++i) {
            ItemStack stack2;
            slotNum = PICK_BLOCKABLE_SLOTS.get(nextPickSlotIndex) - 1;
            if (++nextPickSlotIndex >= PICK_BLOCKABLE_SLOTS.size()) {
                nextPickSlotIndex = 0;
            }
            if (!(stack2 = (ItemStack)inventory.field_70462_a.get(slotNum)).func_190926_b() && stack2.func_77973_b() instanceof ItemTool) continue;
            return slotNum;
        }
        return -1;
    }
}

