/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import com.google.common.collect.Sets;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.mixin.IMixinCompiledChunk;
import fi.dy.masa.litematica.render.RenderUtils;
import fi.dy.masa.litematica.render.schematic.BufferBuilderCache;
import fi.dy.masa.litematica.render.schematic.ChunkCacheSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkCompileTaskGeneratorSchematic;
import fi.dy.masa.litematica.render.schematic.CompiledChunkSchematic;
import fi.dy.masa.litematica.render.schematic.RenderGlobalSchematic;
import fi.dy.masa.litematica.util.OverlayType;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.SubChunkPos;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class RenderChunkSchematicVbo
extends RenderChunk {
    public static int schematicRenderChunksUpdated;
    private final RenderGlobalSchematic renderGlobal;
    private final VertexBuffer[] vertexBufferOverlay = new VertexBuffer[OverlayRenderType.values().length];
    private final Set<TileEntity> setTileEntities = new HashSet<TileEntity>();
    private final List<IntBoundingBox> boxes = new ArrayList<IntBoundingBox>();
    private final EnumSet<OverlayRenderType> existingOverlays = EnumSet.noneOf(OverlayRenderType.class);
    private boolean hasOverlay = false;
    private boolean ignoreFluidsAsExtra;
    private ChunkCompileTaskGeneratorSchematic compileTask;
    private ChunkCacheSchematic schematicWorldView;
    private ChunkCacheSchematic clientWorldView;
    private CompiledChunkSchematic compiledChunk;
    private Color4f overlayColor;

    public RenderChunkSchematicVbo(World worldIn, RenderGlobal renderGlobalIn, int indexIn) {
        super(worldIn, renderGlobalIn, indexIn);
        this.renderGlobal = (RenderGlobalSchematic)renderGlobalIn;
        if (OpenGlHelper.func_176075_f()) {
            for (int i = 0; i < OverlayRenderType.values().length; ++i) {
                this.vertexBufferOverlay[i] = new VertexBuffer(DefaultVertexFormats.field_181706_f);
            }
        }
    }

    public boolean hasOverlay() {
        return this.hasOverlay;
    }

    public EnumSet<OverlayRenderType> getOverlayTypes() {
        return this.existingOverlays;
    }

    public VertexBuffer getOverlayVertexBuffer(OverlayRenderType type) {
        return this.vertexBufferOverlay[type.ordinal()];
    }

    public void func_178566_a() {
        super.func_178566_a();
        for (int i = 0; i < this.vertexBufferOverlay.length; ++i) {
            if (this.vertexBufferOverlay[i] == null) continue;
            this.vertexBufferOverlay[i].func_177362_c();
        }
    }

    public void resortTransparency(float x, float y, float z, ChunkCompileTaskGeneratorSchematic generator) {
        OverlayRenderType type;
        CompiledChunkSchematic compiledChunk = (CompiledChunkSchematic)generator.getCompiledChunk();
        BufferBuilderCache buffers = generator.getBufferCache();
        BufferBuilder.State bufferState = compiledChunk.getBlockBufferState(BlockRenderLayer.TRANSLUCENT);
        if (bufferState != null && !compiledChunk.func_178491_b(BlockRenderLayer.TRANSLUCENT)) {
            BufferBuilder buffer = buffers.getWorldRendererByLayer(BlockRenderLayer.TRANSLUCENT);
            this.preRenderBlocks(buffer, this.func_178568_j());
            buffer.func_178993_a(bufferState);
            this.postRenderBlocks(BlockRenderLayer.TRANSLUCENT, x, y, z, buffer, compiledChunk);
        }
        if (Configs.Visuals.ENABLE_SCHEMATIC_OVERLAY.getBooleanValue() && (bufferState = compiledChunk.getOverlayBufferState(type = OverlayRenderType.QUAD)) != null && !compiledChunk.isOverlayTypeEmpty(type)) {
            BufferBuilder buffer = buffers.getOverlayBuffer(type);
            this.preRenderOverlay(buffer, type.getGlMode());
            buffer.func_178993_a(bufferState);
            this.postRenderOverlay(type, x, y, z, buffer, compiledChunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildChunk(float x, float y, float z, ChunkCompileTaskGeneratorSchematic generator) {
        this.compiledChunk = new CompiledChunkSchematic();
        generator.getLock().lock();
        try {
            if (generator.getStatus() != ChunkCompileTaskGeneratorSchematic.Status.COMPILING) {
                return;
            }
            generator.setCompiledChunk(this.compiledChunk);
        }
        finally {
            generator.getLock().unlock();
        }
        HashSet<TileEntity> tileEntities = new HashSet<TileEntity>();
        BlockPos posChunk = this.func_178568_j();
        LayerRange range = DataManager.getRenderLayerRange();
        this.existingOverlays.clear();
        this.hasOverlay = false;
        List<IntBoundingBox> list = this.boxes;
        synchronized (list) {
            if (!(this.boxes.isEmpty() || this.schematicWorldView.isEmpty() && this.clientWorldView.isEmpty() || !range.intersects(new SubChunkPos(posChunk.func_177958_n() >> 4, posChunk.func_177956_o() >> 4, posChunk.func_177952_p() >> 4)))) {
                ++schematicRenderChunksUpdated;
                boolean[] usedLayers = new boolean[BlockRenderLayer.values().length];
                BufferBuilderCache buffers = generator.getBufferCache();
                for (IntBoundingBox box : this.boxes) {
                    if ((box = range.getClampedBox(box)) == null) continue;
                    BlockPos posFrom = new BlockPos(box.minX, box.minY, box.minZ);
                    BlockPos posTo = new BlockPos(box.maxX, box.maxY, box.maxZ);
                    for (BlockPos.MutableBlockPos posMutable : BlockPos.func_177975_b((BlockPos)posFrom, (BlockPos)posTo)) {
                        this.renderBlocksAndOverlay((BlockPos)posMutable, tileEntities, usedLayers, buffers);
                    }
                }
                for (BlockRenderLayer layerTmp : BlockRenderLayer.values()) {
                    if (usedLayers[layerTmp.ordinal()]) {
                        ((IMixinCompiledChunk)((Object)this.compiledChunk)).invokeSetLayerUsed(layerTmp);
                    }
                    if (!this.compiledChunk.func_178492_d(layerTmp)) continue;
                    this.postRenderBlocks(layerTmp, x, y, z, buffers.getWorldRendererByLayer(layerTmp), this.compiledChunk);
                }
                if (this.hasOverlay) {
                    for (OverlayRenderType type : this.existingOverlays) {
                        if (!this.compiledChunk.isOverlayTypeStarted(type)) continue;
                        this.compiledChunk.setOverlayTypeUsed(type);
                        this.postRenderOverlay(type, x, y, z, buffers.getOverlayBuffer(type), this.compiledChunk);
                    }
                }
            }
        }
        this.func_178579_c().lock();
        try {
            HashSet set = Sets.newHashSet(tileEntities);
            HashSet set1 = Sets.newHashSet(this.setTileEntities);
            set.removeAll(this.setTileEntities);
            set1.removeAll(tileEntities);
            this.setTileEntities.clear();
            this.setTileEntities.addAll(tileEntities);
            this.renderGlobal.func_181023_a(set1, set);
        }
        finally {
            this.func_178579_c().unlock();
        }
    }

    protected void renderBlocksAndOverlay(BlockPos pos, Set<TileEntity> tileEntities, boolean[] usedLayers, BufferBuilderCache buffers) {
        IBlockState stateSchematic = this.schematicWorldView.func_180495_p(pos);
        IBlockState stateClient = this.clientWorldView.func_180495_p(pos);
        stateSchematic = stateSchematic.func_185899_b((IBlockAccess)this.schematicWorldView, pos);
        stateClient = stateClient.func_185899_b((IBlockAccess)this.clientWorldView, pos);
        Block blockSchematic = stateSchematic.func_177230_c();
        Block blockClient = stateClient.func_177230_c();
        boolean clientHasAir = blockClient == Blocks.field_150350_a;
        boolean schematicHasAir = blockSchematic == Blocks.field_150350_a;
        boolean missing = false;
        if (clientHasAir && schematicHasAir) {
            return;
        }
        this.overlayColor = null;
        if (clientHasAir || stateSchematic != stateClient && Configs.Visuals.RENDER_COLLIDING_SCHEMATIC_BLOCKS.getBooleanValue()) {
            if (blockSchematic.hasTileEntity(stateSchematic)) {
                this.addTileEntity(pos, this.compiledChunk, tileEntities);
            }
            BlockRenderLayer layer = Configs.Visuals.RENDER_BLOCKS_AS_TRANSLUCENT.getBooleanValue() ? BlockRenderLayer.TRANSLUCENT : blockSchematic.func_180664_k();
            int layerIndex = layer.ordinal();
            if (stateSchematic.func_185901_i() != EnumBlockRenderType.INVISIBLE) {
                BufferBuilder bufferSchematic = buffers.getWorldRendererByLayerId(layerIndex);
                if (!this.compiledChunk.func_178492_d(layer)) {
                    this.compiledChunk.func_178493_c(layer);
                    this.preRenderBlocks(bufferSchematic, this.func_178568_j());
                }
                int n = layerIndex;
                usedLayers[n] = usedLayers[n] | this.renderGlobal.renderBlock(stateSchematic, pos, this.schematicWorldView, bufferSchematic);
                if (clientHasAir) {
                    missing = true;
                }
            }
        }
        if (Configs.Visuals.ENABLE_SCHEMATIC_OVERLAY.getBooleanValue()) {
            OverlayType type = this.getOverlayType(stateSchematic, stateClient);
            this.overlayColor = this.getOverlayColor(type);
            if (this.overlayColor != null) {
                this.renderOverlay(type, pos, stateSchematic, missing, buffers);
            }
        }
    }

    protected void renderOverlay(OverlayType type, BlockPos pos, IBlockState stateSchematic, boolean missing, BufferBuilderCache buffers) {
        IBakedModel bakedModel;
        if (Configs.Visuals.SCHEMATIC_OVERLAY_ENABLE_SIDES.getBooleanValue()) {
            BufferBuilder bufferOverlayQuads = buffers.getOverlayBuffer(OverlayRenderType.QUAD);
            if (!this.compiledChunk.isOverlayTypeStarted(OverlayRenderType.QUAD)) {
                this.compiledChunk.setOverlayTypeStarted(OverlayRenderType.QUAD);
                this.preRenderOverlay(bufferOverlayQuads, OverlayRenderType.QUAD);
            }
            if (Configs.Visuals.OVERLAY_REDUCED_INNER_SIDES.getBooleanValue()) {
                BlockPos.PooledMutableBlockPos posMutable = BlockPos.PooledMutableBlockPos.func_185346_s();
                for (int i = 0; i < 6; ++i) {
                    EnumFacing side = PositionUtils.FACING_ALL[i];
                    posMutable.func_181079_c(pos.func_177958_n() + side.func_82601_c(), pos.func_177956_o() + side.func_96559_d(), pos.func_177952_p() + side.func_82599_e());
                    IBlockState adjStateSchematic = this.schematicWorldView.func_180495_p((BlockPos)posMutable);
                    IBlockState adjStateClient = this.clientWorldView.func_180495_p((BlockPos)posMutable);
                    OverlayType typeAdj = this.getOverlayType(adjStateSchematic, adjStateClient);
                    if (missing && Configs.Visuals.SCHEMATIC_OVERLAY_MODEL_SIDES.getBooleanValue()) {
                        IBakedModel bakedModel2 = this.renderGlobal.getModelForState(stateSchematic);
                        if (type.getRenderPriority() <= typeAdj.getRenderPriority() && stateSchematic.func_193401_d((IBlockAccess)this.schematicWorldView, pos, side) == BlockFaceShape.SOLID) continue;
                        RenderUtils.drawBlockModelQuadOverlayBatched(bakedModel2, stateSchematic, pos, side, this.overlayColor, 0.0, bufferOverlayQuads);
                        continue;
                    }
                    if (type.getRenderPriority() <= typeAdj.getRenderPriority()) continue;
                    fi.dy.masa.malilib.render.RenderUtils.drawBlockSpaceSideBatchedQuads((BlockPos)pos, (EnumFacing)side, (Color4f)this.overlayColor, (double)0.0, (BufferBuilder)bufferOverlayQuads);
                }
                posMutable.func_185344_t();
            } else if (missing && Configs.Visuals.SCHEMATIC_OVERLAY_MODEL_SIDES.getBooleanValue()) {
                bakedModel = this.renderGlobal.getModelForState(stateSchematic);
                RenderUtils.drawBlockModelQuadOverlayBatched(bakedModel, stateSchematic, pos, this.overlayColor, 0.0, bufferOverlayQuads);
            } else {
                fi.dy.masa.malilib.render.RenderUtils.drawBlockSpaceAllSidesBatchedQuads((BlockPos)pos, (Color4f)this.overlayColor, (double)0.0, (BufferBuilder)bufferOverlayQuads);
            }
        }
        if (Configs.Visuals.SCHEMATIC_OVERLAY_ENABLE_OUTLINES.getBooleanValue()) {
            BufferBuilder bufferOverlayOutlines = buffers.getOverlayBuffer(OverlayRenderType.OUTLINE);
            if (!this.compiledChunk.isOverlayTypeStarted(OverlayRenderType.OUTLINE)) {
                this.compiledChunk.setOverlayTypeStarted(OverlayRenderType.OUTLINE);
                this.preRenderOverlay(bufferOverlayOutlines, OverlayRenderType.OUTLINE);
            }
            this.overlayColor = new Color4f(this.overlayColor.r, this.overlayColor.g, this.overlayColor.b, 1.0f);
            if (Configs.Visuals.OVERLAY_REDUCED_INNER_SIDES.getBooleanValue()) {
                OverlayType[][][] adjTypes = new OverlayType[3][3][3];
                BlockPos.PooledMutableBlockPos posMutable = BlockPos.PooledMutableBlockPos.func_185346_s();
                for (int y = 0; y <= 2; ++y) {
                    for (int z = 0; z <= 2; ++z) {
                        for (int x = 0; x <= 2; ++x) {
                            if (x != 1 || y != 1 || z != 1) {
                                posMutable.func_181079_c(pos.func_177958_n() + x - 1, pos.func_177956_o() + y - 1, pos.func_177952_p() + z - 1);
                                IBlockState adjStateSchematic = this.schematicWorldView.func_180495_p((BlockPos)posMutable);
                                IBlockState adjStateClient = this.clientWorldView.func_180495_p((BlockPos)posMutable);
                                adjTypes[x][y][z] = this.getOverlayType(adjStateSchematic, adjStateClient);
                                continue;
                            }
                            adjTypes[x][y][z] = type;
                        }
                    }
                }
                posMutable.func_185344_t();
                if (missing && Configs.Visuals.SCHEMATIC_OVERLAY_MODEL_OUTLINE.getBooleanValue()) {
                    IBakedModel bakedModel3 = this.renderGlobal.getModelForState(stateSchematic);
                    if (stateSchematic.func_185917_h()) {
                        this.renderOverlayReducedEdges(pos, adjTypes, type, bufferOverlayOutlines);
                    } else {
                        RenderUtils.drawBlockModelOutlinesBatched(bakedModel3, stateSchematic, pos, this.overlayColor, 0.0, bufferOverlayOutlines);
                    }
                } else {
                    this.renderOverlayReducedEdges(pos, adjTypes, type, bufferOverlayOutlines);
                }
            } else if (missing && Configs.Visuals.SCHEMATIC_OVERLAY_MODEL_OUTLINE.getBooleanValue()) {
                bakedModel = this.renderGlobal.getModelForState(stateSchematic);
                RenderUtils.drawBlockModelOutlinesBatched(bakedModel, stateSchematic, pos, this.overlayColor, 0.0, bufferOverlayOutlines);
            } else {
                fi.dy.masa.malilib.render.RenderUtils.drawBlockSpaceAllOutlinesBatchedLines((BlockPos)pos, (Color4f)this.overlayColor, (double)0.0, (BufferBuilder)bufferOverlayOutlines);
            }
        }
    }

    protected void renderOverlayReducedEdges(BlockPos pos, OverlayType[][][] adjTypes, OverlayType typeSelf, BufferBuilder bufferOverlayOutlines) {
        OverlayType[] neighborTypes = new OverlayType[4];
        Vec3i[] neighborPositions = new Vec3i[4];
        int lines = 0;
        for (EnumFacing.Axis axis : PositionUtils.AXES_ALL) {
            for (int corner = 0; corner < 4; ++corner) {
                Vec3i[] offsets = PositionUtils.getEdgeNeighborOffsets(axis, corner);
                int index = -1;
                boolean hasCurrent = false;
                for (int i = 0; i < 4; ++i) {
                    Vec3i offset = offsets[i];
                    OverlayType type = adjTypes[offset.func_177958_n() + 1][offset.func_177956_o() + 1][offset.func_177952_p() + 1];
                    if (type == OverlayType.NONE || index != -1 && type.getRenderPriority() < neighborTypes[index - 1].getRenderPriority()) continue;
                    if (index < 0 || type.getRenderPriority() > neighborTypes[index - 1].getRenderPriority()) {
                        index = 0;
                    }
                    neighborPositions[index] = new Vec3i(pos.func_177958_n() + offset.func_177958_n(), pos.func_177956_o() + offset.func_177956_o(), pos.func_177952_p() + offset.func_177952_p());
                    neighborTypes[index] = type;
                    hasCurrent |= i == 0;
                    ++index;
                }
                if (index <= 0 || !hasCurrent) continue;
                Vec3i posTmp = new Vec3i(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                int ind = -1;
                for (int i = 0; i < index; ++i) {
                    Vec3i tmp = neighborPositions[i];
                    if (tmp.func_177958_n() > posTmp.func_177958_n() || tmp.func_177956_o() > posTmp.func_177956_o() || tmp.func_177952_p() > posTmp.func_177952_p()) continue;
                    posTmp = tmp;
                    ind = i;
                }
                if (posTmp.func_177958_n() != pos.func_177958_n() || posTmp.func_177956_o() != pos.func_177956_o() || posTmp.func_177952_p() != pos.func_177952_p()) continue;
                RenderUtils.drawBlockBoxEdgeBatchedLines(pos, axis, corner, this.overlayColor, bufferOverlayOutlines);
                ++lines;
            }
        }
    }

    protected OverlayType getOverlayType(IBlockState stateSchematic, IBlockState stateClient) {
        boolean schematicHasAir;
        if (stateSchematic == stateClient) {
            return OverlayType.NONE;
        }
        boolean clientHasAir = stateClient.func_177230_c() == Blocks.field_150350_a;
        boolean bl = schematicHasAir = stateSchematic.func_177230_c() == Blocks.field_150350_a;
        if (schematicHasAir) {
            return clientHasAir || this.ignoreFluidsAsExtra && stateClient.func_185904_a().func_76224_d() ? OverlayType.NONE : OverlayType.EXTRA;
        }
        if (clientHasAir) {
            return OverlayType.MISSING;
        }
        if (stateSchematic.func_177230_c() != stateClient.func_177230_c()) {
            return OverlayType.WRONG_BLOCK;
        }
        return OverlayType.WRONG_STATE;
    }

    @Nullable
    protected Color4f getOverlayColor(OverlayType overlayType) {
        Color4f overlayColor = null;
        switch (overlayType) {
            case MISSING: {
                if (!Configs.Visuals.SCHEMATIC_OVERLAY_TYPE_MISSING.getBooleanValue()) break;
                overlayColor = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_MISSING.getColor();
                break;
            }
            case EXTRA: {
                if (!Configs.Visuals.SCHEMATIC_OVERLAY_TYPE_EXTRA.getBooleanValue()) break;
                overlayColor = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_EXTRA.getColor();
                break;
            }
            case WRONG_BLOCK: {
                if (!Configs.Visuals.SCHEMATIC_OVERLAY_TYPE_WRONG_BLOCK.getBooleanValue()) break;
                overlayColor = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_WRONG_BLOCK.getColor();
                break;
            }
            case WRONG_STATE: {
                if (!Configs.Visuals.SCHEMATIC_OVERLAY_TYPE_WRONG_STATE.getBooleanValue()) break;
                overlayColor = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_WRONG_STATE.getColor();
                break;
            }
        }
        return overlayColor;
    }

    private void addTileEntity(BlockPos pos, CompiledChunk compiledChunk, Set<TileEntity> tileEntities) {
        TileEntitySpecialRenderer tesr;
        TileEntity te = this.schematicWorldView.getTileEntity(pos, Chunk.EnumCreateEntityType.CHECK);
        if (te != null && (tesr = TileEntityRendererDispatcher.field_147556_a.func_147547_b(te)) != null) {
            compiledChunk.func_178490_a(te);
            if (tesr.func_188185_a(te)) {
                tileEntities.add(te);
            }
        }
    }

    private void preRenderBlocks(BufferBuilder buffer, BlockPos pos) {
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        buffer.func_178969_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
    }

    private void postRenderBlocks(BlockRenderLayer layer, float x, float y, float z, BufferBuilder buffer, CompiledChunkSchematic compiledChunk) {
        if (layer == BlockRenderLayer.TRANSLUCENT && !compiledChunk.func_178491_b(layer)) {
            buffer.func_181674_a(x, y, z);
            compiledChunk.setBlockBufferState(layer, buffer.func_181672_a());
        }
        buffer.func_178977_d();
    }

    private void preRenderOverlay(BufferBuilder buffer, OverlayRenderType type) {
        this.existingOverlays.add(type);
        this.hasOverlay = true;
        BlockPos pos = this.func_178568_j();
        buffer.func_181668_a(type.getGlMode(), DefaultVertexFormats.field_181706_f);
        buffer.func_178969_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
    }

    private void preRenderOverlay(BufferBuilder buffer, int glMode) {
        BlockPos pos = this.func_178568_j();
        buffer.func_181668_a(glMode, DefaultVertexFormats.field_181706_f);
        buffer.func_178969_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
    }

    private void postRenderOverlay(OverlayRenderType type, float x, float y, float z, BufferBuilder buffer, CompiledChunkSchematic compiledChunk) {
        if (type == OverlayRenderType.QUAD && !compiledChunk.isOverlayTypeEmpty(type)) {
            buffer.func_181674_a(x, y, z);
            compiledChunk.setOverlayBufferState(type, buffer.func_181672_a());
        }
        buffer.func_178977_d();
    }

    public ChunkCompileTaskGeneratorSchematic makeCompileTaskChunkSchematic() {
        this.func_178579_c().lock();
        ChunkCompileTaskGeneratorSchematic generator = null;
        try {
            this.func_178578_b();
            this.compileTask = new ChunkCompileTaskGeneratorSchematic(this, ChunkCompileTaskGeneratorSchematic.Type.REBUILD_CHUNK, this.func_188280_f());
            this.rebuildWorldView();
            generator = this.compileTask;
        }
        finally {
            this.func_178579_c().unlock();
        }
        return generator;
    }

    @Nullable
    public ChunkCompileTaskGeneratorSchematic makeCompileTaskTransparencySchematic() {
        this.func_178579_c().lock();
        try {
            if (this.compileTask == null || this.compileTask.getStatus() != ChunkCompileTaskGeneratorSchematic.Status.PENDING) {
                if (this.compileTask != null && this.compileTask.getStatus() != ChunkCompileTaskGeneratorSchematic.Status.DONE) {
                    this.compileTask.finish();
                }
                this.compileTask = new ChunkCompileTaskGeneratorSchematic(this, ChunkCompileTaskGeneratorSchematic.Type.RESORT_TRANSPARENCY, this.func_188280_f());
                this.compileTask.setCompiledChunk(this.compiledChunk);
                ChunkCompileTaskGeneratorSchematic chunkCompileTaskGeneratorSchematic = this.compileTask;
                return chunkCompileTaskGeneratorSchematic;
            }
        }
        finally {
            this.func_178579_c().unlock();
        }
        return null;
    }

    protected void func_178578_b() {
        this.func_178579_c().lock();
        try {
            if (this.compileTask != null && this.compileTask.getStatus() != ChunkCompileTaskGeneratorSchematic.Status.DONE) {
                this.compileTask.finish();
                this.compileTask = null;
            }
        }
        finally {
            this.func_178579_c().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildWorldView() {
        List<IntBoundingBox> list = this.boxes;
        synchronized (list) {
            this.ignoreFluidsAsExtra = Configs.Visuals.IGNORE_FLUIDS_AS_EXTRA.getBooleanValue();
            this.schematicWorldView = new ChunkCacheSchematic(this.func_188283_p(), this.func_178568_j(), 2);
            this.clientWorldView = new ChunkCacheSchematic((World)Minecraft.func_71410_x().field_71441_e, this.func_178568_j(), 2);
            BlockPos pos = this.func_178568_j();
            SubChunkPos subChunk = new SubChunkPos(pos.func_177958_n() >> 4, pos.func_177956_o() >> 4, pos.func_177952_p() >> 4);
            this.boxes.clear();
            this.boxes.addAll(DataManager.getSchematicPlacementManager().getTouchedBoxesInSubChunk(subChunk));
        }
    }

    public static enum OverlayRenderType {
        OUTLINE(1),
        QUAD(7);

        private final int glMode;

        private OverlayRenderType(int glMode) {
            this.glMode = glMode;
        }

        public int getGlMode() {
            return this.glMode;
        }
    }
}

