/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render;

import fi.dy.masa.litematica.util.BlockInfoAlignment;
import fi.dy.masa.litematica.util.InventoryUtils;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.HorizontalAlignment;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class RenderUtils {
    public static int getMaxStringRenderLength(List<String> list) {
        int length = 0;
        for (String str : list) {
            length = Math.max(length, StringUtils.getStringWidth((String)str));
        }
        return length;
    }

    public static void renderBlockOutline(BlockPos pos, float expand, float lineWidth, Color4f color, Entity renderViewEntity, float partialTicks) {
        GlStateManager.func_187441_d((float)lineWidth);
        AxisAlignedBB aabb = RenderUtils.createAABB(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), expand, partialTicks, renderViewEntity);
        RenderGlobal.func_189697_a((AxisAlignedBB)aabb, (float)color.r, (float)color.g, (float)color.b, (float)color.a);
    }

    public static void drawBlockBoundingBoxOutlinesBatchedLines(BlockPos pos, Color4f color, double expand, BufferBuilder buffer, Entity renderViewEntity, float partialTicks) {
        double dx = renderViewEntity.field_70142_S + (renderViewEntity.field_70165_t - renderViewEntity.field_70142_S) * (double)partialTicks;
        double dy = renderViewEntity.field_70137_T + (renderViewEntity.field_70163_u - renderViewEntity.field_70137_T) * (double)partialTicks;
        double dz = renderViewEntity.field_70136_U + (renderViewEntity.field_70161_v - renderViewEntity.field_70136_U) * (double)partialTicks;
        double minX = (double)pos.func_177958_n() - dx - expand;
        double minY = (double)pos.func_177956_o() - dy - expand;
        double minZ = (double)pos.func_177952_p() - dz - expand;
        double maxX = (double)pos.func_177958_n() - dx + expand + 1.0;
        double maxY = (double)pos.func_177956_o() - dy + expand + 1.0;
        double maxZ = (double)pos.func_177952_p() - dz + expand + 1.0;
        fi.dy.masa.malilib.render.RenderUtils.drawBoxAllEdgesBatchedLines((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (Color4f)color, (BufferBuilder)buffer);
    }

    public static void drawConnectingLineBatchedLines(BlockPos pos1, BlockPos pos2, boolean center, Color4f color, BufferBuilder buffer, Entity renderViewEntity, float partialTicks) {
        double dx = renderViewEntity.field_70142_S + (renderViewEntity.field_70165_t - renderViewEntity.field_70142_S) * (double)partialTicks;
        double dy = renderViewEntity.field_70137_T + (renderViewEntity.field_70163_u - renderViewEntity.field_70137_T) * (double)partialTicks;
        double dz = renderViewEntity.field_70136_U + (renderViewEntity.field_70161_v - renderViewEntity.field_70136_U) * (double)partialTicks;
        double x1 = (double)pos1.func_177958_n() - dx;
        double y1 = (double)pos1.func_177956_o() - dy;
        double z1 = (double)pos1.func_177952_p() - dz;
        double x2 = (double)pos2.func_177958_n() - dx;
        double y2 = (double)pos2.func_177956_o() - dy;
        double z2 = (double)pos2.func_177952_p() - dz;
        if (center) {
            x1 += 0.5;
            y1 += 0.5;
            z1 += 0.5;
            x2 += 0.5;
            y2 += 0.5;
            z2 += 0.5;
        }
        buffer.func_181662_b(x1, y1, z1).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(x2, y2, z2).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
    }

    public static void renderBlockOutlineOverlapping(BlockPos pos, float expand, float lineWidth, Color4f color1, Color4f color2, Color4f color3, Entity renderViewEntity, float partialTicks) {
        double dx = renderViewEntity.field_70142_S + (renderViewEntity.field_70165_t - renderViewEntity.field_70142_S) * (double)partialTicks;
        double dy = renderViewEntity.field_70137_T + (renderViewEntity.field_70163_u - renderViewEntity.field_70137_T) * (double)partialTicks;
        double dz = renderViewEntity.field_70136_U + (renderViewEntity.field_70161_v - renderViewEntity.field_70136_U) * (double)partialTicks;
        double minX = (double)pos.func_177958_n() - dx - (double)expand;
        double minY = (double)pos.func_177956_o() - dy - (double)expand;
        double minZ = (double)pos.func_177952_p() - dz - (double)expand;
        double maxX = (double)pos.func_177958_n() - dx + (double)expand + 1.0;
        double maxY = (double)pos.func_177956_o() - dy + (double)expand + 1.0;
        double maxZ = (double)pos.func_177952_p() - dz + (double)expand + 1.0;
        GlStateManager.func_187441_d((float)lineWidth);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(color1.r, color1.g, color1.b, color1.a).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(color1.r, color1.g, color1.b, color1.a).func_181675_d();
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(color1.r, color1.g, color1.b, color1.a).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181666_a(color1.r, color1.g, color1.b, color1.a).func_181675_d();
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(color1.r, color1.g, color1.b, color1.a).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181666_a(color1.r, color1.g, color1.b, color1.a).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(color2.r, color2.g, color2.b, color2.a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(color2.r, color2.g, color2.b, color2.a).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(color2.r, color2.g, color2.b, color2.a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(color2.r, color2.g, color2.b, color2.a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(color2.r, color2.g, color2.b, color2.a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(color2.r, color2.g, color2.b, color2.a).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181666_a(color3.r, color3.g, color3.b, color3.a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(color3.r, color3.g, color3.b, color3.a).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181666_a(color3.r, color3.g, color3.b, color3.a).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(color3.r, color3.g, color3.b, color3.a).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(color3.r, color3.g, color3.b, color3.a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(color3.r, color3.g, color3.b, color3.a).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181666_a(color3.r, color3.g, color3.b, color3.a).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(color3.r, color3.g, color3.b, color3.a).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(color3.r, color3.g, color3.b, color3.a).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(color3.r, color3.g, color3.b, color3.a).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181666_a(color3.r, color3.g, color3.b, color3.a).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(color3.r, color3.g, color3.b, color3.a).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void renderAreaOutline(BlockPos pos1, BlockPos pos2, float lineWidth, Color4f colorX, Color4f colorY, Color4f colorZ, Entity renderViewEntity, float partialTicks) {
        GlStateManager.func_187441_d((float)lineWidth);
        AxisAlignedBB aabb = RenderUtils.createEnclosingAABB(pos1, pos2, renderViewEntity, partialTicks);
        RenderUtils.drawBoundingBoxEdges(aabb, colorX, colorY, colorZ);
    }

    private static void drawBoundingBoxEdges(AxisAlignedBB box, Color4f colorX, Color4f colorY, Color4f colorZ) {
        RenderUtils.drawBoundingBoxEdges(box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72334_f, colorX, colorY, colorZ);
    }

    private static void drawBoundingBoxEdges(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Color4f colorX, Color4f colorY, Color4f colorZ) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        RenderUtils.drawBoundingBoxLinesX(bufferbuilder, minX, minY, minZ, maxX, maxY, maxZ, colorX);
        RenderUtils.drawBoundingBoxLinesY(bufferbuilder, minX, minY, minZ, maxX, maxY, maxZ, colorY);
        RenderUtils.drawBoundingBoxLinesZ(bufferbuilder, minX, minY, minZ, maxX, maxY, maxZ, colorZ);
        tessellator.func_78381_a();
    }

    private static void drawBoundingBoxLinesX(BufferBuilder buffer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Color4f color) {
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
    }

    private static void drawBoundingBoxLinesY(BufferBuilder buffer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Color4f color) {
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
    }

    private static void drawBoundingBoxLinesZ(BufferBuilder buffer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Color4f color) {
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
    }

    public static void renderAreaSides(BlockPos pos1, BlockPos pos2, Color4f color, Entity renderViewEntity, float partialTicks) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179129_p();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        RenderUtils.renderAreaSidesBatched(pos1, pos2, color, 0.002, renderViewEntity, partialTicks, buffer);
        tessellator.func_78381_a();
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
    }

    public static void renderAreaSidesBatched(BlockPos pos1, BlockPos pos2, Color4f color, double expand, Entity renderViewEntity, float partialTicks, BufferBuilder buffer) {
        double dx = renderViewEntity.field_70142_S + (renderViewEntity.field_70165_t - renderViewEntity.field_70142_S) * (double)partialTicks;
        double dy = renderViewEntity.field_70137_T + (renderViewEntity.field_70163_u - renderViewEntity.field_70137_T) * (double)partialTicks;
        double dz = renderViewEntity.field_70136_U + (renderViewEntity.field_70161_v - renderViewEntity.field_70136_U) * (double)partialTicks;
        double minX = (double)Math.min(pos1.func_177958_n(), pos2.func_177958_n()) - dx - expand;
        double minY = (double)Math.min(pos1.func_177956_o(), pos2.func_177956_o()) - dy - expand;
        double minZ = (double)Math.min(pos1.func_177952_p(), pos2.func_177952_p()) - dz - expand;
        double maxX = (double)(Math.max(pos1.func_177958_n(), pos2.func_177958_n()) + 1) - dx + expand;
        double maxY = (double)(Math.max(pos1.func_177956_o(), pos2.func_177956_o()) + 1) - dy + expand;
        double maxZ = (double)(Math.max(pos1.func_177952_p(), pos2.func_177952_p()) + 1) - dz + expand;
        fi.dy.masa.malilib.render.RenderUtils.drawBoxAllSidesBatchedQuads((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (Color4f)color, (BufferBuilder)buffer);
    }

    public static void renderAreaOutlineNoCorners(BlockPos pos1, BlockPos pos2, float lineWidth, Color4f colorX, Color4f colorY, Color4f colorZ, Entity renderViewEntity, float partialTicks) {
        int end;
        int xMin = Math.min(pos1.func_177958_n(), pos2.func_177958_n());
        int yMin = Math.min(pos1.func_177956_o(), pos2.func_177956_o());
        int zMin = Math.min(pos1.func_177952_p(), pos2.func_177952_p());
        int xMax = Math.max(pos1.func_177958_n(), pos2.func_177958_n());
        int yMax = Math.max(pos1.func_177956_o(), pos2.func_177956_o());
        int zMax = Math.max(pos1.func_177952_p(), pos2.func_177952_p());
        double expand = 0.001;
        double dx = renderViewEntity.field_70142_S + (renderViewEntity.field_70165_t - renderViewEntity.field_70142_S) * (double)partialTicks;
        double dy = renderViewEntity.field_70137_T + (renderViewEntity.field_70163_u - renderViewEntity.field_70137_T) * (double)partialTicks;
        double dz = renderViewEntity.field_70136_U + (renderViewEntity.field_70161_v - renderViewEntity.field_70136_U) * (double)partialTicks;
        double dxMin = -dx - 0.001;
        double dyMin = -dy - 0.001;
        double dzMin = -dz - 0.001;
        double dxMax = -dx + 0.001;
        double dyMax = -dy + 0.001;
        double dzMax = -dz + 0.001;
        double minX = (double)xMin + dxMin;
        double minY = (double)yMin + dyMin;
        double minZ = (double)zMin + dzMin;
        double maxX = (double)xMax + dxMax;
        double maxY = (double)yMax + dyMax;
        double maxZ = (double)zMax + dzMax;
        GlStateManager.func_187441_d((float)lineWidth);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        int start = pos1.func_177958_n() == xMin && pos1.func_177956_o() == yMin && pos1.func_177952_p() == zMin || pos2.func_177958_n() == xMin && pos2.func_177956_o() == yMin && pos2.func_177952_p() == zMin ? xMin + 1 : xMin;
        int n = end = pos1.func_177958_n() == xMax && pos1.func_177956_o() == yMin && pos1.func_177952_p() == zMin || pos2.func_177958_n() == xMax && pos2.func_177956_o() == yMin && pos2.func_177952_p() == zMin ? xMax : xMax + 1;
        if (end > start) {
            buffer.func_181662_b((double)start + dxMin, minY, minZ).func_181666_a(colorX.r, colorX.g, colorX.b, colorX.a).func_181675_d();
            buffer.func_181662_b((double)end + dxMax, minY, minZ).func_181666_a(colorX.r, colorX.g, colorX.b, colorX.a).func_181675_d();
        }
        start = pos1.func_177958_n() == xMin && pos1.func_177956_o() == yMax && pos1.func_177952_p() == zMin || pos2.func_177958_n() == xMin && pos2.func_177956_o() == yMax && pos2.func_177952_p() == zMin ? xMin + 1 : xMin;
        int n2 = end = pos1.func_177958_n() == xMax && pos1.func_177956_o() == yMax && pos1.func_177952_p() == zMin || pos2.func_177958_n() == xMax && pos2.func_177956_o() == yMax && pos2.func_177952_p() == zMin ? xMax : xMax + 1;
        if (end > start) {
            buffer.func_181662_b((double)start + dxMin, maxY + 1.0, minZ).func_181666_a(colorX.r, colorX.g, colorX.b, colorX.a).func_181675_d();
            buffer.func_181662_b((double)end + dxMax, maxY + 1.0, minZ).func_181666_a(colorX.r, colorX.g, colorX.b, colorX.a).func_181675_d();
        }
        start = pos1.func_177958_n() == xMin && pos1.func_177956_o() == yMin && pos1.func_177952_p() == zMax || pos2.func_177958_n() == xMin && pos2.func_177956_o() == yMin && pos2.func_177952_p() == zMax ? xMin + 1 : xMin;
        int n3 = end = pos1.func_177958_n() == xMax && pos1.func_177956_o() == yMin && pos1.func_177952_p() == zMax || pos2.func_177958_n() == xMax && pos2.func_177956_o() == yMin && pos2.func_177952_p() == zMax ? xMax : xMax + 1;
        if (end > start) {
            buffer.func_181662_b((double)start + dxMin, minY, maxZ + 1.0).func_181666_a(colorX.r, colorX.g, colorX.b, colorX.a).func_181675_d();
            buffer.func_181662_b((double)end + dxMax, minY, maxZ + 1.0).func_181666_a(colorX.r, colorX.g, colorX.b, colorX.a).func_181675_d();
        }
        start = pos1.func_177958_n() == xMin && pos1.func_177956_o() == yMax && pos1.func_177952_p() == zMax || pos2.func_177958_n() == xMin && pos2.func_177956_o() == yMax && pos2.func_177952_p() == zMax ? xMin + 1 : xMin;
        int n4 = end = pos1.func_177958_n() == xMax && pos1.func_177956_o() == yMax && pos1.func_177952_p() == zMax || pos2.func_177958_n() == xMax && pos2.func_177956_o() == yMax && pos2.func_177952_p() == zMax ? xMax : xMax + 1;
        if (end > start) {
            buffer.func_181662_b((double)start + dxMin, maxY + 1.0, maxZ + 1.0).func_181666_a(colorX.r, colorX.g, colorX.b, colorX.a).func_181675_d();
            buffer.func_181662_b((double)end + dxMax, maxY + 1.0, maxZ + 1.0).func_181666_a(colorX.r, colorX.g, colorX.b, colorX.a).func_181675_d();
        }
        start = pos1.func_177958_n() == xMin && pos1.func_177956_o() == yMin && pos1.func_177952_p() == zMin || pos2.func_177958_n() == xMin && pos2.func_177956_o() == yMin && pos2.func_177952_p() == zMin ? yMin + 1 : yMin;
        int n5 = end = pos1.func_177958_n() == xMin && pos1.func_177956_o() == yMax && pos1.func_177952_p() == zMin || pos2.func_177958_n() == xMin && pos2.func_177956_o() == yMax && pos2.func_177952_p() == zMin ? yMax : yMax + 1;
        if (end > start) {
            buffer.func_181662_b(minX, (double)start + dyMin, minZ).func_181666_a(colorY.r, colorY.g, colorY.b, colorY.a).func_181675_d();
            buffer.func_181662_b(minX, (double)end + dyMax, minZ).func_181666_a(colorY.r, colorY.g, colorY.b, colorY.a).func_181675_d();
        }
        start = pos1.func_177958_n() == xMax && pos1.func_177956_o() == yMin && pos1.func_177952_p() == zMin || pos2.func_177958_n() == xMax && pos2.func_177956_o() == yMin && pos2.func_177952_p() == zMin ? yMin + 1 : yMin;
        int n6 = end = pos1.func_177958_n() == xMax && pos1.func_177956_o() == yMax && pos1.func_177952_p() == zMin || pos2.func_177958_n() == xMax && pos2.func_177956_o() == yMax && pos2.func_177952_p() == zMin ? yMax : yMax + 1;
        if (end > start) {
            buffer.func_181662_b(maxX + 1.0, (double)start + dyMin, minZ).func_181666_a(colorY.r, colorY.g, colorY.b, colorY.a).func_181675_d();
            buffer.func_181662_b(maxX + 1.0, (double)end + dyMax, minZ).func_181666_a(colorY.r, colorY.g, colorY.b, colorY.a).func_181675_d();
        }
        start = pos1.func_177958_n() == xMin && pos1.func_177956_o() == yMin && pos1.func_177952_p() == zMax || pos2.func_177958_n() == xMin && pos2.func_177956_o() == yMin && pos2.func_177952_p() == zMax ? yMin + 1 : yMin;
        int n7 = end = pos1.func_177958_n() == xMin && pos1.func_177956_o() == yMax && pos1.func_177952_p() == zMax || pos2.func_177958_n() == xMin && pos2.func_177956_o() == yMax && pos2.func_177952_p() == zMax ? yMax : yMax + 1;
        if (end > start) {
            buffer.func_181662_b(minX, (double)start + dyMin, maxZ + 1.0).func_181666_a(colorY.r, colorY.g, colorY.b, colorY.a).func_181675_d();
            buffer.func_181662_b(minX, (double)end + dyMax, maxZ + 1.0).func_181666_a(colorY.r, colorY.g, colorY.b, colorY.a).func_181675_d();
        }
        start = pos1.func_177958_n() == xMax && pos1.func_177956_o() == yMin && pos1.func_177952_p() == zMax || pos2.func_177958_n() == xMax && pos2.func_177956_o() == yMin && pos2.func_177952_p() == zMax ? yMin + 1 : yMin;
        int n8 = end = pos1.func_177958_n() == xMax && pos1.func_177956_o() == yMax && pos1.func_177952_p() == zMax || pos2.func_177958_n() == xMax && pos2.func_177956_o() == yMax && pos2.func_177952_p() == zMax ? yMax : yMax + 1;
        if (end > start) {
            buffer.func_181662_b(maxX + 1.0, (double)start + dyMin, maxZ + 1.0).func_181666_a(colorY.r, colorY.g, colorY.b, colorY.a).func_181675_d();
            buffer.func_181662_b(maxX + 1.0, (double)end + dyMax, maxZ + 1.0).func_181666_a(colorY.r, colorY.g, colorY.b, colorY.a).func_181675_d();
        }
        start = pos1.func_177958_n() == xMin && pos1.func_177956_o() == yMin && pos1.func_177952_p() == zMin || pos2.func_177958_n() == xMin && pos2.func_177956_o() == yMin && pos2.func_177952_p() == zMin ? zMin + 1 : zMin;
        int n9 = end = pos1.func_177958_n() == xMin && pos1.func_177956_o() == yMin && pos1.func_177952_p() == zMax || pos2.func_177958_n() == xMin && pos2.func_177956_o() == yMin && pos2.func_177952_p() == zMax ? zMax : zMax + 1;
        if (end > start) {
            buffer.func_181662_b(minX, minY, (double)start + dzMin).func_181666_a(colorZ.r, colorZ.g, colorZ.b, colorZ.a).func_181675_d();
            buffer.func_181662_b(minX, minY, (double)end + dzMax).func_181666_a(colorZ.r, colorZ.g, colorZ.b, colorZ.a).func_181675_d();
        }
        start = pos1.func_177958_n() == xMax && pos1.func_177956_o() == yMin && pos1.func_177952_p() == zMin || pos2.func_177958_n() == xMax && pos2.func_177956_o() == yMin && pos2.func_177952_p() == zMin ? zMin + 1 : zMin;
        int n10 = end = pos1.func_177958_n() == xMax && pos1.func_177956_o() == yMin && pos1.func_177952_p() == zMax || pos2.func_177958_n() == xMax && pos2.func_177956_o() == yMin && pos2.func_177952_p() == zMax ? zMax : zMax + 1;
        if (end > start) {
            buffer.func_181662_b(maxX + 1.0, minY, (double)start + dzMin).func_181666_a(colorZ.r, colorZ.g, colorZ.b, colorZ.a).func_181675_d();
            buffer.func_181662_b(maxX + 1.0, minY, (double)end + dzMax).func_181666_a(colorZ.r, colorZ.g, colorZ.b, colorZ.a).func_181675_d();
        }
        start = pos1.func_177958_n() == xMin && pos1.func_177956_o() == yMax && pos1.func_177952_p() == zMin || pos2.func_177958_n() == xMin && pos2.func_177956_o() == yMax && pos2.func_177952_p() == zMin ? zMin + 1 : zMin;
        int n11 = end = pos1.func_177958_n() == xMin && pos1.func_177956_o() == yMax && pos1.func_177952_p() == zMax || pos2.func_177958_n() == xMin && pos2.func_177956_o() == yMax && pos2.func_177952_p() == zMax ? zMax : zMax + 1;
        if (end > start) {
            buffer.func_181662_b(minX, maxY + 1.0, (double)start + dzMin).func_181666_a(colorZ.r, colorZ.g, colorZ.b, colorZ.a).func_181675_d();
            buffer.func_181662_b(minX, maxY + 1.0, (double)end + dzMax).func_181666_a(colorZ.r, colorZ.g, colorZ.b, colorZ.a).func_181675_d();
        }
        start = pos1.func_177958_n() == xMax && pos1.func_177956_o() == yMax && pos1.func_177952_p() == zMin || pos2.func_177958_n() == xMax && pos2.func_177956_o() == yMax && pos2.func_177952_p() == zMin ? zMin + 1 : zMin;
        int n12 = end = pos1.func_177958_n() == xMax && pos1.func_177956_o() == yMax && pos1.func_177952_p() == zMax || pos2.func_177958_n() == xMax && pos2.func_177956_o() == yMax && pos2.func_177952_p() == zMax ? zMax : zMax + 1;
        if (end > start) {
            buffer.func_181662_b(maxX + 1.0, maxY + 1.0, (double)start + dzMin).func_181666_a(colorZ.r, colorZ.g, colorZ.b, colorZ.a).func_181675_d();
            buffer.func_181662_b(maxX + 1.0, maxY + 1.0, (double)end + dzMax).func_181666_a(colorZ.r, colorZ.g, colorZ.b, colorZ.a).func_181675_d();
        }
        tessellator.func_78381_a();
    }

    public static void drawBlockModelOutlinesBatched(IBakedModel model, IBlockState state, BlockPos pos, Color4f color, double expand, BufferBuilder buffer) {
        long rand = MathHelper.func_180186_a((Vec3i)pos);
        for (EnumFacing side : PositionUtils.FACING_ALL) {
            RenderUtils.renderModelQuadOutlines(pos, buffer, color, model.func_188616_a(state, side, rand));
        }
        RenderUtils.renderModelQuadOutlines(pos, buffer, color, model.func_188616_a(state, null, rand));
    }

    private static void renderModelQuadOutlines(BlockPos pos, BufferBuilder buffer, Color4f color, List<BakedQuad> quads) {
        int size = quads.size();
        for (int i = 0; i < size; ++i) {
            RenderUtils.renderQuadOutlinesBatched(pos, buffer, color, quads.get(i).func_178209_a());
        }
    }

    private static void renderQuadOutlinesBatched(BlockPos pos, BufferBuilder buffer, Color4f color, int[] vertexData) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        float[] fx = new float[4];
        float[] fy = new float[4];
        float[] fz = new float[4];
        for (int index = 0; index < 4; ++index) {
            fx[index] = (float)x + Float.intBitsToFloat(vertexData[index * 7 + 0]);
            fy[index] = (float)y + Float.intBitsToFloat(vertexData[index * 7 + 1]);
            fz[index] = (float)z + Float.intBitsToFloat(vertexData[index * 7 + 2]);
        }
        buffer.func_181662_b((double)fx[0], (double)fy[0], (double)fz[0]).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b((double)fx[1], (double)fy[1], (double)fz[1]).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b((double)fx[1], (double)fy[1], (double)fz[1]).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b((double)fx[2], (double)fy[2], (double)fz[2]).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b((double)fx[2], (double)fy[2], (double)fz[2]).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b((double)fx[3], (double)fy[3], (double)fz[3]).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b((double)fx[3], (double)fy[3], (double)fz[3]).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b((double)fx[0], (double)fy[0], (double)fz[0]).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
    }

    public static void drawBlockModelQuadOverlayBatched(IBakedModel model, IBlockState state, BlockPos pos, Color4f color, double expand, BufferBuilder buffer) {
        long rand = MathHelper.func_180186_a((Vec3i)pos);
        for (EnumFacing side : PositionUtils.FACING_ALL) {
            RenderUtils.renderModelQuadOverlayBatched(pos, buffer, color, model.func_188616_a(state, side, rand));
        }
        RenderUtils.renderModelQuadOverlayBatched(pos, buffer, color, model.func_188616_a(state, null, rand));
    }

    public static void drawBlockModelQuadOverlayBatched(IBakedModel model, IBlockState state, BlockPos pos, EnumFacing side, Color4f color, double expand, BufferBuilder buffer) {
        long rand = MathHelper.func_180186_a((Vec3i)pos);
        RenderUtils.renderModelQuadOverlayBatched(pos, buffer, color, model.func_188616_a(state, side, rand));
    }

    private static void renderModelQuadOverlayBatched(BlockPos pos, BufferBuilder buffer, Color4f color, List<BakedQuad> quads) {
        int size = quads.size();
        for (int i = 0; i < size; ++i) {
            RenderUtils.renderModelQuadOverlayBatched(pos, buffer, color, quads.get(i).func_178209_a());
        }
    }

    private static void renderModelQuadOverlayBatched(BlockPos pos, BufferBuilder buffer, Color4f color, int[] vertexData) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        for (int index = 0; index < 4; ++index) {
            float fx = (float)x + Float.intBitsToFloat(vertexData[index * 7 + 0]);
            float fy = (float)y + Float.intBitsToFloat(vertexData[index * 7 + 1]);
            float fz = (float)z + Float.intBitsToFloat(vertexData[index * 7 + 2]);
            buffer.func_181662_b((double)fx, (double)fy, (double)fz).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        }
    }

    public static void drawBlockBoxEdgeBatchedLines(BlockPos pos, EnumFacing.Axis axis, int cornerIndex, Color4f color, BufferBuilder buffer) {
        Vec3i offset = PositionUtils.getEdgeNeighborOffsets(axis, cornerIndex)[cornerIndex];
        double minX = pos.func_177958_n() + offset.func_177958_n();
        double minY = pos.func_177956_o() + offset.func_177956_o();
        double minZ = pos.func_177952_p() + offset.func_177952_p();
        double maxX = pos.func_177958_n() + offset.func_177958_n() + (axis == EnumFacing.Axis.X ? 1 : 0);
        double maxY = pos.func_177956_o() + offset.func_177956_o() + (axis == EnumFacing.Axis.Y ? 1 : 0);
        double maxZ = pos.func_177952_p() + offset.func_177952_p() + (axis == EnumFacing.Axis.Z ? 1 : 0);
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
    }

    public static int renderInventoryOverlays(BlockInfoAlignment align, int offY, World worldSchematic, World worldClient, BlockPos pos, Minecraft mc) {
        int heightSch = RenderUtils.renderInventoryOverlay(align, HorizontalAlignment.LEFT, offY, worldSchematic, pos, mc);
        int heightCli = RenderUtils.renderInventoryOverlay(align, HorizontalAlignment.RIGHT, offY, worldClient, pos, mc);
        return Math.max(heightSch, heightCli);
    }

    public static int renderInventoryOverlay(BlockInfoAlignment align, HorizontalAlignment side, int offY, World world, BlockPos pos, Minecraft mc) {
        IInventory inv = InventoryUtils.getInventory(world, pos);
        if (inv != null) {
            InventoryOverlay.InventoryRenderType type = InventoryOverlay.getInventoryType((IInventory)inv);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp((InventoryOverlay.InventoryRenderType)type, (int)inv.func_70302_i_());
            return RenderUtils.renderInventoryOverlay(align, side, offY, inv, type, props, mc);
        }
        return 0;
    }

    public static int renderInventoryOverlay(BlockInfoAlignment align, HorizontalAlignment side, int offY, IInventory inv, InventoryOverlay.InventoryRenderType type, InventoryOverlay.InventoryProperties props, Minecraft mc) {
        int xInv = 0;
        int yInv = 0;
        switch (align) {
            case CENTER: {
                xInv = GuiUtils.getScaledWindowWidth() / 2 - props.width / 2;
                yInv = GuiUtils.getScaledWindowHeight() / 2 - props.height - offY;
                break;
            }
            case TOP_CENTER: {
                xInv = GuiUtils.getScaledWindowWidth() / 2 - props.width / 2;
                yInv = offY;
            }
        }
        if (side == HorizontalAlignment.LEFT) {
            xInv -= props.width / 2 + 4;
        } else if (side == HorizontalAlignment.RIGHT) {
            xInv += props.width / 2 + 4;
        }
        fi.dy.masa.malilib.render.RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)xInv, (int)yInv, (int)props.slotsPerRow, (int)props.totalSlots, (Minecraft)mc);
        InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (IInventory)inv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (int)props.slotsPerRow, (int)0, (int)-1, (Minecraft)mc);
        return props.height;
    }

    public static AxisAlignedBB createEnclosingAABB(BlockPos pos1, BlockPos pos2, Entity renderViewEntity, float partialTicks) {
        int minX = Math.min(pos1.func_177958_n(), pos2.func_177958_n());
        int minY = Math.min(pos1.func_177956_o(), pos2.func_177956_o());
        int minZ = Math.min(pos1.func_177952_p(), pos2.func_177952_p());
        int maxX = Math.max(pos1.func_177958_n(), pos2.func_177958_n()) + 1;
        int maxY = Math.max(pos1.func_177956_o(), pos2.func_177956_o()) + 1;
        int maxZ = Math.max(pos1.func_177952_p(), pos2.func_177952_p()) + 1;
        return RenderUtils.createAABB(minX, minY, minZ, maxX, maxY, maxZ, 0.0, partialTicks, renderViewEntity);
    }

    public static AxisAlignedBB createAABB(int x, int y, int z, double expand, double partialTicks, Entity renderViewEntity) {
        return RenderUtils.createAABB(x, y, z, x + 1, y + 1, z + 1, expand, partialTicks, renderViewEntity);
    }

    public static AxisAlignedBB createAABB(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, double expand, double partialTicks, Entity entity) {
        double dx = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * partialTicks;
        double dy = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * partialTicks;
        double dz = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * partialTicks;
        return new AxisAlignedBB((double)minX - dx - expand, (double)minY - dy - expand, (double)minZ - dz - expand, (double)maxX - dx + expand, (double)maxY - dy + expand, (double)maxZ - dz + expand);
    }
}

