/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render;

import fi.dy.masa.litematica.util.ItemUtils;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.BlockUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class BlockInfo {
    private final String title;
    private final IBlockState state;
    private final ItemStack stack;
    private final String blockRegistryname;
    private final String stackName;
    private final List<String> props;
    private final int totalWidth;
    private final int totalHeight;
    private final int columnWidth;

    public BlockInfo(IBlockState state, String titleKey) {
        String pre = GuiBase.TXT_WHITE + GuiBase.TXT_BOLD;
        this.title = pre + StringUtils.translate((String)titleKey, (Object[])new Object[0]) + GuiBase.TXT_RST;
        this.state = state;
        this.stack = ItemUtils.getItemForState(this.state);
        ResourceLocation rl = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.state.func_177230_c());
        this.blockRegistryname = rl != null ? rl.toString() : "<null>";
        this.stackName = this.stack.func_82833_r();
        int w = StringUtils.getStringWidth((String)this.stackName) + 20;
        w = Math.max(w, StringUtils.getStringWidth((String)this.blockRegistryname));
        this.columnWidth = w = Math.max(w, StringUtils.getStringWidth((String)this.title));
        this.props = BlockUtils.getFormattedBlockStateProperties((IBlockState)this.state, (String)" = ");
        this.totalWidth = this.columnWidth + 40;
        this.totalHeight = this.props.size() * (StringUtils.getFontHeight() + 2) + 50;
    }

    public int getTotalWidth() {
        return this.totalWidth;
    }

    public int getTotalHeight() {
        return this.totalHeight;
    }

    public void render(int x, int y, Minecraft mc) {
        if (this.state != null) {
            GlStateManager.func_179094_E();
            RenderUtils.drawOutlinedBox((int)x, (int)y, (int)this.totalWidth, (int)this.totalHeight, (int)-16777216, (int)-6710887);
            FontRenderer textRenderer = mc.field_71466_p;
            int x1 = x + 10;
            textRenderer.func_78276_b(this.title, x1, y += 4, -1);
            GlStateManager.func_179140_f();
            RenderUtils.enableGuiItemLighting();
            RenderUtils.drawRect((int)x1, (int)(y += 12), (int)16, (int)16, (int)0x20FFFFFF);
            mc.func_175599_af().func_184391_a((EntityLivingBase)mc.field_71439_g, this.stack, x1, y);
            mc.func_175599_af().func_180453_a(textRenderer, this.stack, x1, y, null);
            RenderUtils.disableItemLighting();
            textRenderer.func_78276_b(this.stackName, x1 + 20, y + 4, -1);
            textRenderer.func_78276_b(this.blockRegistryname, x1, y += 20, -12558081);
            RenderUtils.renderText((int)x1, (int)(y += textRenderer.field_78288_b + 4), (int)-5197648, this.props);
            GlStateManager.func_179121_F();
        }
    }
}

