/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.materials;

import fi.dy.masa.litematica.materials.MaterialCache;
import fi.dy.masa.litematica.materials.MaterialListEntry;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.container.LitematicaBlockStateContainer;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.ItemType;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3i;

public class MaterialListUtils {
    public static List<MaterialListEntry> createMaterialListFor(LitematicaSchematic schematic) {
        return MaterialListUtils.createMaterialListFor(schematic, schematic.getAreas().keySet());
    }

    public static List<MaterialListEntry> createMaterialListFor(LitematicaSchematic schematic, Collection<String> subRegions) {
        Object2IntOpenHashMap countsTotal = new Object2IntOpenHashMap();
        for (String regionName : subRegions) {
            LitematicaBlockStateContainer container = schematic.getSubRegionContainer(regionName);
            if (container == null) continue;
            Vec3i size = container.getSize();
            int sizeX = size.func_177958_n();
            int sizeY = size.func_177956_o();
            int sizeZ = size.func_177952_p();
            for (int y = 0; y < sizeY; ++y) {
                for (int z = 0; z < sizeZ; ++z) {
                    for (int x = 0; x < sizeX; ++x) {
                        IBlockState state = container.get(x, y, z);
                        countsTotal.addTo((Object)state, 1);
                    }
                }
            }
        }
        Minecraft mc = Minecraft.func_71410_x();
        return MaterialListUtils.getMaterialList((Object2IntOpenHashMap<IBlockState>)countsTotal, (Object2IntOpenHashMap<IBlockState>)countsTotal, (Object2IntOpenHashMap<IBlockState>)new Object2IntOpenHashMap(), (EntityPlayer)mc.field_71439_g);
    }

    public static List<MaterialListEntry> getMaterialList(Object2IntOpenHashMap<IBlockState> countsTotal, Object2IntOpenHashMap<IBlockState> countsMissing, Object2IntOpenHashMap<IBlockState> countsMismatch, EntityPlayer player) {
        ArrayList<MaterialListEntry> list = new ArrayList<MaterialListEntry>();
        if (!countsTotal.isEmpty()) {
            MaterialCache cache = MaterialCache.getInstance();
            Object2IntOpenHashMap itemTypesTotal = new Object2IntOpenHashMap();
            Object2IntOpenHashMap itemTypesMissing = new Object2IntOpenHashMap();
            Object2IntOpenHashMap itemTypesMismatch = new Object2IntOpenHashMap();
            MaterialListUtils.convertStatesToStacks(countsTotal, (Object2IntOpenHashMap<ItemType>)itemTypesTotal, cache);
            MaterialListUtils.convertStatesToStacks(countsMissing, (Object2IntOpenHashMap<ItemType>)itemTypesMissing, cache);
            MaterialListUtils.convertStatesToStacks(countsMismatch, (Object2IntOpenHashMap<ItemType>)itemTypesMismatch, cache);
            Object2IntOpenHashMap playerInvItems = InventoryUtils.getInventoryItemCounts((IInventory)player.field_71071_by);
            for (ItemType type : itemTypesTotal.keySet()) {
                list.add(new MaterialListEntry(type.getStack().func_77946_l(), itemTypesTotal.getInt((Object)type), itemTypesMissing.getInt((Object)type), itemTypesMismatch.getInt((Object)type), playerInvItems.getInt((Object)type)));
            }
        }
        return list;
    }

    private static void convertStatesToStacks(Object2IntOpenHashMap<IBlockState> blockStatesIn, Object2IntOpenHashMap<ItemType> itemTypesOut, MaterialCache cache) {
        for (IBlockState state : blockStatesIn.keySet()) {
            if (cache.requiresMultipleItems(state)) {
                for (ItemStack stack : cache.getItems(state)) {
                    ItemType type = new ItemType(stack, false, true);
                    itemTypesOut.addTo((Object)type, blockStatesIn.getInt((Object)state) * stack.func_190916_E());
                }
                continue;
            }
            ItemStack stack = cache.getRequiredBuildItemForState(state);
            if (stack.func_190926_b()) continue;
            ItemType type = new ItemType(stack, false, true);
            itemTypesOut.addTo((Object)type, blockStatesIn.getInt((Object)state) * stack.func_190916_E());
        }
    }

    public static void updateAvailableCounts(List<MaterialListEntry> list, EntityPlayer player) {
        Object2IntOpenHashMap playerInvItems = InventoryUtils.getInventoryItemCounts((IInventory)player.field_71071_by);
        for (MaterialListEntry entry : list) {
            ItemType type = new ItemType(entry.getStack(), false, true);
            int countAvailable = playerInvItems.getInt((Object)type);
            entry.setCountAvailable(countAvailable);
        }
    }
}

