/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.materials;

import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.materials.MaterialListBase;
import fi.dy.masa.litematica.materials.MaterialListEntry;
import fi.dy.masa.litematica.materials.MaterialListSorter;
import fi.dy.masa.litematica.materials.MaterialListUtils;
import fi.dy.masa.litematica.render.infohud.IInfoHudRenderer;
import fi.dy.masa.litematica.render.infohud.RenderPhase;
import fi.dy.masa.malilib.config.values.HudAlignment;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;

public class MaterialListHudRenderer
implements IInfoHudRenderer {
    protected final MaterialListBase materialList;
    protected final MaterialListSorter sorter;
    protected boolean shouldRender;
    protected long lastUpdateTime;

    public MaterialListHudRenderer(MaterialListBase materialList) {
        this.materialList = materialList;
        this.sorter = new MaterialListSorter(materialList);
    }

    @Override
    public boolean getShouldRenderText(RenderPhase phase) {
        return false;
    }

    @Override
    public boolean getShouldRenderCustom() {
        return this.shouldRender;
    }

    @Override
    public boolean shouldRenderInGuis() {
        return Configs.Generic.RENDER_MATERIALS_IN_GUI.getBooleanValue();
    }

    public void toggleShouldRender() {
        this.shouldRender = !this.shouldRender;
    }

    @Override
    public List<String> getText(RenderPhase phase) {
        return Collections.emptyList();
    }

    @Override
    public int render(int xOffset, int yOffset, HudAlignment alignment) {
        int i;
        List<MaterialListEntry> list;
        Minecraft mc = Minecraft.func_71410_x();
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastUpdateTime > 2000L) {
            MaterialListUtils.updateAvailableCounts(this.materialList.getMaterialsAll(), (EntityPlayer)mc.field_71439_g);
            list = this.materialList.getMaterialsMissingOnly(true);
            Collections.sort(list, this.sorter);
            this.lastUpdateTime = currentTime;
        } else {
            list = this.materialList.getMaterialsMissingOnly(false);
        }
        if (list.size() == 0) {
            return 0;
        }
        FontRenderer font = mc.field_71466_p;
        double scale = Configs.InfoOverlays.MATERIAL_LIST_HUD_SCALE.getDoubleValue();
        int maxLines = Configs.InfoOverlays.MATERIAL_LIST_HUD_MAX_LINES.getIntegerValue();
        int bgMargin = 2;
        int lineHeight = 16;
        int contentHeight = Math.min(list.size(), maxLines) * lineHeight + bgMargin + 10;
        int maxTextLength = 0;
        int maxCountLength = 0;
        int posX = xOffset + bgMargin;
        int posY = yOffset + bgMargin;
        int bgColor = -1610612736;
        int textColor = -1;
        boolean useBackground = true;
        boolean useShadow = false;
        int size = Math.min(list.size(), maxLines);
        if (scale == 0.0) {
            return 0;
        }
        for (int i2 = 0; i2 < size; ++i2) {
            MaterialListEntry entry = list.get(i2);
            maxTextLength = Math.max(maxTextLength, font.func_78256_a(entry.getStack().func_82833_r()));
            int multiplier = this.materialList.getMultiplier();
            int count = multiplier == 1 ? entry.getCountMissing() - entry.getCountAvailable() : entry.getCountTotal();
            String strCount = GuiBase.TXT_RED + this.getFormattedCountString(count *= multiplier, entry.getStack().func_77976_d()) + GuiBase.TXT_RST;
            maxCountLength = Math.max(maxCountLength, font.func_78256_a(strCount));
        }
        int maxLineLength = maxTextLength + maxCountLength + 30;
        switch (alignment) {
            case TOP_RIGHT: 
            case BOTTOM_RIGHT: {
                posX = (int)((double)GuiUtils.getScaledWindowWidth() / scale - (double)maxLineLength - (double)xOffset - (double)bgMargin);
                break;
            }
            case CENTER: {
                posX = (int)((double)GuiUtils.getScaledWindowWidth() / scale / 2.0 - (double)(maxLineLength / 2) - (double)xOffset);
                break;
            }
        }
        if (scale != 1.0 && scale != 0.0) {
            yOffset = (int)((double)yOffset / scale);
        }
        posY = RenderUtils.getHudPosY((int)posY, (int)yOffset, (int)contentHeight, (double)scale, (HudAlignment)alignment);
        posY += RenderUtils.getHudOffsetForPotions((HudAlignment)alignment, (double)scale, (EntityPlayer)mc.field_71439_g);
        if (scale != 1.0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
        }
        if (useBackground) {
            RenderUtils.drawRect((int)(posX - bgMargin), (int)(posY - bgMargin), (int)(maxLineLength + bgMargin * 2), (int)(contentHeight + bgMargin), (int)bgColor);
        }
        String title = GuiBase.TXT_BOLD + StringUtils.translate((String)"litematica.gui.button.material_list", (Object[])new Object[0]) + GuiBase.TXT_RST;
        if (useShadow) {
            font.func_175063_a(title, (float)(posX + 2), (float)(posY + 2), textColor);
        } else {
            font.func_78276_b(title, posX + 2, posY + 2, textColor);
        }
        int itemCountTextColor = Configs.Colors.MATERIAL_LIST_HUD_ITEM_COUNTS.getIntegerValue();
        int x = posX + 18;
        int y = (posY += 12) + 4;
        for (i = 0; i < size; ++i) {
            MaterialListEntry entry = list.get(i);
            String text = entry.getStack().func_82833_r();
            int multiplier = this.materialList.getMultiplier();
            int count = multiplier == 1 ? entry.getCountMissing() - entry.getCountAvailable() : entry.getCountTotal();
            String strCount = this.getFormattedCountString(count *= multiplier, entry.getStack().func_77976_d());
            int cntLen = font.func_78256_a(strCount);
            int cntPosX = posX + maxLineLength - cntLen - 2;
            if (useShadow) {
                font.func_175063_a(text, (float)x, (float)y, textColor);
                font.func_175063_a(strCount, (float)cntPosX, (float)y, itemCountTextColor);
            } else {
                font.func_78276_b(text, x, y, textColor);
                font.func_78276_b(strCount, cntPosX, y, itemCountTextColor);
            }
            y += lineHeight;
        }
        x = posX;
        y = posY;
        GlStateManager.func_179091_B();
        RenderUtils.setupBlend();
        RenderUtils.enableGuiItemLighting();
        for (i = 0; i < size; ++i) {
            mc.func_175599_af().func_184391_a((EntityLivingBase)mc.field_71439_g, list.get(i).getStack(), x, y);
            y += lineHeight;
        }
        RenderUtils.disableItemLighting();
        GlStateManager.func_179101_C();
        GlStateManager.func_179084_k();
        if (scale != 1.0) {
            GlStateManager.func_179121_F();
        }
        return contentHeight + 4;
    }

    protected String getFormattedCountString(int count, int maxStackSize) {
        int stacks = count / maxStackSize;
        int remainder = count % maxStackSize;
        double boxCount = (double)count / (27.0 * (double)maxStackSize);
        if (count > maxStackSize) {
            if (boxCount >= 1.0) {
                return String.format("%d (%.2f %s)", count, boxCount, StringUtils.translate((String)"litematica.gui.label.material_list.abbr.shulker_box", (Object[])new Object[0]));
            }
            if (Configs.InfoOverlays.MATERIAL_LIST_HUD_STACKS.getBooleanValue()) {
                if (remainder > 0) {
                    return String.format("%d (%d x %d + %d)", count, stacks, maxStackSize, remainder);
                }
                return String.format("%d (%d x %d)", count, stacks, maxStackSize);
            }
        }
        return String.format("%d", count);
    }
}

