/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.gui;

import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.gui.GuiSchematicSaveBase;
import fi.dy.masa.litematica.gui.widgets.WidgetSchematicBrowser;
import fi.dy.masa.litematica.scheduler.TaskScheduler;
import fi.dy.masa.litematica.scheduler.tasks.TaskSaveSchematic;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.selection.AreaSelection;
import fi.dy.masa.litematica.selection.SelectionManager;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.interfaces.ICompletionListener;
import fi.dy.masa.malilib.interfaces.IStringConsumer;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.io.File;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;

public class GuiSchematicSave
extends GuiSchematicSaveBase
implements ICompletionListener {
    private final SelectionManager selectionManager;

    public GuiSchematicSave() {
        this(null);
    }

    public GuiSchematicSave(@Nullable LitematicaSchematic schematic) {
        super(schematic);
        this.title = schematic != null ? StringUtils.translate((String)"litematica.gui.title.save_schematic_from_memory", (Object[])new Object[0]) : StringUtils.translate((String)"litematica.gui.title.create_schematic_from_selection", (Object[])new Object[0]);
        this.selectionManager = DataManager.getSelectionManager();
        AreaSelection area = this.selectionManager.getCurrentSelection();
        if (area != null) {
            this.defaultText = FileUtils.generateSafeFileName((String)area.getName());
            if (Configs.Generic.GENERATE_LOWERCASE_NAMES.getBooleanValue()) {
                this.defaultText = FileUtils.generateSimpleSafeFileName((String)this.defaultText);
            }
        }
    }

    @Override
    public String getBrowserContext() {
        return "schematic_save";
    }

    @Override
    public File getDefaultDirectory() {
        return DataManager.getSchematicsBaseDirectory();
    }

    public void onTaskCompleted() {
        if (this.field_146297_k.func_152345_ab()) {
            this.refreshList();
        } else {
            this.field_146297_k.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    GuiSchematicSave.this.refreshList();
                }
            });
        }
    }

    private void refreshList() {
        if (GuiUtils.getCurrentScreen() == this) {
            ((WidgetSchematicBrowser)this.getListWidget()).refreshEntries();
            ((WidgetSchematicBrowser)this.getListWidget()).clearSchematicMetadataCache();
        }
    }

    @Override
    protected void saveSchematic() {
        File dir = ((WidgetSchematicBrowser)this.getListWidget()).getCurrentDirectory();
        String fileName = this.getTextFieldText();
        if (FileUtils.doesFilenameContainIllegalCharacters((String)fileName)) {
            this.addMessage(Message.MessageType.ERROR, "litematica.error.illegal_characters_in_file_name", new Object[]{fileName});
            return;
        }
        if (!dir.isDirectory()) {
            this.addMessage(Message.MessageType.ERROR, "litematica.error.schematic_save.invalid_directory", new Object[]{dir.getAbsolutePath()});
            return;
        }
        if (fileName.isEmpty()) {
            this.addMessage(Message.MessageType.ERROR, "litematica.error.schematic_save.invalid_schematic_name", new Object[]{fileName});
            return;
        }
        if (this.schematic != null) {
            LitematicaSchematic schematic = this.schematic;
            if (schematic.writeToFile(dir, fileName, GuiBase.isShiftDown())) {
                schematic.getMetadata().clearModifiedSinceSaved();
                ((WidgetSchematicBrowser)this.getListWidget()).refreshEntries();
                this.addMessage(Message.MessageType.SUCCESS, "litematica.message.schematic_saved_as", new Object[]{fileName});
            }
        } else {
            AreaSelection area = this.selectionManager.getCurrentSelection();
            if (area != null) {
                boolean overwrite = GuiBase.isShiftDown();
                String fileNameTmp = fileName;
                if (!fileNameTmp.endsWith(".litematic")) {
                    fileNameTmp = fileNameTmp + ".litematic";
                }
                if (!FileUtils.canWriteToFile((File)dir, (String)fileNameTmp, (boolean)overwrite)) {
                    this.addMessage(Message.MessageType.ERROR, "litematica.error.schematic_write_to_file_failed.exists", new Object[]{fileNameTmp});
                    return;
                }
                String author = this.field_146297_k.field_71439_g.func_70005_c_();
                boolean takeEntities = !this.checkboxIgnoreEntities.isChecked();
                LitematicaSchematic schematic = LitematicaSchematic.createEmptySchematic(area, author);
                TaskSaveSchematic task = new TaskSaveSchematic(dir, fileName, schematic, area, takeEntities, overwrite);
                task.setCompletionListener(this);
                TaskScheduler.getServerInstanceIfExistsOrClient().scheduleTask(task, 10);
                this.addMessage(Message.MessageType.INFO, "litematica.message.schematic_save_task_created", new Object[0]);
            } else {
                this.addMessage(Message.MessageType.ERROR, "litematica.message.error.schematic_save_no_area_selected", new Object[0]);
            }
        }
    }

    public static class InMemorySchematicCreator
    implements IStringConsumer {
        private final AreaSelection area;
        private final Minecraft mc;

        public InMemorySchematicCreator(AreaSelection area) {
            this.area = area;
            this.mc = Minecraft.func_71410_x();
        }

        public void setString(String string) {
            boolean takeEntities = true;
            String author = this.mc.field_71439_g.func_70005_c_();
            LitematicaSchematic schematic = LitematicaSchematic.createEmptySchematic(this.area, author);
            if (schematic != null) {
                schematic.getMetadata().setName(string);
                TaskSaveSchematic task = new TaskSaveSchematic(schematic, this.area, takeEntities);
                TaskScheduler.getServerInstanceIfExistsOrClient().scheduleTask(task, 10);
            }
        }
    }
}

