/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.gui;

import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.data.SchematicHolder;
import fi.dy.masa.litematica.gui.GuiMainMenu;
import fi.dy.masa.litematica.gui.GuiSchematicBrowserBase;
import fi.dy.masa.litematica.gui.GuiSchematicSaveExported;
import fi.dy.masa.litematica.gui.GuiSchematicSaveImported;
import fi.dy.masa.litematica.gui.widgets.WidgetSchematicBrowser;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.util.FileType;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.config.options.IConfigOptionList;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiConfirmAction;
import fi.dy.masa.malilib.gui.GuiTextInputFeedback;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.ConfigButtonOptionList;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.interfaces.ISelectionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetFileBrowserBase;
import fi.dy.masa.malilib.interfaces.IConfirmationListener;
import fi.dy.masa.malilib.interfaces.IStringConsumerFeedback;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.ScreenShotHelper;

public class GuiSchematicManager
extends GuiSchematicBrowserBase
implements ISelectionListener<WidgetFileBrowserBase.DirectoryEntry> {
    private static PreviewGenerator previewGenerator;
    private ExportType exportType = ExportType.SCHEMATIC;

    public GuiSchematicManager() {
        super(10, 24);
        this.title = StringUtils.translate((String)"litematica.gui.title.schematic_manager", (Object[])new Object[0]);
    }

    @Override
    public String getBrowserContext() {
        return "schematic_manager";
    }

    @Override
    public File getDefaultDirectory() {
        return DataManager.getSchematicsBaseDirectory();
    }

    @Override
    protected int getBrowserHeight() {
        if (this.field_146294_l < 520) {
            return this.field_146295_m - 78;
        }
        return this.field_146295_m - 56;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.createButtons();
    }

    private void createButtons() {
        Enum type;
        int x = 10;
        int y = this.field_146295_m - 26;
        WidgetFileBrowserBase.DirectoryEntry selected = (WidgetFileBrowserBase.DirectoryEntry)((WidgetSchematicBrowser)this.getListWidget()).getLastSelectedEntry();
        if (selected != null) {
            type = FileType.fromFile(selected.getFullPath());
            if (type == FileType.LITEMATICA_SCHEMATIC) {
                if (this.field_146294_l < 520) {
                    y -= 22;
                }
                x = this.createButton(x, y, ButtonListener.Type.RENAME_SCHEMATIC);
                x = this.createButton(x, y, ButtonListener.Type.RENAME_FILE);
                x = this.createButton(x, y, ButtonListener.Type.DELETE_SCHEMATIC);
                if (this.field_146294_l < 520) {
                    x = 10;
                    y += 22;
                }
                x = this.createButton(x, y, ButtonListener.Type.EXPORT_SCHEMATIC);
                x = this.createButton(x, y, ButtonListener.Type.EXPORT_TYPE);
                x = this.createButton(x, y, ButtonListener.Type.SET_PREVIEW);
            } else if (type == FileType.SCHEMATICA_SCHEMATIC || type == FileType.VANILLA_STRUCTURE) {
                x = this.createButton(x, y, ButtonListener.Type.RENAME_FILE);
                x = this.createButton(x, y, ButtonListener.Type.IMPORT_SCHEMATIC);
                x = this.createButton(x, y, ButtonListener.Type.DELETE_SCHEMATIC);
            }
        }
        type = GuiMainMenu.ButtonListenerChangeMenu.ButtonType.MAIN_MENU;
        String label = StringUtils.translate((String)((GuiMainMenu.ButtonListenerChangeMenu.ButtonType)type).getLabelKey(), (Object[])new Object[0]);
        int buttonWidth = this.getStringWidth(label) + 20;
        this.addButton((ButtonBase)new ButtonGeneric(this.field_146294_l - buttonWidth - 10, y, buttonWidth, 20, label, new String[0]), new GuiMainMenu.ButtonListenerChangeMenu((GuiMainMenu.ButtonListenerChangeMenu.ButtonType)type, null));
    }

    public void onSelectionChange(@Nullable WidgetFileBrowserBase.DirectoryEntry entry) {
        this.clearButtons();
        this.createButtons();
    }

    private int createButton(int x, int y, ButtonListener.Type type) {
        ButtonGeneric button;
        String label = type.getLabel();
        String hover = type.getHoverText();
        int buttonWidth = this.getStringWidth(label) + 10;
        if (type == ButtonListener.Type.EXPORT_TYPE) {
            buttonWidth = this.getStringWidth(this.exportType.getDisplayName()) + 10;
            button = new ConfigButtonOptionList(x, y, buttonWidth, 20, (IConfigOptionList)new ConfigWrapper());
        } else {
            button = new ButtonGeneric(x, y, buttonWidth, 20, label, new String[0]);
        }
        if (hover != null) {
            button.setHoverStrings(new String[]{hover});
        }
        this.addButton((ButtonBase)button, new ButtonListener(type, this));
        return x + buttonWidth + 2;
    }

    @Override
    protected ISelectionListener<WidgetFileBrowserBase.DirectoryEntry> getSelectionListener() {
        return this;
    }

    public static boolean setPreviewImage() {
        if (previewGenerator != null) {
            previewGenerator.createAndSetPreviewImage();
            previewGenerator = null;
            return true;
        }
        return false;
    }

    public static boolean hasPendingPreviewTask() {
        return previewGenerator != null;
    }

    public static enum ExportType implements IConfigOptionListEntry
    {
        SCHEMATIC("Schematic"),
        VANILLA("Vanilla Structure");

        private final String displayName;

        private ExportType(String displayName) {
            this.displayName = displayName;
        }

        public String getStringValue() {
            return this.name().toLowerCase();
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public IConfigOptionListEntry cycle(boolean forward) {
            int id = this.ordinal();
            if (forward) {
                if (++id >= ExportType.values().length) {
                    id = 0;
                }
            } else if (--id < 0) {
                id = ExportType.values().length - 1;
            }
            return ExportType.values()[id % ExportType.values().length];
        }

        public ExportType fromString(String name) {
            return ExportType.fromStringStatic(name);
        }

        public static ExportType fromStringStatic(String name) {
            for (ExportType al : ExportType.values()) {
                if (!al.name().equalsIgnoreCase(name)) continue;
                return al;
            }
            return SCHEMATIC;
        }
    }

    public static class PreviewGenerator {
        private final File dir;
        private final String fileName;

        public PreviewGenerator(File dir, String fileName) {
            this.dir = dir;
            this.fileName = fileName;
        }

        public void createAndSetPreviewImage() {
            LitematicaSchematic schematic = LitematicaSchematic.createFromFile(this.dir, this.fileName);
            if (schematic != null) {
                try {
                    Minecraft mc = Minecraft.func_71410_x();
                    BufferedImage screenshot = ScreenShotHelper.func_186719_a((int)mc.field_71443_c, (int)mc.field_71440_d, (Framebuffer)mc.func_147110_a());
                    int x = screenshot.getWidth() >= screenshot.getHeight() ? (screenshot.getWidth() - screenshot.getHeight()) / 2 : 0;
                    int y = screenshot.getHeight() >= screenshot.getWidth() ? (screenshot.getHeight() - screenshot.getWidth()) / 2 : 0;
                    int longerSide = Math.min(screenshot.getWidth(), screenshot.getHeight());
                    int previewDimensions = 140;
                    double scaleFactor = (double)previewDimensions / (double)longerSide;
                    BufferedImage scaled = new BufferedImage(previewDimensions, previewDimensions, 2);
                    AffineTransform at = new AffineTransform();
                    at.scale(scaleFactor, scaleFactor);
                    AffineTransformOp scaleOp = new AffineTransformOp(at, 3);
                    Graphics2D graphics = scaled.createGraphics();
                    graphics.drawImage(screenshot.getSubimage(x, y, longerSide, longerSide), scaleOp, 0, 0);
                    int[] pixels = scaled.getRGB(0, 0, previewDimensions, previewDimensions, null, 0, scaled.getWidth());
                    schematic.getMetadata().setPreviewImagePixelData(pixels);
                    schematic.getMetadata().setTimeModifiedToNow();
                    schematic.writeToFile(this.dir, this.fileName, true);
                    InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.SUCCESS, (String)"litematica.info.schematic_manager.preview.success", (Object[])new Object[0]);
                }
                catch (Exception e) {
                    Litematica.logger.warn("Exception while creating preview image", (Throwable)e);
                }
            } else {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.schematic_rename.read_failed", (Object[])new Object[0]);
            }
        }
    }

    public static class FileDeleter
    implements IConfirmationListener {
        protected final File file;

        public FileDeleter(File file) {
            this.file = file;
        }

        public boolean onActionCancelled() {
            return false;
        }

        public boolean onActionConfirmed() {
            try {
                this.file.delete();
                return true;
            }
            catch (Exception e) {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.generic.failed_to_delete_file", (Object[])new Object[]{this.file.getAbsolutePath()});
                return false;
            }
        }
    }

    public static class FileRenamer
    implements IStringConsumerFeedback {
        private final File dir;
        private final String oldName;
        private final String fileName;
        private final GuiBase gui;

        public FileRenamer(File dir, String fileName, String oldName, GuiBase gui) {
            this.dir = dir;
            this.fileName = fileName;
            this.oldName = oldName;
            this.gui = gui;
        }

        public boolean setString(String string) {
            if (FileUtils.doesFilenameContainIllegalCharacters((String)string)) {
                this.gui.addMessage(Message.MessageType.ERROR, "litematica.error.illegal_characters_in_file_name", new Object[]{string});
                return false;
            }
            File oldFile = new File(this.dir, this.fileName);
            int indexExt = this.oldName.lastIndexOf(46);
            String newName = indexExt > 0 ? string + this.oldName.substring(indexExt) : string;
            File newFile = new File(this.dir, newName);
            if (!newFile.exists()) {
                if (oldFile.exists() && oldFile.canRead() && oldFile.renameTo(newFile)) {
                    return true;
                }
                this.gui.addMessage(Message.MessageType.ERROR, "litematica.error.schematic_file_rename.read_failed", new Object[]{this.fileName});
            } else {
                this.gui.addMessage(Message.MessageType.ERROR, "litematica.error.schematic_save.file_already_exists", new Object[]{newName});
            }
            return false;
        }
    }

    private static class SchematicRenamer
    implements IStringConsumerFeedback {
        private final File dir;
        private final String fileName;
        private final LitematicaSchematic schematic;
        private final GuiSchematicManager gui;

        public SchematicRenamer(File dir, String fileName, LitematicaSchematic schematic, GuiSchematicManager gui) {
            this.dir = dir;
            this.fileName = fileName;
            this.schematic = schematic;
            this.gui = gui;
        }

        public boolean setString(String string) {
            if (this.schematic != null) {
                String oldName = this.schematic.getMetadata().getName();
                long currentTime = System.currentTimeMillis();
                this.schematic.getMetadata().setName(string);
                this.schematic.getMetadata().setTimeModified(currentTime);
                if (this.schematic.writeToFile(this.dir, this.fileName, true)) {
                    List<LitematicaSchematic> list = SchematicHolder.getInstance().getAllOf(new File(this.dir, this.fileName));
                    for (LitematicaSchematic schematic : list) {
                        schematic.getMetadata().setName(string);
                        schematic.getMetadata().setTimeModified(currentTime);
                        for (SchematicPlacement placement : DataManager.getSchematicPlacementManager().getAllPlacementsOfSchematic(schematic)) {
                            if (!placement.getName().equals(oldName)) continue;
                            placement.setName(string);
                        }
                    }
                    ((WidgetSchematicBrowser)this.gui.getListWidget()).clearSchematicMetadataCache();
                    return true;
                }
            } else {
                this.gui.addMessage(Message.MessageType.ERROR, "litematica.error.schematic_rename.read_failed", new Object[]{this.fileName});
            }
            return false;
        }
    }

    private static class ButtonListener
    implements IButtonActionListener {
        private final Type type;
        private final GuiSchematicManager gui;

        public ButtonListener(Type type, GuiSchematicManager gui) {
            this.type = type;
            this.gui = gui;
        }

        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            if (this.type == Type.SET_PREVIEW && mouseButton == 1) {
                if (previewGenerator != null) {
                    previewGenerator = null;
                    this.gui.addMessage(Message.MessageType.SUCCESS, "litematica.message.schematic_preview_cancelled", new Object[0]);
                }
                return;
            }
            WidgetFileBrowserBase.DirectoryEntry entry = (WidgetFileBrowserBase.DirectoryEntry)((WidgetSchematicBrowser)this.gui.getListWidget()).getLastSelectedEntry();
            if (entry == null) {
                this.gui.addMessage(Message.MessageType.ERROR, "litematica.error.schematic_load.no_schematic_selected", new Object[0]);
                return;
            }
            File file = entry.getFullPath();
            if (!(file.exists() && file.isFile() && file.canRead())) {
                this.gui.addMessage(Message.MessageType.ERROR, "litematica.error.schematic_load.cant_read_file", new Object[]{file.getName()});
                return;
            }
            FileType fileType = FileType.fromFile(entry.getFullPath());
            if (this.type == Type.EXPORT_SCHEMATIC) {
                if (fileType == FileType.LITEMATICA_SCHEMATIC) {
                    GuiSchematicSaveExported gui = new GuiSchematicSaveExported(entry.getType(), entry.getDirectory(), entry.getName(), this.gui.exportType);
                    gui.setParent((GuiScreen)this.gui);
                    GuiBase.openGui((GuiScreen)gui);
                } else {
                    this.gui.addMessage(Message.MessageType.ERROR, "litematica.error.schematic_manager.schematic_export.unsupported_type", new Object[]{file.getName()});
                }
            } else if (this.type == Type.IMPORT_SCHEMATIC) {
                if (fileType == FileType.SCHEMATICA_SCHEMATIC || fileType == FileType.VANILLA_STRUCTURE) {
                    GuiSchematicSaveImported gui = new GuiSchematicSaveImported(entry.getType(), entry.getDirectory(), entry.getName());
                    gui.setParent((GuiScreen)this.gui);
                    GuiBase.openGui((GuiScreen)gui);
                } else {
                    this.gui.addMessage(Message.MessageType.ERROR, "litematica.error.schematic_manager.schematic_import.unsupported_type", new Object[]{file.getName()});
                }
            } else if (this.type == Type.RENAME_SCHEMATIC) {
                LitematicaSchematic schematic = LitematicaSchematic.createFromFile(entry.getDirectory(), entry.getName());
                String oldName = schematic != null ? schematic.getMetadata().getName() : "";
                GuiBase.openGui((GuiScreen)new GuiTextInputFeedback(256, "litematica.gui.title.rename_schematic", oldName, (GuiScreen)this.gui, (IStringConsumerFeedback)new SchematicRenamer(entry.getDirectory(), entry.getName(), schematic, this.gui)));
            } else if (this.type == Type.RENAME_FILE) {
                String oldName = FileUtils.getNameWithoutExtension((String)entry.getName());
                GuiBase.openGui((GuiScreen)new GuiTextInputFeedback(256, "litematica.gui.title.rename_file", oldName, (GuiScreen)this.gui, (IStringConsumerFeedback)new FileRenamer(entry.getDirectory(), entry.getName(), entry.getName(), (GuiBase)this.gui)));
            } else if (this.type == Type.DELETE_SCHEMATIC) {
                FileDeleter deleter = new FileDeleter(entry.getFullPath());
                GuiBase.openGui((GuiScreen)new GuiConfirmAction(400, "litematica.gui.title.confirm_file_deletion", (IConfirmationListener)deleter, (GuiScreen)this.gui, "litematica.gui.message.confirm_file_deletion", new Object[]{entry.getName()}));
            } else if (this.type == Type.SET_PREVIEW) {
                previewGenerator = new PreviewGenerator(entry.getDirectory(), entry.getName());
                GuiBase.openGui(null);
                InfoUtils.showGuiAndInGameMessage((Message.MessageType)Message.MessageType.INFO, (String)"litematica.info.schematic_manager.preview.set_preview_by_taking_a_screenshot", (Object[])new Object[0]);
            }
        }

        public static enum Type {
            IMPORT_SCHEMATIC("litematica.gui.button.import"),
            EXPORT_SCHEMATIC("litematica.gui.button.schematic_manager.export_as"),
            RENAME_SCHEMATIC("litematica.gui.button.rename_schematic"),
            RENAME_FILE("litematica.gui.button.rename_file"),
            DELETE_SCHEMATIC("litematica.gui.button.delete"),
            SET_PREVIEW("litematica.gui.button.set_preview", "litematica.info.schematic_manager.preview.right_click_to_cancel"),
            EXPORT_TYPE("");

            private final String label;
            @Nullable
            private final String hoverText;

            private Type(String label) {
                this(label, null);
            }

            private Type(String label, String hoverText) {
                this.label = label;
                this.hoverText = hoverText;
            }

            public String getLabel() {
                return StringUtils.translate((String)this.label, (Object[])new Object[0]);
            }

            @Nullable
            public String getHoverText() {
                return this.hoverText != null ? StringUtils.translate((String)this.hoverText, (Object[])new Object[0]) : null;
            }
        }
    }

    private class ConfigWrapper
    implements IConfigOptionList {
        private ConfigWrapper() {
        }

        public IConfigOptionListEntry getOptionListValue() {
            return GuiSchematicManager.this.exportType;
        }

        public IConfigOptionListEntry getDefaultOptionListValue() {
            return ExportType.SCHEMATIC;
        }

        public void setOptionListValue(IConfigOptionListEntry value) {
            GuiSchematicManager.this.exportType = (ExportType)value;
            GuiSchematicManager.this.clearButtons();
            GuiSchematicManager.this.createButtons();
        }
    }
}

