/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.event;

import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.event.InputHandler;
import fi.dy.masa.litematica.gui.GuiAreaSelectionManager;
import fi.dy.masa.litematica.gui.GuiConfigs;
import fi.dy.masa.litematica.gui.GuiMainMenu;
import fi.dy.masa.litematica.gui.GuiMaterialList;
import fi.dy.masa.litematica.gui.GuiPlacementConfiguration;
import fi.dy.masa.litematica.gui.GuiSchematicLoad;
import fi.dy.masa.litematica.gui.GuiSchematicLoadedList;
import fi.dy.masa.litematica.gui.GuiSchematicPlacementsList;
import fi.dy.masa.litematica.gui.GuiSchematicVerifier;
import fi.dy.masa.litematica.gui.GuiSubRegionConfiguration;
import fi.dy.masa.litematica.materials.MaterialListBase;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SubRegionPlacement;
import fi.dy.masa.litematica.selection.AreaSelection;
import fi.dy.masa.litematica.selection.CornerSelectionMode;
import fi.dy.masa.litematica.selection.SelectionManager;
import fi.dy.masa.litematica.tool.ToolMode;
import fi.dy.masa.litematica.tool.ToolModeData;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.InventoryUtils;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.util.RayTraceUtils;
import fi.dy.masa.litematica.util.SchematicUtils;
import fi.dy.masa.litematica.util.SchematicWorldRefresher;
import fi.dy.masa.litematica.util.ToolUtils;
import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.malilib.config.options.IConfigBoolean;
import fi.dy.masa.malilib.config.values.LayerMode;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.hotkeys.IHotkeyCallback;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.KeyAction;
import fi.dy.masa.malilib.hotkeys.KeyCallbackToggleBooleanConfigWithMessage;
import fi.dy.masa.malilib.hotkeys.KeybindMulti;
import fi.dy.masa.malilib.util.InfoUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class KeyCallbacks {
    public static void init(Minecraft mc) {
        KeyCallbackHotkeys callbackHotkeys = new KeyCallbackHotkeys(mc);
        KeyCallbackToggleMessage callbackMessage = new KeyCallbackToggleMessage(mc);
        Configs.Generic.PICK_BLOCKABLE_SLOTS.setValueChangeCallback(config -> InventoryUtils.setPickBlockableSlots(config.getStringValue()));
        Configs.Generic.TOOL_ITEM.setValueChangeCallback(config -> DataManager.setToolItem(config.getStringValue()));
        Hotkeys.CLONE_SELECTION.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.EXECUTE_OPERATION.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.LAYER_MODE_NEXT.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.LAYER_MODE_PREVIOUS.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.LAYER_NEXT.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.LAYER_PREVIOUS.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.LAYER_SET_HERE.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.NUDGE_SELECTION_NEGATIVE.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.NUDGE_SELECTION_POSITIVE.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.OPEN_GUI_AREA_SETTINGS.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.OPEN_GUI_LOAD_SCHEMATICS.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.OPEN_GUI_LOADED_SCHEMATICS.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.OPEN_GUI_MAIN_MENU.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.OPEN_GUI_MATERIAL_LIST.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.OPEN_GUI_PLACEMENT_SETTINGS.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.OPEN_GUI_SCHEMATIC_PLACEMENTS.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.OPEN_GUI_SCHEMATIC_PROJECTS.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.OPEN_GUI_SCHEMATIC_VERIFIER.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.OPEN_GUI_SELECTION_MANAGER.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.OPEN_GUI_SETTINGS.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.PICK_BLOCK_FIRST.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.PICK_BLOCK_LAST.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.PICK_BLOCK_TOGGLE.getKeybind().setCallback((IHotkeyCallback)new KeyCallbackToggleBooleanConfigWithMessage((IConfigBoolean)Configs.Generic.PICK_BLOCK_ENABLED));
        Hotkeys.RERENDER_SCHEMATIC.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.ROTATE_PLACEMENT_CW.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.ROTATE_PLACEMENT_CCW.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.SAVE_AREA_AS_IN_MEMORY_SCHEMATIC.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.SAVE_AREA_AS_SCHEMATIC_TO_FILE.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.SCHEMATIC_VERSION_CYCLE_NEXT.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.SCHEMATIC_VERSION_CYCLE_PREVIOUS.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.SELECTION_GROW_HOTKEY.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.SELECTION_SHRINK_HOTKEY.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.TOOL_MODE_CYCLE_FORWARD.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.TOOL_MODE_CYCLE_BACKWARD.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.TOOL_PLACE_CORNER_1.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.TOOL_PLACE_CORNER_2.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.TOOL_SELECT_ELEMENTS.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.TOOL_SELECT_MODIFIER_BLOCK_1.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.TOOL_SELECT_MODIFIER_BLOCK_2.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.UNLOAD_CURRENT_SCHEMATIC.getKeybind().setCallback((IHotkeyCallback)callbackHotkeys);
        Hotkeys.ADD_SELECTION_BOX.getKeybind().setCallback((IHotkeyCallback)callbackMessage);
        Hotkeys.DELETE_SELECTION_BOX.getKeybind().setCallback((IHotkeyCallback)callbackMessage);
        Hotkeys.EASY_PLACE_TOGGLE.getKeybind().setCallback((IHotkeyCallback)new KeyCallbackToggleBooleanConfigWithMessage((IConfigBoolean)Configs.Generic.EASY_PLACE_MODE));
        Hotkeys.MOVE_ENTIRE_SELECTION.getKeybind().setCallback((IHotkeyCallback)callbackMessage);
        Hotkeys.SELECTION_MODE_CYCLE.getKeybind().setCallback((IHotkeyCallback)callbackMessage);
        Hotkeys.SET_AREA_ORIGIN.getKeybind().setCallback((IHotkeyCallback)callbackMessage);
        Hotkeys.SET_SELECTION_BOX_POSITION_1.getKeybind().setCallback((IHotkeyCallback)callbackMessage);
        Hotkeys.SET_SELECTION_BOX_POSITION_2.getKeybind().setCallback((IHotkeyCallback)callbackMessage);
        Hotkeys.TOGGLE_ALL_RENDERING.getKeybind().setCallback((IHotkeyCallback)new RenderToggle((IConfigBoolean)Configs.Visuals.ENABLE_RENDERING));
        Hotkeys.TOGGLE_AREA_SELECTION_RENDERING.getKeybind().setCallback((IHotkeyCallback)new KeyCallbackToggleBooleanConfigWithMessage((IConfigBoolean)Configs.Visuals.ENABLE_AREA_SELECTION_RENDERING));
        Hotkeys.TOGGLE_SCHEMATIC_RENDERING.getKeybind().setCallback((IHotkeyCallback)new RenderToggle((IConfigBoolean)Configs.Visuals.ENABLE_SCHEMATIC_RENDERING));
        Hotkeys.TOGGLE_INFO_OVERLAY_RENDERING.getKeybind().setCallback((IHotkeyCallback)new KeyCallbackToggleBooleanConfigWithMessage((IConfigBoolean)Configs.InfoOverlays.BLOCK_INFO_OVERLAY_ENABLED));
        Hotkeys.TOGGLE_OVERLAY_RENDERING.getKeybind().setCallback((IHotkeyCallback)new RenderToggle((IConfigBoolean)Configs.Visuals.ENABLE_SCHEMATIC_OVERLAY));
        Hotkeys.TOGGLE_OVERLAY_OUTLINE_RENDERING.getKeybind().setCallback((IHotkeyCallback)new RenderToggle((IConfigBoolean)Configs.Visuals.SCHEMATIC_OVERLAY_ENABLE_OUTLINES));
        Hotkeys.TOGGLE_OVERLAY_SIDE_RENDERING.getKeybind().setCallback((IHotkeyCallback)new RenderToggle((IConfigBoolean)Configs.Visuals.SCHEMATIC_OVERLAY_ENABLE_SIDES));
        Hotkeys.TOGGLE_PLACEMENT_RESTRICTION.getKeybind().setCallback((IHotkeyCallback)new KeyCallbackToggleBooleanConfigWithMessage((IConfigBoolean)Configs.Generic.PLACEMENT_RESTRICTION));
        Hotkeys.TOGGLE_PLACEMENT_BOXES_RENDERING.getKeybind().setCallback((IHotkeyCallback)new KeyCallbackToggleBooleanConfigWithMessage((IConfigBoolean)Configs.Visuals.ENABLE_PLACEMENT_BOXES_RENDERING));
        Hotkeys.TOGGLE_SCHEMATIC_BLOCK_RENDERING.getKeybind().setCallback((IHotkeyCallback)new KeyCallbackToggleBooleanConfigWithMessage((IConfigBoolean)Configs.Visuals.ENABLE_SCHEMATIC_BLOCKS));
        Hotkeys.TOGGLE_SIGN_TEXT_PASTE.getKeybind().setCallback((IHotkeyCallback)new KeyCallbackToggleBooleanConfigWithMessage((IConfigBoolean)Configs.Generic.SIGN_TEXT_PASTE));
        Hotkeys.TOGGLE_TRANSLUCENT_RENDERING.getKeybind().setCallback((IHotkeyCallback)new RenderToggle((IConfigBoolean)Configs.Visuals.RENDER_BLOCKS_AS_TRANSLUCENT));
        Hotkeys.TOGGLE_VERIFIER_OVERLAY_RENDERING.getKeybind().setCallback((IHotkeyCallback)new KeyCallbackToggleBooleanConfigWithMessage((IConfigBoolean)Configs.InfoOverlays.VERIFIER_OVERLAY_ENABLED));
        Hotkeys.TOOL_ENABLED_TOGGLE.getKeybind().setCallback((IHotkeyCallback)new KeyCallbackToggleBooleanConfigWithMessage((IConfigBoolean)Configs.Generic.TOOL_ITEM_ENABLED));
    }

    private static class KeyCallbackToggleMessage
    implements IHotkeyCallback {
        private final Minecraft mc;

        public KeyCallbackToggleMessage(Minecraft mc) {
            this.mc = mc;
        }

        public boolean onKeyAction(KeyAction action, IKeybind key) {
            ToolMode mode = DataManager.getToolMode();
            if (key == Hotkeys.ADD_SELECTION_BOX.getKeybind()) {
                if (mode.getUsesAreaSelection()) {
                    return DataManager.getSelectionManager().createNewSubRegion(this.mc, true);
                }
            } else if (key == Hotkeys.DELETE_SELECTION_BOX.getKeybind()) {
                SelectionManager sm;
                AreaSelection selection;
                if (mode.getUsesAreaSelection() && (selection = (sm = DataManager.getSelectionManager()).getCurrentSelection()) != null) {
                    if (selection.isOriginSelected()) {
                        selection.setExplicitOrigin(null);
                        selection.setOriginSelected(false);
                        InfoUtils.printActionbarMessage((String)"litematica.message.removed_area_origin", (Object[])new Object[0]);
                    } else {
                        String name = selection.getCurrentSubRegionBoxName();
                        if (name != null && selection.removeSelectedSubRegionBox()) {
                            InfoUtils.printActionbarMessage((String)"litematica.message.removed_selection_box", (Object[])new Object[]{name});
                            return true;
                        }
                    }
                }
            } else if (key == Hotkeys.MOVE_ENTIRE_SELECTION.getKeybind()) {
                if (mode.getUsesAreaSelection()) {
                    SelectionManager sm = DataManager.getSelectionManager();
                    AreaSelection selection = sm.getCurrentSelection();
                    if (selection != null) {
                        BlockPos pos = new BlockPos(this.mc.field_71439_g.func_174791_d());
                        if (mode == ToolMode.MOVE) {
                            SchematicUtils.moveCurrentlySelectedWorldRegionTo(pos, this.mc);
                        } else {
                            selection.moveEntireSelectionTo(pos, true);
                        }
                        return true;
                    }
                } else if (mode.getUsesSchematic()) {
                    BlockPos pos = new BlockPos(this.mc.field_71439_g.func_174791_d());
                    DataManager.getSchematicPlacementManager().setPositionOfCurrentSelectionTo(pos, this.mc);
                    return true;
                }
            } else {
                SelectionManager sm;
                AreaSelection area;
                if (key == Hotkeys.SELECTION_MODE_CYCLE.getKeybind()) {
                    if (mode == ToolMode.DELETE) {
                        ToolModeData.DELETE.toggleUsePlacement();
                    } else if (mode == ToolMode.PASTE_SCHEMATIC) {
                        Configs.Generic.PASTE_REPLACE_BEHAVIOR.setOptionListValue(Configs.Generic.PASTE_REPLACE_BEHAVIOR.getOptionListValue().cycle(false));
                    } else if (mode.getUsesAreaSelection()) {
                        Configs.Generic.SELECTION_CORNERS_MODE.setOptionListValue(Configs.Generic.SELECTION_CORNERS_MODE.getOptionListValue().cycle(false));
                    }
                    return true;
                }
                if (key == Hotkeys.SET_AREA_ORIGIN.getKeybind()) {
                    SelectionManager sm2;
                    AreaSelection area2;
                    if (mode.getUsesAreaSelection() && (area2 = (sm2 = DataManager.getSelectionManager()).getCurrentSelection()) != null) {
                        BlockPos pos = new BlockPos(this.mc.field_71439_g.func_174791_d());
                        area2.setExplicitOrigin(pos);
                        String posStr = String.format("x: %d, y: %d, z: %d", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                        InfoUtils.printActionbarMessage((String)"litematica.message.set_area_origin", (Object[])new Object[]{posStr});
                        return true;
                    }
                } else if ((key == Hotkeys.SET_SELECTION_BOX_POSITION_1.getKeybind() || key == Hotkeys.SET_SELECTION_BOX_POSITION_2.getKeybind()) && mode.getUsesAreaSelection() && (area = (sm = DataManager.getSelectionManager()).getCurrentSelection()) != null && area.getSelectedSubRegionBox() != null) {
                    BlockPos pos = new BlockPos(this.mc.field_71439_g.func_174791_d());
                    PositionUtils.Corner corner = key == Hotkeys.SET_SELECTION_BOX_POSITION_1.getKeybind() ? PositionUtils.Corner.CORNER_1 : PositionUtils.Corner.CORNER_2;
                    area.setSelectedSubRegionCornerPos(pos, corner);
                    if (Configs.Generic.CHANGE_SELECTED_CORNER.getBooleanValue()) {
                        area.getSelectedSubRegionBox().setSelectedCorner(corner);
                    }
                    String posStr = String.format("x: %d, y: %d, z: %d", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    InfoUtils.printActionbarMessage((String)"litematica.message.set_selection_box_point", (Object[])new Object[]{corner.ordinal(), posStr});
                    return true;
                }
            }
            return false;
        }
    }

    private static class KeyCallbackHotkeys
    implements IHotkeyCallback {
        private final Minecraft mc;

        public KeyCallbackHotkeys(Minecraft mc) {
            this.mc = mc;
        }

        public boolean onKeyAction(KeyAction action, IKeybind key) {
            boolean isToolSelect;
            if (this.mc.field_71439_g == null || this.mc.field_71441_e == null) {
                return false;
            }
            ToolMode mode = DataManager.getToolMode();
            boolean toolEnabled = Configs.Visuals.ENABLE_RENDERING.getBooleanValue() && Configs.Generic.TOOL_ITEM_ENABLED.getBooleanValue();
            boolean hasTool = EntityUtils.hasToolItem((EntityLivingBase)this.mc.field_71439_g);
            boolean isToolPrimary = key == Hotkeys.TOOL_PLACE_CORNER_1.getKeybind();
            boolean isToolSecondary = key == Hotkeys.TOOL_PLACE_CORNER_2.getKeybind();
            boolean bl = isToolSelect = key == Hotkeys.TOOL_SELECT_ELEMENTS.getKeybind();
            if (toolEnabled && isToolSelect) {
                if (mode.getUsesBlockPrimary() && Hotkeys.TOOL_SELECT_MODIFIER_BLOCK_1.getKeybind().isKeybindHeld()) {
                    WorldUtils.setToolModeBlockState(mode, true, this.mc);
                    return true;
                }
                if (mode.getUsesBlockSecondary() && Hotkeys.TOOL_SELECT_MODIFIER_BLOCK_2.getKeybind().isKeybindHeld()) {
                    WorldUtils.setToolModeBlockState(mode, false, this.mc);
                    return true;
                }
            }
            if (toolEnabled && hasTool) {
                int maxDistance = 200;
                boolean projectMode = DataManager.getSchematicProjectsManager().hasProjectOpen();
                if (isToolPrimary || isToolSecondary) {
                    if (mode.getUsesAreaSelection() || projectMode) {
                        boolean grabModifier;
                        SelectionManager sm = DataManager.getSelectionManager();
                        boolean moveEverything = grabModifier = Hotkeys.SELECTION_GRAB_MODIFIER.getKeybind().isKeybindHeld();
                        if (grabModifier && mode == ToolMode.MOVE) {
                            BlockPos pos = RayTraceUtils.getTargetedPosition((World)this.mc.field_71441_e, (EntityPlayer)this.mc.field_71439_g, maxDistance, false);
                            if (pos != null) {
                                SchematicUtils.moveCurrentlySelectedWorldRegionTo(pos, this.mc);
                            }
                        } else if (Configs.Generic.SELECTION_CORNERS_MODE.getOptionListValue() == CornerSelectionMode.CORNERS) {
                            PositionUtils.Corner corner = isToolPrimary ? PositionUtils.Corner.CORNER_1 : PositionUtils.Corner.CORNER_2;
                            sm.setPositionOfCurrentSelectionToRayTrace(this.mc, corner, moveEverything, maxDistance);
                        } else if (Configs.Generic.SELECTION_CORNERS_MODE.getOptionListValue() == CornerSelectionMode.EXPAND) {
                            sm.handleCuboidModeMouseClick(this.mc, maxDistance, isToolSecondary, moveEverything);
                        }
                    } else if (mode.getUsesSchematic()) {
                        DataManager.getSchematicPlacementManager().setPositionOfCurrentSelectionToRayTrace(this.mc, maxDistance);
                    }
                    return true;
                }
                if (isToolSelect) {
                    if (mode.getUsesAreaSelection() || projectMode) {
                        SelectionManager sm = DataManager.getSelectionManager();
                        if (Hotkeys.SELECTION_GRAB_MODIFIER.getKeybind().isKeybindHeld()) {
                            if (sm.hasGrabbedElement()) {
                                sm.releaseGrabbedElement();
                            } else {
                                sm.grabElement(this.mc, maxDistance);
                            }
                        } else {
                            sm.changeSelection((World)this.mc.field_71441_e, (Entity)this.mc.field_71439_g, maxDistance);
                        }
                    } else if (mode.getUsesSchematic()) {
                        DataManager.getSchematicPlacementManager().changeSelection((World)this.mc.field_71441_e, (Entity)this.mc.field_71439_g, maxDistance);
                    }
                    return true;
                }
            }
            if (key == Hotkeys.OPEN_GUI_MAIN_MENU.getKeybind()) {
                GuiBase.openGui((GuiScreen)new GuiMainMenu());
                return true;
            }
            if (key == Hotkeys.OPEN_GUI_LOAD_SCHEMATICS.getKeybind()) {
                GuiBase.openGui((GuiScreen)new GuiSchematicLoad());
                return true;
            }
            if (key == Hotkeys.OPEN_GUI_LOADED_SCHEMATICS.getKeybind()) {
                GuiBase.openGui((GuiScreen)new GuiSchematicLoadedList());
                return true;
            }
            if (key == Hotkeys.OPEN_GUI_SELECTION_MANAGER.getKeybind()) {
                if (!DataManager.getSchematicProjectsManager().hasProjectOpen()) {
                    GuiBase.openGui((GuiScreen)new GuiAreaSelectionManager());
                } else {
                    InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.WARNING, (String)"litematica.gui.button.hover.schematic_projects.area_browser_disabled_currently_in_projects_mode", (Object[])new Object[0]);
                }
                return true;
            }
            if (key == Hotkeys.OPEN_GUI_SCHEMATIC_PLACEMENTS.getKeybind()) {
                GuiBase.openGui((GuiScreen)new GuiSchematicPlacementsList());
                return true;
            }
            if (key == Hotkeys.OPEN_GUI_SCHEMATIC_PROJECTS.getKeybind()) {
                DataManager.getSchematicProjectsManager().openSchematicProjectsGui();
                return true;
            }
            if (key == Hotkeys.OPEN_GUI_SETTINGS.getKeybind()) {
                GuiBase.openGui((GuiScreen)new GuiConfigs());
                return true;
            }
            if (key == Hotkeys.OPEN_GUI_PLACEMENT_SETTINGS.getKeybind()) {
                SchematicPlacement schematicPlacement = DataManager.getSchematicPlacementManager().getSelectedSchematicPlacement();
                if (schematicPlacement != null) {
                    SubRegionPlacement placement = schematicPlacement.getSelectedSubRegionPlacement();
                    if (placement != null) {
                        GuiBase.openGui((GuiScreen)new GuiSubRegionConfiguration(schematicPlacement, placement));
                    } else {
                        GuiBase.openGui((GuiScreen)new GuiPlacementConfiguration(schematicPlacement));
                    }
                } else {
                    InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.no_placement_selected", (Object[])new Object[0]);
                }
                return true;
            }
            if (key == Hotkeys.OPEN_GUI_SCHEMATIC_VERIFIER.getKeybind()) {
                SchematicPlacement schematicPlacement = DataManager.getSchematicPlacementManager().getSelectedSchematicPlacement();
                if (schematicPlacement != null) {
                    GuiBase.openGui((GuiScreen)new GuiSchematicVerifier(schematicPlacement));
                } else {
                    InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.no_placement_selected", (Object[])new Object[0]);
                }
                return true;
            }
            if (key == Hotkeys.OPEN_GUI_MATERIAL_LIST.getKeybind()) {
                MaterialListBase materialList = DataManager.getMaterialList();
                if (materialList == null) {
                    SchematicPlacement schematicPlacement = DataManager.getSchematicPlacementManager().getSelectedSchematicPlacement();
                    if (schematicPlacement != null) {
                        materialList = schematicPlacement.getMaterialList();
                        materialList.reCreateMaterialList();
                    } else {
                        InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.no_placement_selected", (Object[])new Object[0]);
                    }
                }
                if (materialList != null) {
                    GuiBase.openGui((GuiScreen)new GuiMaterialList(materialList));
                }
                return true;
            }
            if (key == Hotkeys.OPEN_GUI_AREA_SETTINGS.getKeybind()) {
                SelectionManager manager = DataManager.getSelectionManager();
                if (manager.getCurrentSelection() != null) {
                    manager.openEditGui(null);
                } else {
                    InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.no_area_selected", (Object[])new Object[0]);
                }
                return true;
            }
            if (key == Hotkeys.RERENDER_SCHEMATIC.getKeybind()) {
                SchematicWorldRefresher.INSTANCE.updateAll();
                InfoUtils.printActionbarMessage((String)"litematica.message.schematic_rendering_refreshed", (Object[])new Object[0]);
                return true;
            }
            if (key == Hotkeys.ROTATE_PLACEMENT_CW.getKeybind()) {
                SchematicPlacement placement = DataManager.getSchematicPlacementManager().getSelectedSchematicPlacement();
                if (placement != null) {
                    placement.rotateBy(Rotation.CLOCKWISE_90);
                }
                return true;
            }
            if (key == Hotkeys.ROTATE_PLACEMENT_CCW.getKeybind()) {
                SchematicPlacement placement = DataManager.getSchematicPlacementManager().getSelectedSchematicPlacement();
                if (placement != null) {
                    placement.rotateBy(Rotation.COUNTERCLOCKWISE_90);
                }
                return true;
            }
            if (key == Hotkeys.LAYER_NEXT.getKeybind()) {
                DataManager.getRenderLayerRange().moveLayer(1);
                return true;
            }
            if (key == Hotkeys.LAYER_PREVIOUS.getKeybind()) {
                DataManager.getRenderLayerRange().moveLayer(-1);
                return true;
            }
            if (key == Hotkeys.LAYER_SET_HERE.getKeybind()) {
                DataManager.getRenderLayerRange().setToPosition((Entity)this.mc.field_71439_g);
                return true;
            }
            if (key == Hotkeys.LAYER_MODE_NEXT.getKeybind()) {
                DataManager.getRenderLayerRange().setLayerMode((LayerMode)DataManager.getRenderLayerRange().getLayerMode().cycle(true));
                return true;
            }
            if (key == Hotkeys.LAYER_MODE_PREVIOUS.getKeybind()) {
                DataManager.getRenderLayerRange().setLayerMode((LayerMode)DataManager.getRenderLayerRange().getLayerMode().cycle(false));
                return true;
            }
            if (key == Hotkeys.PICK_BLOCK_FIRST.getKeybind()) {
                if (EntityUtils.shouldPickBlock((EntityPlayer)this.mc.field_71439_g)) {
                    return WorldUtils.doSchematicWorldPickBlock(true, this.mc);
                }
                return false;
            }
            if (key == Hotkeys.PICK_BLOCK_LAST.getKeybind()) {
                if (EntityUtils.shouldPickBlock((EntityPlayer)this.mc.field_71439_g) && !KeybindMulti.hotkeyMatchesKeybind((IHotkey)Hotkeys.PICK_BLOCK_LAST, (KeyBinding)this.mc.field_71474_y.field_74313_G)) {
                    WorldUtils.doSchematicWorldPickBlock(false, this.mc);
                }
                return false;
            }
            if (key == Hotkeys.SAVE_AREA_AS_SCHEMATIC_TO_FILE.getKeybind()) {
                return SchematicUtils.saveSchematic(false);
            }
            if (key == Hotkeys.SAVE_AREA_AS_IN_MEMORY_SCHEMATIC.getKeybind()) {
                return SchematicUtils.saveSchematic(true);
            }
            if (key == Hotkeys.SCHEMATIC_VERSION_CYCLE_NEXT.getKeybind()) {
                if (DataManager.getSchematicProjectsManager().hasProjectOpen()) {
                    DataManager.getSchematicProjectsManager().cycleVersion(1);
                }
                return true;
            }
            if (key == Hotkeys.SCHEMATIC_VERSION_CYCLE_PREVIOUS.getKeybind()) {
                if (DataManager.getSchematicProjectsManager().hasProjectOpen()) {
                    DataManager.getSchematicProjectsManager().cycleVersion(-1);
                }
                return true;
            }
            if (key == Hotkeys.CLONE_SELECTION.getKeybind()) {
                SchematicUtils.cloneSelectionArea(this.mc);
                return true;
            }
            if (key == Hotkeys.EXECUTE_OPERATION.getKeybind() && (hasTool && toolEnabled || !Configs.Generic.EXECUTE_REQUIRE_TOOL.getBooleanValue())) {
                if (DataManager.getSchematicProjectsManager().hasProjectOpen()) {
                    DataManager.getSchematicProjectsManager().pasteCurrentVersionToWorld();
                    return true;
                }
                if (mode == ToolMode.PASTE_SCHEMATIC) {
                    DataManager.getSchematicPlacementManager().pasteCurrentPlacementToWorld(this.mc);
                    return true;
                }
                if (mode == ToolMode.FILL && mode.getPrimaryBlock() != null) {
                    ToolUtils.fillSelectionVolumes(this.mc, mode.getPrimaryBlock(), null);
                    return true;
                }
                if (mode == ToolMode.REPLACE_BLOCK && mode.getPrimaryBlock() != null && mode.getSecondaryBlock() != null) {
                    ToolUtils.fillSelectionVolumes(this.mc, mode.getPrimaryBlock(), mode.getSecondaryBlock());
                    return true;
                }
                if (mode == ToolMode.DELETE) {
                    boolean removeEntities = true;
                    ToolUtils.deleteSelectionVolumes(removeEntities, this.mc);
                    return true;
                }
            } else {
                if (key == Hotkeys.NUDGE_SELECTION_NEGATIVE.getKeybind() || key == Hotkeys.NUDGE_SELECTION_POSITIVE.getKeybind()) {
                    int amount = key == Hotkeys.NUDGE_SELECTION_POSITIVE.getKeybind() ? 1 : -1;
                    InputHandler.nudgeSelection(amount, mode, (EntityPlayer)this.mc.field_71439_g);
                    return true;
                }
                if (key == Hotkeys.TOOL_MODE_CYCLE_FORWARD.getKeybind()) {
                    DataManager.setToolMode(DataManager.getToolMode().cycle((EntityPlayer)this.mc.field_71439_g, true));
                    return true;
                }
                if (key == Hotkeys.TOOL_MODE_CYCLE_BACKWARD.getKeybind()) {
                    DataManager.setToolMode(DataManager.getToolMode().cycle((EntityPlayer)this.mc.field_71439_g, false));
                    return true;
                }
                if (key == Hotkeys.SELECTION_GROW_HOTKEY.getKeybind()) {
                    if (mode.getUsesAreaSelection()) {
                        PositionUtils.growOrShrinkCurrentSelection(true);
                        return true;
                    }
                } else if (key == Hotkeys.SELECTION_SHRINK_HOTKEY.getKeybind()) {
                    if (mode.getUsesAreaSelection()) {
                        PositionUtils.growOrShrinkCurrentSelection(false);
                        return true;
                    }
                } else if (key == Hotkeys.UNLOAD_CURRENT_SCHEMATIC.getKeybind()) {
                    SchematicUtils.unloadCurrentlySelectedSchematic();
                    return true;
                }
            }
            return false;
        }
    }

    private static class RenderToggle
    extends KeyCallbackToggleBooleanConfigWithMessage {
        public RenderToggle(IConfigBoolean config) {
            super(config);
        }

        public boolean onKeyAction(KeyAction action, IKeybind key) {
            super.onKeyAction(action, key);
            if (this.config.getBooleanValue()) {
                SchematicWorldRefresher.INSTANCE.updateAll();
            }
            return true;
        }
    }
}

