/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.script.obj;

import cd4017be.lib.script.obj.IOperand;
import cd4017be.lib.script.obj.Number;
import java.util.Arrays;

public class Vector
implements IOperand {
    private boolean copied;
    public final double[] value;

    public Vector(int n) {
        this.value = new double[n];
    }

    public Vector(IOperand[] args) {
        int n = 0;
        for (IOperand op : args) {
            n += op instanceof Vector ? ((Vector)op).value.length : 1;
        }
        double[] value = new double[n];
        n = 0;
        for (IOperand op : args) {
            if (op instanceof Vector) {
                double[] x = ((Vector)op).value;
                int l = x.length;
                System.arraycopy(x, 0, value, n, l);
                n += l;
                continue;
            }
            value[n++] = op.asDouble();
        }
        this.value = value;
    }

    private Vector of() {
        if (this.copied) {
            return new Vector(this.value.length);
        }
        return this;
    }

    @Override
    public boolean asBool() {
        return this.value.length > 0;
    }

    @Override
    public int asIndex() {
        return this.value.length == 0 ? 0 : (int)this.value[0];
    }

    @Override
    public IOperand onCopy() {
        this.copied = true;
        return this;
    }

    @Override
    public IOperand addR(IOperand x) {
        double[] a = this.value;
        if (x instanceof Vector) {
            double[] b = ((Vector)x).value;
            int l = b.length;
            int dl = a.length - l;
            if (dl < 0) {
                return x.addR(this);
            }
            Vector ret = this.of();
            double[] c = ret.value;
            for (int i = 0; i < l; ++i) {
                c[i] = a[i] + b[i];
            }
            if (this.copied && dl > 0) {
                System.arraycopy(a, l, c, l, dl);
            }
            return ret;
        }
        if (x instanceof Number) {
            Vector ret = this.of();
            double[] c = ret.value;
            double b = ((Number)x).value;
            for (int i = this.value.length - 1; i >= 0; --i) {
                c[i] = a[i] + b;
            }
            return ret;
        }
        return x.addL(this);
    }

    @Override
    public IOperand addL(IOperand x) {
        if (x instanceof Number) {
            Vector ret = this.of();
            double[] a = this.value;
            double[] c = ret.value;
            double b = ((Number)x).value;
            for (int i = this.value.length - 1; i >= 0; --i) {
                c[i] = a[i] + b;
            }
            return ret;
        }
        return IOperand.super.addL(x);
    }

    @Override
    public IOperand subR(IOperand x) {
        double[] a = this.value;
        if (x instanceof Vector) {
            double[] b = ((Vector)x).value;
            int l = b.length;
            int dl = a.length - l;
            if (dl < 0) {
                return x.subL(this);
            }
            Vector ret = this.of();
            double[] c = ret.value;
            for (int i = 0; i < l; ++i) {
                c[i] = a[i] - b[i];
            }
            if (this.copied && dl > 0) {
                System.arraycopy(a, l, c, l, dl);
            }
            return ret;
        }
        if (x instanceof Number) {
            Vector ret = this.of();
            double[] c = ret.value;
            double b = ((Number)x).value;
            for (int i = this.value.length - 1; i >= 0; --i) {
                c[i] = a[i] - b;
            }
            return ret;
        }
        return x.subL(this);
    }

    @Override
    public IOperand subL(IOperand x) {
        Vector ret = this.of();
        double[] a = this.value;
        double[] c = ret.value;
        if (x instanceof Vector) {
            int i;
            double[] b = ((Vector)x).value;
            int l = b.length;
            int dl = a.length - l;
            for (i = 0; i < l; ++i) {
                c[i] = b[i] - a[i];
            }
            if (this.copied && dl > 0) {
                for (i = l + dl - 1; i >= l; --i) {
                    c[i] = -a[i];
                }
            }
        } else if (x instanceof Number) {
            double b = ((Number)x).value;
            for (int i = this.value.length - 1; i >= 0; --i) {
                c[i] = b - a[i];
            }
        } else {
            return IOperand.super.subL(x);
        }
        return ret;
    }

    @Override
    public IOperand mulR(IOperand x) {
        double[] a = this.value;
        if (x instanceof Vector) {
            double[] b = ((Vector)x).value;
            int l = b.length;
            int dl = a.length - l;
            Vector ret = this.of();
            if (dl < 0) {
                l += dl;
                ret = this.of();
            } else {
                ret = ((Vector)x).of();
            }
            double[] c = ret.value;
            for (int i = 0; i < l; ++i) {
                c[i] = a[i] * b[i];
            }
            return ret;
        }
        if (x instanceof Number) {
            Vector ret = this.of();
            double[] c = ret.value;
            double b = ((Number)x).value;
            for (int i = this.value.length - 1; i >= 0; --i) {
                c[i] = a[i] * b;
            }
            return ret;
        }
        return x.mulL(this);
    }

    @Override
    public IOperand mulL(IOperand x) {
        if (x instanceof Number) {
            Vector ret = this.of();
            double[] a = this.value;
            double[] c = ret.value;
            double b = ((Number)x).value;
            for (int i = this.value.length - 1; i >= 0; --i) {
                c[i] = a[i] * b;
            }
            return ret;
        }
        return IOperand.super.mulL(x);
    }

    @Override
    public IOperand divR(IOperand x) {
        double[] a = this.value;
        if (x instanceof Vector) {
            Vector ret;
            double[] b = ((Vector)x).value;
            int l = b.length;
            int dl = a.length - l;
            if (dl < 0) {
                l += dl;
                ret = this.of();
            } else {
                ret = ((Vector)x).of();
            }
            double[] c = ret.value;
            for (int i = 0; i < l; ++i) {
                c[i] = a[i] / b[i];
            }
            return ret;
        }
        if (x instanceof Number) {
            Vector ret = this.of();
            double[] c = ret.value;
            double b = ((Number)x).value;
            for (int i = this.value.length - 1; i >= 0; --i) {
                c[i] = a[i] / b;
            }
            return ret;
        }
        return x.divL(this);
    }

    @Override
    public IOperand divL(IOperand x) {
        Vector ret = this.of();
        double[] a = this.value;
        double[] c = ret.value;
        if (x instanceof Number) {
            double b = ((Number)x).value;
            for (int i = this.value.length - 1; i >= 0; --i) {
                c[i] = b / a[i];
            }
        } else {
            return IOperand.super.divL(x);
        }
        return ret;
    }

    @Override
    public IOperand modR(IOperand x) {
        double[] a = this.value;
        if (x instanceof Vector) {
            Vector ret;
            double[] b = ((Vector)x).value;
            int l = b.length;
            int dl = a.length - l;
            if (dl < 0) {
                l += dl;
                ret = this.of();
            } else {
                ret = ((Vector)x).of();
            }
            double[] c = ret.value;
            for (int i = 0; i < l; ++i) {
                c[i] = a[i] % b[i];
            }
            return ret;
        }
        if (x instanceof Number) {
            Vector ret = this.of();
            double[] c = ret.value;
            double b = ((Number)x).value;
            for (int i = this.value.length - 1; i >= 0; --i) {
                c[i] = a[i] % b;
            }
            return ret;
        }
        return x.modL(this);
    }

    @Override
    public IOperand modL(IOperand x) {
        Vector ret = this.of();
        double[] a = this.value;
        double[] c = ret.value;
        if (x instanceof Number) {
            double b = ((Number)x).value;
            for (int i = this.value.length - 1; i >= 0; --i) {
                c[i] = b % a[i];
            }
        } else {
            return IOperand.super.modL(x);
        }
        return ret;
    }

    @Override
    public IOperand neg() {
        Vector ret = this.of();
        double[] a = this.value;
        double[] c = ret.value;
        for (int i = this.value.length - 1; i >= 0; --i) {
            c[i] = -a[i];
        }
        return ret;
    }

    @Override
    public IOperand inv() {
        Vector ret = this.of();
        double[] a = this.value;
        double[] c = ret.value;
        for (int i = this.value.length - 1; i >= 0; --i) {
            c[i] = 1.0 / a[i];
        }
        return ret;
    }

    @Override
    public IOperand and(IOperand x) {
        if (x instanceof Vector) {
            double[] a = this.value;
            double[] b = ((Vector)x).value;
            if (a.length == 3 && b.length == 3) {
                Vector ret = this.of();
                double[] c = ret.value;
                double ax = a[0];
                double ay = a[1];
                double az = a[2];
                double bx = b[0];
                double by = b[1];
                double bz = b[2];
                c[0] = ay * bz - az * by;
                c[1] = az * bx - ax * bz;
                c[2] = ax * by - ay * bx;
                return ret;
            }
        }
        return IOperand.super.and(x);
    }

    @Override
    public IOperand or(IOperand x) {
        if (x instanceof Vector) {
            double[] a = this.value;
            double[] b = ((Vector)x).value;
            double y = 0.0;
            for (int i = Math.min(a.length, b.length) - 1; i >= 0; --i) {
                y += a[i] * b[i];
            }
            return new Number(y);
        }
        return IOperand.super.or(x);
    }

    @Override
    public IOperand len() {
        return new Number(this.value.length);
    }

    @Override
    public IOperand get(IOperand idx) {
        int i = idx.asIndex();
        if (i >= 0 && i < this.value.length) {
            return new Number(this.value[i]);
        }
        return Number.FALSE;
    }

    @Override
    public void put(IOperand idx, IOperand val) {
        int i = idx.asIndex();
        if (i >= 0 && i < this.value.length) {
            this.value[i] = val.asDouble();
        }
    }

    @Override
    public IOperand.OperandIterator iterator() {
        return new Iterator();
    }

    @Override
    public Object value() {
        return this.value;
    }

    public String toString() {
        return Arrays.toString(this.value);
    }

    class Iterator
    implements IOperand.OperandIterator {
        int cur = 0;

        Iterator() {
        }

        @Override
        public boolean hasNext() {
            return this.cur < Vector.this.value.length;
        }

        @Override
        public IOperand next() {
            return new Number(Vector.this.value[this.cur++]);
        }

        @Override
        public void set(IOperand e) {
            Vector.this.value[this.cur - 1] = e.asDouble();
        }

        @Override
        public void reset() {
            this.cur = 0;
        }

        @Override
        public Object value() {
            return this;
        }
    }
}

