/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.script.obj;

import cd4017be.lib.script.obj.Array;
import cd4017be.lib.script.obj.Error;
import cd4017be.lib.script.obj.IOperand;
import cd4017be.lib.script.obj.Nil;
import cd4017be.lib.script.obj.Number;
import cd4017be.lib.script.obj.Text;
import cd4017be.lib.script.obj.Vector;
import java.util.Iterator;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class NBTWrapper
implements IOperand {
    private boolean copied;
    public final NBTTagCompound nbt;

    public NBTWrapper() {
        this.nbt = new NBTTagCompound();
    }

    public NBTWrapper(NBTTagCompound nbt) {
        this.nbt = nbt;
    }

    @Override
    public NBTWrapper onCopy() {
        this.copied = true;
        return this;
    }

    @Override
    public boolean asBool() throws Error {
        return !this.nbt.func_82582_d();
    }

    @Override
    public Object value() {
        return this.nbt;
    }

    @Override
    public int asIndex() {
        return this.nbt.func_186856_d();
    }

    @Override
    public IOperand len() {
        return new Number(this.nbt.func_186856_d());
    }

    @Override
    public IOperand addR(IOperand x) {
        if (x instanceof NBTWrapper) {
            NBTWrapper a = this.copied ? new NBTWrapper(this.nbt.func_74737_b()) : this;
            NBTWrapper b = (NBTWrapper)x;
            a.nbt.func_179237_a(b.nbt);
            return a;
        }
        return IOperand.super.addR(x);
    }

    @Override
    public IOperand get(IOperand idx) {
        NBTBase tag = this.nbt.func_74781_a(idx.toString());
        return tag == null ? Nil.NIL : this.expand(tag);
    }

    private IOperand expand(NBTBase tag) {
        switch (tag.func_74732_a()) {
            case 10: {
                return new NBTWrapper((NBTTagCompound)tag);
            }
            case 9: {
                NBTTagList list = (NBTTagList)tag;
                Array a = new Array(list.func_74745_c());
                for (int i = 0; i < a.array.length; ++i) {
                    a.array[i] = this.expand(list.func_179238_g(i));
                }
                return a;
            }
            case 8: {
                return new Text(((NBTTagString)tag).func_150285_a_());
            }
            case 7: {
                byte[] arr = ((NBTTagByteArray)tag).func_150292_c();
                Vector v = new Vector(arr.length);
                for (int i = 0; i < arr.length; ++i) {
                    v.value[i] = arr[i] & 0xFF;
                }
                return v;
            }
            case 11: {
                int[] arr = ((NBTTagIntArray)tag).func_150302_c();
                Vector v = new Vector(arr.length);
                for (int i = 0; i < arr.length; ++i) {
                    v.value[i] = arr[i];
                }
                return v;
            }
        }
        if (tag instanceof NBTPrimitive) {
            return new Number(((NBTPrimitive)tag).func_150286_g());
        }
        return Nil.NIL;
    }

    @Override
    public void put(IOperand idx, IOperand val) {
        NBTBase tag;
        String key = idx.toString();
        if (key.isEmpty()) {
            return;
        }
        char c = key.charAt(0);
        key = key.substring(1);
        NBTBase nBTBase = tag = val == Nil.NIL ? null : this.parse(c, val);
        if (tag == null) {
            this.nbt.func_82580_o(key);
        } else {
            this.nbt.func_74782_a(key, tag);
        }
    }

    private NBTBase parse(char type, IOperand val) {
        if (val instanceof NBTWrapper) {
            return ((NBTWrapper)val).nbt;
        }
        if (val instanceof Array) {
            NBTTagList list = new NBTTagList();
            for (IOperand op : ((Array)val).array) {
                NBTBase tag = this.parse(type, op);
                if (tag == null) continue;
                list.func_74742_a(tag);
            }
            return list;
        }
        if (val instanceof Text) {
            return new NBTTagString(val.toString());
        }
        if (val instanceof Vector) {
            double[] v = ((Vector)val).value;
            switch (type) {
                case 'B': {
                    byte[] arr = new byte[v.length];
                    for (int i = 0; i < arr.length; ++i) {
                        arr[i] = (byte)v[i];
                    }
                    return new NBTTagByteArray(arr);
                }
                case 'I': {
                    int[] arr = new int[v.length];
                    for (int i = 0; i < arr.length; ++i) {
                        arr[i] = (int)v[i];
                    }
                    return new NBTTagIntArray(arr);
                }
            }
            return null;
        }
        double v = val.asDouble();
        switch (type) {
            case 'B': {
                return new NBTTagByte((byte)v);
            }
            case 'S': {
                return new NBTTagShort((short)v);
            }
            case 'I': {
                return new NBTTagInt((int)v);
            }
            case 'L': {
                return new NBTTagLong((long)v);
            }
            case 'F': {
                return new NBTTagFloat((float)v);
            }
            case 'D': {
                return new NBTTagDouble(v);
            }
        }
        return null;
    }

    public String toString() {
        return this.nbt.toString();
    }

    @Override
    public IOperand.OperandIterator iterator() throws Error {
        return new KeyIterator(this.nbt.func_150296_c().iterator());
    }

    static class KeyIterator
    implements IOperand.OperandIterator {
        final Iterator<String> it;

        KeyIterator(Iterator<String> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public IOperand next() {
            return new Text(this.it.next());
        }

        @Override
        public Object value() {
            return this;
        }

        @Override
        public void set(IOperand obj) {
        }
    }
}

