/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.network;

import cd4017be.lib.network.StateSyncClient;
import cd4017be.lib.network.StateSyncServer;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.BitSet;

public abstract class StateSynchronizer {
    protected final int[] sizes;
    protected final int[] indices;
    public final int count;
    protected final int modSetBytes;
    protected final int idxBits;
    protected final int idxCountBits;
    protected final int maxIdxCount;
    public BitSet changes;

    protected StateSynchronizer(int count, int ... sizes) {
        if (sizes.length > count) {
            throw new IllegalArgumentException("can't have more fixed sized elements than total elements!");
        }
        this.count = count;
        this.sizes = sizes;
        int l = sizes.length;
        int[] indices = new int[l];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            indices[i] = j;
            j += sizes[i];
        }
        this.indices = indices;
        this.changes = new BitSet(count);
        if (count < 8) {
            this.modSetBytes = 1;
            this.maxIdxCount = 0;
            this.idxBits = 0;
            this.idxCountBits = 0;
        } else {
            this.modSetBytes = count / 8 + 1;
            int m = this.modSetBytes * 8 - 9;
            int i = this.idxBits = 32 - Integer.numberOfLeadingZeros(count - 1);
            int j2 = 32 - Integer.numberOfLeadingZeros(m / i);
            j2 = (m - j2) / i;
            this.idxCountBits = 32 - Integer.numberOfLeadingZeros(j2);
            this.maxIdxCount = j2;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private IntArrayList sizes = new IntArrayList();
        private int count;

        private Builder() {
        }

        public Builder addVar(int count) {
            this.count += count;
            return this;
        }

        public Builder addFix(int ... sizes) {
            this.sizes.addElements(this.sizes.size(), sizes);
            return this;
        }

        public Builder addMulFix(int size, int count) {
            while (count > 0) {
                this.sizes.add(size);
                --count;
            }
            return this;
        }

        public int varCount() {
            return this.count;
        }

        public int fixCount() {
            return this.sizes.size();
        }

        public StateSyncServer buildSender() {
            return new StateSyncServer(this.count + this.sizes.size(), this.sizes.toIntArray());
        }

        public StateSyncClient buildReceiver() {
            return new StateSyncClient(this.count + this.sizes.size(), this.sizes.toIntArray());
        }

        public StateSynchronizer build(boolean receive) {
            return receive ? this.buildReceiver() : this.buildSender();
        }
    }
}

