/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.jvm_utils;

import cd4017be.lib.jvm_utils.ClassAssembler;
import cd4017be.lib.jvm_utils.ConstantPool;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;

public class MethodAssembler {
    private final IntArrayList locals;
    private final IntArrayList stack;
    public final ByteBuf code;
    public final ConstantPool cpt;
    private int maxStack;
    private ArrayList<byte[]> frames;
    private int lastFrame = -1;
    public static final int T_TOP = 0;
    public static final int T_INT = 65536;
    public static final int T_FLOAT = 131072;
    public static final int T_DOUBLE = 196608;
    public static final int T_LONG = 262144;
    public static final int T_NULL = 327680;
    public static final int T_UI_THIS = 393216;
    public static final int T_OBJECT = 458752;
    public static final int T_UI_OBJ = 524288;
    public static final int T_THIS = 458754;

    public MethodAssembler(ConstantPool cpt, int ... param) {
        this.locals = new IntArrayList(param);
        this.stack = new IntArrayList();
        this.code = Unpooled.buffer();
        this.cpt = cpt;
        this.frames = new ArrayList();
    }

    public int newLocal(int type) {
        int i = this.locals.indexOf(0);
        if (i >= 0) {
            this.locals.set(i, type);
        } else {
            i = this.locals.size();
            this.locals.add(type);
        }
        return i;
    }

    public void clearLocal(int i) {
        this.locals.set(i, 0);
    }

    public void change(int ... types) {
        int l = this.stack.size();
        int i = l - types.length;
        int j = 0;
        while (i < l) {
            this.stack.set(i, types[j]);
            ++i;
            ++j;
        }
    }

    public void push(int ... types) {
        this.stack.addElements(this.stack.size(), types);
        int l = this.stack.size();
        if (l > this.maxStack) {
            this.maxStack = l;
        }
    }

    public void pushN(int n, int type) {
        for (int i = 0; i < n; ++i) {
            this.stack.add(type);
        }
        int l = this.stack.size();
        if (l > this.maxStack) {
            this.maxStack = l;
        }
    }

    public void pop(int n) {
        int l = this.stack.size();
        this.stack.removeElements(l - n, l);
    }

    public int pushConst(int v) {
        this.push(65536);
        if (v >= Short.MIN_VALUE && v <= Short.MAX_VALUE) {
            byte[] arr = ClassAssembler._iconst_((short)v);
            this.code.writeBytes(arr);
            return arr.length;
        }
        short i = this.cpt.putInt(v);
        if (i < 256) {
            this.code.writeByte(18).writeByte((int)i);
            return 2;
        }
        this.code.writeByte(19).writeShort((int)i);
        return 3;
    }

    public int store(int i) {
        int t = this.locals.getInt(i);
        switch (t) {
            case 65536: {
                t = 0;
                this.pop(1);
                break;
            }
            case 262144: {
                t = 1;
                this.pop(2);
                break;
            }
            case 131072: {
                t = 2;
                this.pop(1);
                break;
            }
            case 196608: {
                t = 3;
                this.pop(2);
                break;
            }
            default: {
                t = 4;
                this.pop(1);
            }
        }
        if (i < 4) {
            this.code.writeByte(59 + i + t * 4);
            return 1;
        }
        this.code.writeByte(54 + t).writeByte(i);
        return 2;
    }

    public int load(int i) {
        int t = this.locals.getInt(i);
        switch (t) {
            case 65536: {
                this.push(t);
                t = 0;
                break;
            }
            case 262144: {
                this.push(t, 0);
                t = 1;
                break;
            }
            case 131072: {
                this.push(t);
                t = 2;
                break;
            }
            case 196608: {
                this.push(t, 0);
                t = 3;
                break;
            }
            default: {
                this.push(t);
                t = 4;
            }
        }
        if (i < 4) {
            this.code.writeByte(26 + i + t * 4);
            return 1;
        }
        this.code.writeByte(21 + t).writeByte(i);
        return 2;
    }

    public void frame() {
        int e;
        int e2;
        int l = 7;
        IntListIterator intListIterator = this.locals.iterator();
        while (intListIterator.hasNext()) {
            e2 = (Integer)intListIterator.next();
            l += e2 >= 458752 ? 3 : 1;
        }
        intListIterator = this.stack.iterator();
        while (intListIterator.hasNext()) {
            e2 = (Integer)intListIterator.next();
            l += e2 >= 458752 ? 3 : 1;
        }
        int p = this.code.writerIndex();
        int d = p - this.lastFrame - 1;
        ByteBuffer b = ByteBuffer.allocate(l);
        b.put((byte)-1).putShort((short)d);
        b.putShort((short)this.locals.size());
        IntListIterator intListIterator2 = this.locals.iterator();
        while (intListIterator2.hasNext()) {
            e = (Integer)intListIterator2.next();
            b.put((byte)(e >> 16));
            if (e < 458752) continue;
            b.putShort((short)e);
        }
        b.putShort((short)this.stack.size());
        intListIterator2 = this.stack.iterator();
        while (intListIterator2.hasNext()) {
            e = (Integer)intListIterator2.next();
            b.put((byte)(e >> 16));
            if (e < 458752) continue;
            b.putShort((short)e);
        }
        this.lastFrame = p;
        this.frames.add(b.array());
    }

    public Map<Short, byte[]> generate() {
        ByteBuf b = this.code;
        byte[] code = new byte[b.writerIndex()];
        b.readBytes(code);
        return ClassAssembler.genCode(this.locals.size(), this.maxStack, code, null, this.frames, this.cpt);
    }

    public int type(Class<?> c) {
        return 458752 + this.cpt.putClass(c.getName());
    }
}

