/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.rs_ctr.port;

import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.api.rs_ctr.port.Port;
import cd4017be.lib.util.ItemFluidUtil;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class Connector
implements INBTSerializable<NBTTagCompound> {
    public static final HashMap<String, Function<MountedPort, ? extends Connector>> REGISTRY = new HashMap();
    public final MountedPort port;

    public Connector(MountedPort port) {
        this.port = port;
    }

    public String displayInfo(MountedPort port, int linkID) {
        return linkID != 0 ? "\n#" + linkID : "";
    }

    public abstract void onRemoved(@Nullable EntityPlayer var1);

    public void onLoad() {
    }

    public void onUnload() {
    }

    public void onLinkLoad(Port link) {
    }

    public void onPortMove() {
    }

    protected abstract String id();

    protected void dropItem(ItemStack stack, @Nullable EntityPlayer player) {
        if (player == null) {
            ItemFluidUtil.dropStack(stack, this.port.getWorld(), this.port.getPos());
        } else if (!player.func_184812_l_()) {
            ItemFluidUtil.dropStack(stack, (Entity)player);
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("id", this.id());
        return nbt;
    }

    public static Connector load(NBTTagCompound nbt, MountedPort port) {
        Function<MountedPort, ? extends Connector> c = REGISTRY.get(nbt.func_74779_i("id"));
        if (c == null) {
            return null;
        }
        Connector con = c.apply(port);
        con.deserializeNBT((NBTBase)nbt);
        return con;
    }

    public static interface IConnectorItem {
        public void doAttach(ItemStack var1, MountedPort var2, EntityPlayer var3);
    }
}

