/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.recipes;

import cd4017be.api.recipes.OreDictList;
import cd4017be.api.recipes.OreGenHandler;
import cd4017be.api.recipes.RecipeScriptContext;
import cd4017be.api.recipes.mods.ImmersiveEngineeringModule;
import cd4017be.api.recipes.vanilla.CraftingRecipeIterator;
import cd4017be.api.recipes.vanilla.FuelHandler;
import cd4017be.api.recipes.vanilla.SmeltingIterator;
import cd4017be.lib.Lib;
import cd4017be.lib.script.Parameters;
import cd4017be.lib.script.obj.Error;
import cd4017be.lib.script.obj.FilteredIterator;
import cd4017be.lib.script.obj.IOperand;
import cd4017be.lib.script.obj.Text;
import cd4017be.lib.templates.NBTRecipe;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeAPI {
    public static final HashMap<String, IRecipeHandler> Handlers = new HashMap();
    public static final HashMap<String, IRecipeList> Lists = new HashMap();
    private static final HashMap<String, Integer> UsedNames = new HashMap();

    public static void addModModules(RecipeScriptContext cont) {
        if (Loader.isModLoaded((String)"immersiveengineering")) {
            cont.add(new ImmersiveEngineeringModule());
        }
    }

    private static Object[] decodePattern(Parameters p, int i0) {
        String s = p.getString(i0++);
        String[] pattern = s.split("/");
        int n = p.param.length - i0;
        Object[] arr = new Object[n * 2 + pattern.length];
        int j = 0;
        for (String l : pattern) {
            arr[j++] = l;
        }
        for (int i = 0; i < n; ++i) {
            char c = Character.forDigit(i, 9);
            if (s.indexOf(c) < 0) continue;
            arr[j++] = Character.valueOf(c);
            arr[j++] = p.param[i + i0].value();
        }
        return j < arr.length ? Arrays.copyOf(arr, j) : arr;
    }

    public static String genericName(IRecipe rcp) {
        ItemStack stack = rcp.func_77571_b();
        Item item = stack.func_77973_b();
        ResourceLocation res = item.getRegistryName();
        String name = res.func_110624_b() + "/" + res.func_110623_a();
        if (item.func_77614_k()) {
            name = name + "_" + stack.func_77952_i();
        }
        int n = UsedNames.getOrDefault(name, 0);
        UsedNames.put(name, n + 1);
        if (n > 0) {
            name = name + "_" + RecipeAPI.asLetter(n);
        }
        return name;
    }

    private static String asLetter(int i) {
        String s = "";
        do {
            s = s + (char)(i % 26 + 97);
        } while ((i /= 26) > 26);
        return s;
    }

    public static <T extends IForgeRegistryEntry.Impl<IRecipe>> void addRecipe(T rcp) {
        ForgeRegistries.RECIPES.register(rcp.setRegistryName(RecipeAPI.genericName((IRecipe)rcp)));
    }

    public static Predicate<Object> getFilter(IOperand o) {
        if (o instanceof Text) {
            return new RegexFilter(((Text)o).value);
        }
        return p -> {
            try {
                return p instanceof IOperand ? o.nlsR((IOperand)p).asBool() : o.value().equals(p);
            }
            catch (Error e) {
                throw new IllegalArgumentException(e);
            }
        };
    }

    public static void createOreDictEntries(Class<?> c, String name) {
        block3: {
            block2: {
                if (!Block.class.isAssignableFrom(c)) break block2;
                for (Block block : Block.field_149771_c) {
                    Item item;
                    if (!c.isInstance(block) || (item = Item.func_150898_a((Block)block)) == null) continue;
                    OreDictionary.registerOre((String)name, (Item)item);
                }
                break block3;
            }
            if (!Item.class.isAssignableFrom(c)) break block3;
            for (Item item : Item.field_150901_e) {
                if (!c.isInstance(item)) continue;
                OreDictionary.registerOre((String)name, (Item)item);
            }
        }
    }

    static {
        Handlers.put("shaped", p -> RecipeAPI.addRecipe(new ShapedOreRecipe(null, p.get(1, ItemStack.class), RecipeAPI.decodePattern(p, 2))));
        Handlers.put("shapedNBT", p -> RecipeAPI.addRecipe(new NBTRecipe(null, p.get(2, ItemStack.class), p.getString(1), RecipeAPI.decodePattern(p, 3))));
        Handlers.put("ore", p -> {
            String name = p.getString(1);
            for (int i = 2; i < p.param.length; ++i) {
                OreDictionary.registerOre((String)name, (ItemStack)p.get(i, ItemStack.class));
            }
        });
        Lists.put("ore", p -> new FilteredIterator(new OreDictList(), new RegexFilter(p.getString(1))));
        Lists.put("craftIng", p -> new CraftingRecipeIterator(p.get(1, ItemStack.class)));
        Lists.put("craftRes", p -> new CraftingRecipeIterator(RecipeAPI.getFilter(p.param[1])));
        Lists.put("smeltIng", p -> new SmeltingIterator(RecipeAPI.getFilter(p.param[1]), false));
        Lists.put("smeltRes", p -> new SmeltingIterator(RecipeAPI.getFilter(p.param[1]), true));
        Handlers.put("shapeless", p -> RecipeAPI.addRecipe(new ShapelessOreRecipe(null, p.get(1, ItemStack.class), p.getArrayOrAll(2))));
        Handlers.put("smelt", p -> GameRegistry.addSmelting((ItemStack)p.get(1, ItemStack.class), (ItemStack)p.get(2, ItemStack.class), (float)(p.param.length > 3 ? (float)p.getNumber(3) : 0.0f)));
        Handlers.put("fuel", new FuelHandler());
        Handlers.put("worldgen", new OreGenHandler());
        Handlers.put("item", p -> {
            int n = p.param.length;
            Lib.materials.addMaterial((int)p.getNumber(1), p.getString(2), n > 3 ? p.getString(3) : null, n > 4 ? p.getString(4) : null);
        });
    }

    public static class RegexFilter
    implements Predicate<Object> {
        private final Pattern pattern;

        public RegexFilter(String expr) {
            this.pattern = Pattern.compile(expr);
        }

        @Override
        public boolean test(Object o) {
            return o != null && this.pattern.matcher(o.toString()).matches();
        }
    }

    public static interface IRecipeList {
        public IOperand.OperandIterator list(Parameters var1);
    }

    public static interface IRecipeHandler {
        public void addRecipe(Parameters var1);
    }
}

