/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.energy;

import cd4017be.api.energy.EnergyAPI;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyForge
implements EnergyAPI.IEnergyHandler {
    @Override
    public EnergyAPI.IEnergyAccess create(TileEntity te, EnumFacing s) {
        return te.hasCapability(CapabilityEnergy.ENERGY, s) ? new Energy((ICapabilityProvider)te, s) : null;
    }

    @Override
    public EnergyAPI.IEnergyAccess create(ItemStack item, int s) {
        EnumFacing side = s >= 0 && s < 6 ? EnumFacing.field_82609_l[s] : null;
        return item.hasCapability(CapabilityEnergy.ENERGY, side) ? new Energy((ICapabilityProvider)item, side) : null;
    }

    static class Energy
    implements EnergyAPI.IEnergyAccess {
        final ICapabilityProvider cp;
        final EnumFacing s;

        Energy(ICapabilityProvider cp, EnumFacing s) {
            this.cp = cp;
            this.s = s;
        }

        @Override
        public float getStorage() {
            IEnergyStorage h = (IEnergyStorage)this.cp.getCapability(CapabilityEnergy.ENERGY, this.s);
            return h != null ? (float)h.getEnergyStored() * EnergyAPI.RF_value : 0.0f;
        }

        @Override
        public float getCapacity() {
            IEnergyStorage h = (IEnergyStorage)this.cp.getCapability(CapabilityEnergy.ENERGY, this.s);
            return h != null ? (float)h.getMaxEnergyStored() * EnergyAPI.RF_value : 0.0f;
        }

        @Override
        public float addEnergy(float e) {
            IEnergyStorage h = (IEnergyStorage)this.cp.getCapability(CapabilityEnergy.ENERGY, this.s);
            if (h == null) {
                return 0.0f;
            }
            if (e >= EnergyAPI.RF_value) {
                return (float)h.receiveEnergy((int)Math.floor(e / EnergyAPI.RF_value), false) * EnergyAPI.RF_value;
            }
            if (e <= -EnergyAPI.RF_value) {
                return (float)h.extractEnergy((int)Math.floor(e / -EnergyAPI.RF_value), false) * -EnergyAPI.RF_value;
            }
            return 0.0f;
        }
    }
}

