/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class PositionUtils {
    public static Vec3d modifyValue(CoordinateType type, Vec3d valueIn, double amount) {
        switch (type) {
            case X: {
                return new Vec3d(valueIn.field_72450_a + amount, valueIn.field_72448_b, valueIn.field_72449_c);
            }
            case Y: {
                return new Vec3d(valueIn.field_72450_a, valueIn.field_72448_b + amount, valueIn.field_72449_c);
            }
            case Z: {
                return new Vec3d(valueIn.field_72450_a, valueIn.field_72448_b, valueIn.field_72449_c + amount);
            }
        }
        return valueIn;
    }

    public static BlockPos modifyValue(CoordinateType type, BlockPos valueIn, int amount) {
        switch (type) {
            case X: {
                return new BlockPos(valueIn.func_177958_n() + amount, valueIn.func_177956_o(), valueIn.func_177952_p());
            }
            case Y: {
                return new BlockPos(valueIn.func_177958_n(), valueIn.func_177956_o() + amount, valueIn.func_177952_p());
            }
            case Z: {
                return new BlockPos(valueIn.func_177958_n(), valueIn.func_177952_p(), valueIn.func_177952_p() + amount);
            }
        }
        return valueIn;
    }

    public static Vec3d setValue(CoordinateType type, Vec3d valueIn, double newValue) {
        switch (type) {
            case X: {
                return new Vec3d(newValue, valueIn.field_72448_b, valueIn.field_72449_c);
            }
            case Y: {
                return new Vec3d(valueIn.field_72450_a, newValue, valueIn.field_72449_c);
            }
            case Z: {
                return new Vec3d(valueIn.field_72450_a, valueIn.field_72448_b, newValue);
            }
        }
        return valueIn;
    }

    public static BlockPos setValue(CoordinateType type, BlockPos valueIn, int newValue) {
        switch (type) {
            case X: {
                return new BlockPos(newValue, valueIn.func_177956_o(), valueIn.func_177952_p());
            }
            case Y: {
                return new BlockPos(valueIn.func_177958_n(), newValue, valueIn.func_177952_p());
            }
            case Z: {
                return new BlockPos(valueIn.func_177958_n(), valueIn.func_177952_p(), newValue);
            }
        }
        return valueIn;
    }

    public static Rotation cycleRotation(Rotation rotation, boolean reverse) {
        int ordinal = rotation.ordinal();
        ordinal = reverse ? (ordinal == 0 ? Rotation.values().length - 1 : ordinal - 1) : (ordinal >= Rotation.values().length - 1 ? 0 : ordinal + 1);
        return Rotation.values()[ordinal];
    }

    public static Mirror cycleMirror(Mirror mirror, boolean reverse) {
        int ordinal = mirror.ordinal();
        ordinal = reverse ? (ordinal == 0 ? Mirror.values().length - 1 : ordinal - 1) : (ordinal >= Mirror.values().length - 1 ? 0 : ordinal + 1);
        return Mirror.values()[ordinal];
    }

    public static EnumFacing cycleDirection(EnumFacing direction, boolean reverse) {
        int index = direction.func_176745_a();
        index = reverse ? (index == 0 ? 5 : index - 1) : (index >= 5 ? 0 : index + 1);
        return EnumFacing.func_82600_a((int)index);
    }

    public static EnumFacing getClosestLookingDirection(Entity entity) {
        return PositionUtils.getClosestLookingDirection(entity, 60.0f);
    }

    public static EnumFacing getClosestLookingDirection(Entity entity, float verticalThreshold) {
        if (entity.field_70125_A >= verticalThreshold) {
            return EnumFacing.DOWN;
        }
        if (entity.field_70125_A <= -verticalThreshold) {
            return EnumFacing.UP;
        }
        return entity.func_174811_aO();
    }

    public static BlockPos getPositionInfrontOfEntity(Entity entity) {
        return PositionUtils.getPositionInfrontOfEntity(entity, 60.0f);
    }

    public static BlockPos getPositionInfrontOfEntity(Entity entity, float verticalThreshold) {
        BlockPos pos = new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        if (entity.field_70125_A >= verticalThreshold) {
            return pos.func_177977_b();
        }
        if (entity.field_70125_A <= -verticalThreshold) {
            return new BlockPos(entity.field_70165_t, Math.ceil(entity.func_174813_aQ().field_72337_e), entity.field_70161_v);
        }
        double y = Math.floor(entity.field_70163_u + (double)entity.func_70047_e());
        switch (entity.func_174811_aO()) {
            case EAST: {
                return new BlockPos((int)Math.ceil(entity.field_70165_t + (double)(entity.field_70130_N / 2.0f)), (int)y, (int)Math.floor(entity.field_70161_v));
            }
            case WEST: {
                return new BlockPos((int)Math.floor(entity.field_70165_t - (double)(entity.field_70130_N / 2.0f)) - 1, (int)y, (int)Math.floor(entity.field_70161_v));
            }
            case SOUTH: {
                return new BlockPos((int)Math.floor(entity.field_70165_t), (int)y, (int)Math.ceil(entity.field_70161_v + (double)(entity.field_70130_N / 2.0f)));
            }
            case NORTH: {
                return new BlockPos((int)Math.floor(entity.field_70165_t), (int)y, (int)Math.floor(entity.field_70161_v - (double)(entity.field_70130_N / 2.0f)) - 1);
            }
        }
        return pos;
    }

    public static Vec3d getHitVecCenter(BlockPos basePos, EnumFacing facing) {
        int x = basePos.func_177958_n();
        int y = basePos.func_177956_o();
        int z = basePos.func_177952_p();
        switch (facing) {
            case UP: {
                return new Vec3d((double)x + 0.5, (double)(y + 1), (double)z + 0.5);
            }
            case DOWN: {
                return new Vec3d((double)x + 0.5, (double)y, (double)z + 0.5);
            }
            case NORTH: {
                return new Vec3d((double)x + 0.5, (double)y + 0.5, (double)z);
            }
            case SOUTH: {
                return new Vec3d((double)x + 0.5, (double)y + 0.5, (double)(z + 1));
            }
            case WEST: {
                return new Vec3d((double)x, (double)y + 0.5, (double)z);
            }
            case EAST: {
                return new Vec3d((double)(x + 1), (double)y + 0.5, (double)(z + 1));
            }
        }
        return new Vec3d((double)x, (double)y, (double)z);
    }

    public static HitPart getHitPart(EnumFacing originalSide, EnumFacing playerFacingH, BlockPos pos, Vec3d hitVec) {
        Vec3d positions = PositionUtils.getHitPartPositions(originalSide, playerFacingH, pos, hitVec);
        double posH = positions.field_72450_a;
        double posV = positions.field_72448_b;
        double offH = Math.abs(posH - 0.5);
        double offV = Math.abs(posV - 0.5);
        if (offH > 0.25 || offV > 0.25) {
            if (offH > offV) {
                return posH < 0.5 ? HitPart.LEFT : HitPart.RIGHT;
            }
            return posV < 0.5 ? HitPart.BOTTOM : HitPart.TOP;
        }
        return HitPart.CENTER;
    }

    private static Vec3d getHitPartPositions(EnumFacing originalSide, EnumFacing playerFacingH, BlockPos pos, Vec3d hitVec) {
        double x = hitVec.field_72450_a - (double)pos.func_177958_n();
        double y = hitVec.field_72448_b - (double)pos.func_177956_o();
        double z = hitVec.field_72449_c - (double)pos.func_177952_p();
        double posH = 0.0;
        double posV = 0.0;
        switch (originalSide) {
            case UP: 
            case DOWN: {
                switch (playerFacingH) {
                    case NORTH: {
                        posH = x;
                        posV = 1.0 - z;
                        break;
                    }
                    case SOUTH: {
                        posH = 1.0 - x;
                        posV = z;
                        break;
                    }
                    case WEST: {
                        posH = 1.0 - z;
                        posV = 1.0 - x;
                        break;
                    }
                    case EAST: {
                        posH = z;
                        posV = x;
                        break;
                    }
                }
                if (originalSide != EnumFacing.DOWN) break;
                posV = 1.0 - posV;
                break;
            }
            case SOUTH: 
            case NORTH: {
                posH = originalSide.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? x : 1.0 - x;
                posV = y;
                break;
            }
            case EAST: 
            case WEST: {
                posH = originalSide.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? z : 1.0 - z;
                posV = y;
            }
        }
        return new Vec3d(posH, posV, 0.0);
    }

    public static EnumFacing getTargetedDirection(EnumFacing side, EnumFacing playerFacingH, BlockPos pos, Vec3d hitVec) {
        Vec3d positions = PositionUtils.getHitPartPositions(side, playerFacingH, pos, hitVec);
        double posH = positions.field_72450_a;
        double posV = positions.field_72448_b;
        double offH = Math.abs(posH - 0.5);
        double offV = Math.abs(posV - 0.5);
        if (offH > 0.25 || offV > 0.25) {
            if (side.func_176740_k() == EnumFacing.Axis.Y) {
                if (offH > offV) {
                    return posH < 0.5 ? playerFacingH.func_176735_f() : playerFacingH.func_176746_e();
                }
                if (side == EnumFacing.DOWN) {
                    return posV > 0.5 ? playerFacingH.func_176734_d() : playerFacingH;
                }
                return posV < 0.5 ? playerFacingH.func_176734_d() : playerFacingH;
            }
            if (offH > offV) {
                return posH < 0.5 ? side.func_176746_e() : side.func_176735_f();
            }
            return posV < 0.5 ? EnumFacing.DOWN : EnumFacing.UP;
        }
        return side;
    }

    public static enum CoordinateType {
        X,
        Y,
        Z;

    }

    public static enum HitPart {
        CENTER,
        LEFT,
        RIGHT,
        BOTTOM,
        TOP;

    }
}

