/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class NBTUtils {
    public static NBTTagCompound createBlockPosTag(Vec3i pos) {
        return NBTUtils.writeBlockPosToTag(pos, new NBTTagCompound());
    }

    public static NBTTagCompound writeBlockPosToTag(Vec3i pos, NBTTagCompound tag) {
        tag.func_74768_a("x", pos.func_177958_n());
        tag.func_74768_a("y", pos.func_177956_o());
        tag.func_74768_a("z", pos.func_177952_p());
        return tag;
    }

    @Nullable
    public static BlockPos readBlockPos(@Nullable NBTTagCompound tag) {
        if (tag != null && tag.func_150297_b("x", 3) && tag.func_150297_b("y", 3) && tag.func_150297_b("z", 3)) {
            return new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
        }
        return null;
    }

    public static NBTTagCompound writeVec3dToTag(Vec3d vec, NBTTagCompound tag) {
        tag.func_74780_a("dx", vec.field_72450_a);
        tag.func_74780_a("dy", vec.field_72448_b);
        tag.func_74780_a("dz", vec.field_72449_c);
        return tag;
    }

    public static NBTTagCompound writeEntityPositionToTag(Vec3d pos, NBTTagCompound tag) {
        NBTTagList posList = new NBTTagList();
        posList.func_74742_a((NBTBase)new NBTTagDouble(pos.field_72450_a));
        posList.func_74742_a((NBTBase)new NBTTagDouble(pos.field_72448_b));
        posList.func_74742_a((NBTBase)new NBTTagDouble(pos.field_72449_c));
        tag.func_74782_a("Pos", (NBTBase)posList);
        return tag;
    }

    @Nullable
    public static Vec3d readVec3d(@Nullable NBTTagCompound tag) {
        if (tag != null && tag.func_150297_b("dx", 6) && tag.func_150297_b("dy", 6) && tag.func_150297_b("dz", 6)) {
            return new Vec3d(tag.func_74769_h("dx"), tag.func_74769_h("dy"), tag.func_74769_h("dz"));
        }
        return null;
    }

    @Nullable
    public static Vec3d readEntityPositionFromTag(@Nullable NBTTagCompound tag) {
        NBTTagList tagList;
        if (tag != null && tag.func_150297_b("Pos", 9) && (tagList = tag.func_150295_c("Pos", 6)).func_150303_d() == 6 && tagList.func_74745_c() == 3) {
            return new Vec3d(tagList.func_150309_d(0), tagList.func_150309_d(1), tagList.func_150309_d(2));
        }
        return null;
    }
}

