/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fi.dy.masa.malilib.MaLiLib;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class JsonUtils {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    @Nullable
    public static JsonObject getNestedObject(JsonObject parent, String key, boolean create) {
        if (!parent.has(key) || !parent.get(key).isJsonObject()) {
            if (!create) {
                return null;
            }
            JsonObject obj = new JsonObject();
            parent.add(key, (JsonElement)obj);
            return obj;
        }
        return parent.get(key).getAsJsonObject();
    }

    public static boolean hasBoolean(JsonObject obj, String name) {
        JsonElement el = obj.get(name);
        if (el != null && el.isJsonPrimitive()) {
            try {
                el.getAsBoolean();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean hasInteger(JsonObject obj, String name) {
        JsonElement el = obj.get(name);
        if (el != null && el.isJsonPrimitive()) {
            try {
                el.getAsInt();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean hasLong(JsonObject obj, String name) {
        JsonElement el = obj.get(name);
        if (el != null && el.isJsonPrimitive()) {
            try {
                el.getAsLong();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean hasFloat(JsonObject obj, String name) {
        JsonElement el = obj.get(name);
        if (el != null && el.isJsonPrimitive()) {
            try {
                el.getAsFloat();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean hasDouble(JsonObject obj, String name) {
        JsonElement el = obj.get(name);
        if (el != null && el.isJsonPrimitive()) {
            try {
                el.getAsDouble();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean hasString(JsonObject obj, String name) {
        JsonElement el = obj.get(name);
        if (el != null && el.isJsonPrimitive()) {
            try {
                el.getAsString();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean hasObject(JsonObject obj, String name) {
        JsonElement el = obj.get(name);
        return el != null && el.isJsonObject();
    }

    public static boolean hasArray(JsonObject obj, String name) {
        JsonElement el = obj.get(name);
        return el != null && el.isJsonArray();
    }

    public static boolean getBooleanOrDefault(JsonObject obj, String name, boolean defaultValue) {
        if (obj.has(name) && obj.get(name).isJsonPrimitive()) {
            try {
                return obj.get(name).getAsBoolean();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static int getIntegerOrDefault(JsonObject obj, String name, int defaultValue) {
        if (obj.has(name) && obj.get(name).isJsonPrimitive()) {
            try {
                return obj.get(name).getAsInt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static long getLongOrDefault(JsonObject obj, String name, long defaultValue) {
        if (obj.has(name) && obj.get(name).isJsonPrimitive()) {
            try {
                return obj.get(name).getAsLong();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static float getFloatOrDefault(JsonObject obj, String name, float defaultValue) {
        if (obj.has(name) && obj.get(name).isJsonPrimitive()) {
            try {
                return obj.get(name).getAsFloat();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static double getDoubleOrDefault(JsonObject obj, String name, double defaultValue) {
        if (obj.has(name) && obj.get(name).isJsonPrimitive()) {
            try {
                return obj.get(name).getAsDouble();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static String getStringOrDefault(JsonObject obj, String name, String defaultValue) {
        if (obj.has(name) && obj.get(name).isJsonPrimitive()) {
            try {
                return obj.get(name).getAsString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static boolean getBoolean(JsonObject obj, String name) {
        return JsonUtils.getBooleanOrDefault(obj, name, false);
    }

    public static int getInteger(JsonObject obj, String name) {
        return JsonUtils.getIntegerOrDefault(obj, name, 0);
    }

    public static long getLong(JsonObject obj, String name) {
        return JsonUtils.getLongOrDefault(obj, name, 0L);
    }

    public static float getFloat(JsonObject obj, String name) {
        return JsonUtils.getFloatOrDefault(obj, name, 0.0f);
    }

    public static double getDouble(JsonObject obj, String name) {
        return JsonUtils.getDoubleOrDefault(obj, name, 0.0);
    }

    @Nullable
    public static String getString(JsonObject obj, String name) {
        return JsonUtils.getStringOrDefault(obj, name, null);
    }

    public static boolean hasBlockPos(JsonObject obj, String name) {
        return JsonUtils.blockPosFromJson(obj, name) != null;
    }

    public static JsonArray blockPosToJson(BlockPos pos) {
        JsonArray arr = new JsonArray();
        arr.add((Number)pos.func_177958_n());
        arr.add((Number)pos.func_177956_o());
        arr.add((Number)pos.func_177952_p());
        return arr;
    }

    @Nullable
    public static BlockPos blockPosFromJson(JsonObject obj, String name) {
        JsonArray arr;
        if (JsonUtils.hasArray(obj, name) && (arr = obj.getAsJsonArray(name)).size() == 3) {
            try {
                return new BlockPos(arr.get(0).getAsInt(), arr.get(1).getAsInt(), arr.get(2).getAsInt());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean hasVec3d(JsonObject obj, String name) {
        return JsonUtils.vec3dFromJson(obj, name) != null;
    }

    public static JsonArray vec3dToJson(Vec3d vec) {
        JsonArray arr = new JsonArray();
        arr.add((Number)vec.field_72450_a);
        arr.add((Number)vec.field_72448_b);
        arr.add((Number)vec.field_72449_c);
        return arr;
    }

    @Nullable
    public static Vec3d vec3dFromJson(JsonObject obj, String name) {
        JsonArray arr;
        if (JsonUtils.hasArray(obj, name) && (arr = obj.getAsJsonArray(name)).size() == 3) {
            try {
                return new Vec3d(arr.get(0).getAsDouble(), arr.get(1).getAsDouble(), arr.get(2).getAsDouble());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Nonnull
    public static JsonObject deepCopy(@Nonnull JsonObject jsonObject) {
        JsonObject result = new JsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            result.add((String)entry.getKey(), JsonUtils.deepCopy((JsonElement)entry.getValue()));
        }
        return result;
    }

    @Nonnull
    public static JsonArray deepCopy(@Nonnull JsonArray jsonArray) {
        JsonArray result = new JsonArray();
        for (JsonElement e : jsonArray) {
            result.add(JsonUtils.deepCopy(e));
        }
        return result;
    }

    @Nonnull
    public static JsonElement deepCopy(@Nonnull JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive() || jsonElement.isJsonNull()) {
            return jsonElement;
        }
        if (jsonElement.isJsonObject()) {
            return JsonUtils.deepCopy(jsonElement.getAsJsonObject());
        }
        if (jsonElement.isJsonArray()) {
            return JsonUtils.deepCopy(jsonElement.getAsJsonArray());
        }
        throw new UnsupportedOperationException("Unsupported element: " + jsonElement);
    }

    @Nullable
    public static JsonElement parseJsonFile(File file) {
        if (file != null && file.exists() && file.isFile() && file.canRead()) {
            String fileName = file.getAbsolutePath();
            try {
                JsonParser parser = new JsonParser();
                FileReader reader = new FileReader(file);
                JsonElement element = parser.parse((Reader)reader);
                reader.close();
                return element;
            }
            catch (Exception e) {
                MaLiLib.logger.error("Failed to parse the JSON file '{}'", (Object)fileName, (Object)e);
            }
        }
        return null;
    }

    public static boolean writeJsonToFile(JsonElement root, File file) {
        return JsonUtils.writeJsonToFile(GSON, root, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeJsonToFile(Gson gson, JsonElement root, File file) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            writer.write(gson.toJson(root));
            writer.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            MaLiLib.logger.warn("Failed to write JSON data to file '{}'", (Object)file.getAbsolutePath(), (Object)e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception e) {
                MaLiLib.logger.warn("Failed to close JSON file", (Throwable)e);
            }
        }
        return false;
    }
}

