/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import fi.dy.masa.malilib.util.ItemType;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemShulkerBox;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;

public class InventoryUtils {
    private static final NonNullList<ItemStack> EMPTY_LIST = NonNullList.func_191196_a();

    public static boolean areStacksEqual(ItemStack stack1, ItemStack stack2) {
        return ItemStack.func_179545_c((ItemStack)stack1, (ItemStack)stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean areStacksEqualIgnoreDurability(ItemStack stack1, ItemStack stack2) {
        return ItemStack.func_185132_d((ItemStack)stack1, (ItemStack)stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static void swapSlots(Container container, int slotNum, int hotbarSlot) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71442_b.func_187098_a(container.field_75152_c, slotNum, hotbarSlot, ClickType.SWAP, (EntityPlayer)mc.field_71439_g);
    }

    public static boolean isRegularInventorySlot(int slotNumber, boolean allowOffhand) {
        return slotNumber > 8 && (allowOffhand || slotNumber < 45);
    }

    public static int findEmptySlotInPlayerInventory(Container containerPlayer, boolean allowOffhand, boolean reverse) {
        int startSlot = reverse ? containerPlayer.field_75151_b.size() - 1 : 0;
        int endSlot = reverse ? -1 : containerPlayer.field_75151_b.size();
        int increment = reverse ? -1 : 1;
        for (int slotNum = startSlot; slotNum != endSlot; slotNum += increment) {
            Slot slot = (Slot)containerPlayer.field_75151_b.get(slotNum);
            ItemStack stackSlot = slot.func_75211_c();
            if (!stackSlot.func_190926_b() || !InventoryUtils.isRegularInventorySlot(slot.field_75222_d, allowOffhand)) continue;
            return slot.field_75222_d;
        }
        return -1;
    }

    public static int findSlotWithItem(Container container, ItemStack stackReference, boolean reverse) {
        int startSlot = reverse ? container.field_75151_b.size() - 1 : 0;
        int endSlot = reverse ? -1 : container.field_75151_b.size();
        int increment = reverse ? -1 : 1;
        boolean isPlayerInv = container instanceof ContainerPlayer;
        for (int slotNum = startSlot; slotNum != endSlot; slotNum += increment) {
            Slot slot = (Slot)container.field_75151_b.get(slotNum);
            if (isPlayerInv && !InventoryUtils.isRegularInventorySlot(slot.field_75222_d, false) || !InventoryUtils.areStacksEqualIgnoreDurability(slot.func_75211_c(), stackReference)) continue;
            return slot.field_75222_d;
        }
        return -1;
    }

    public static boolean swapItemToMainHand(ItemStack stackReference, Minecraft mc) {
        EntityPlayerSP player = mc.field_71439_g;
        boolean isCreative = player.field_71075_bZ.field_75098_d;
        if (InventoryUtils.areStacksEqual(stackReference, player.func_184614_ca())) {
            return false;
        }
        if (isCreative) {
            player.field_71071_by.func_184434_a(stackReference);
            mc.field_71442_b.func_78761_a(player.func_184586_b(EnumHand.MAIN_HAND), 36 + player.field_71071_by.field_70461_c);
            return true;
        }
        int slot = InventoryUtils.findSlotWithItem(player.field_71069_bz, stackReference, true);
        if (slot != -1) {
            int currentHotbarSlot = player.field_71071_by.field_70461_c;
            mc.field_71442_b.func_187098_a(player.field_71069_bz.field_75152_c, slot, currentHotbarSlot, ClickType.SWAP, (EntityPlayer)mc.field_71439_g);
            return true;
        }
        return false;
    }

    public static boolean shulkerBoxHasItems(ItemStack stackShulkerBox) {
        NBTTagCompound tag;
        NBTTagCompound nbt = stackShulkerBox.func_77978_p();
        if (nbt != null && nbt.func_150297_b("BlockEntityTag", 10) && (tag = nbt.func_74775_l("BlockEntityTag")).func_150297_b("Items", 9)) {
            NBTTagList tagList = tag.func_150295_c("Items", 10);
            return tagList.func_74745_c() > 0;
        }
        return false;
    }

    public static NonNullList<ItemStack> getStoredItems(ItemStack stackIn) {
        NBTTagCompound tagBlockEntity;
        NBTTagCompound nbt = stackIn.func_77978_p();
        if (nbt != null && nbt.func_150297_b("BlockEntityTag", 10) && (tagBlockEntity = nbt.func_74775_l("BlockEntityTag")).func_150297_b("Items", 9)) {
            NonNullList items = NonNullList.func_191196_a();
            NBTTagList tagList = tagBlockEntity.func_150295_c("Items", 10);
            int count = tagList.func_74745_c();
            for (int i = 0; i < count; ++i) {
                ItemStack stack = new ItemStack(tagList.func_150305_b(i));
                if (stack.func_190926_b()) continue;
                items.add((Object)stack);
            }
            return items;
        }
        return NonNullList.func_191196_a();
    }

    public static NonNullList<ItemStack> getStoredItems(ItemStack stackIn, int slotCount) {
        NBTTagCompound tagBlockEntity;
        NBTTagCompound nbt = stackIn.func_77978_p();
        if (nbt != null && nbt.func_150297_b("BlockEntityTag", 10) && (tagBlockEntity = nbt.func_74775_l("BlockEntityTag")).func_150297_b("Items", 9)) {
            NBTTagList tagList = tagBlockEntity.func_150295_c("Items", 10);
            int count = tagList.func_74745_c();
            byte maxSlot = -1;
            if (slotCount <= 0) {
                for (int i = 0; i < count; ++i) {
                    NBTTagCompound tag = tagList.func_150305_b(i);
                    byte slot = tag.func_74771_c("Slot");
                    if (slot <= maxSlot) continue;
                    maxSlot = slot;
                }
                slotCount = maxSlot + 1;
            }
            NonNullList items = NonNullList.func_191197_a((int)slotCount, (Object)ItemStack.field_190927_a);
            for (int i = 0; i < count; ++i) {
                NBTTagCompound tag = tagList.func_150305_b(i);
                ItemStack stack = new ItemStack(tag);
                byte slot = tag.func_74771_c("Slot");
                if (slot < 0 || slot >= items.size() || stack.func_190926_b()) continue;
                items.set((int)slot, (Object)stack);
            }
            return items;
        }
        return EMPTY_LIST;
    }

    public static Object2IntOpenHashMap<ItemType> getStoredItemCounts(ItemStack stackShulkerBox) {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        NonNullList<ItemStack> items = InventoryUtils.getStoredItems(stackShulkerBox);
        for (int slot = 0; slot < items.size(); ++slot) {
            ItemStack stack = (ItemStack)items.get(slot);
            if (stack.func_190926_b()) continue;
            map.addTo((Object)new ItemType(stack), stack.func_190916_E());
        }
        return map;
    }

    public static Object2IntOpenHashMap<ItemType> getInventoryItemCounts(IInventory inv) {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        int slots = inv.func_70302_i_();
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack stack = inv.func_70301_a(slot);
            if (stack.func_190926_b()) continue;
            map.addTo((Object)new ItemType(stack, false, true), stack.func_190916_E());
            if (!(stack.func_77973_b() instanceof ItemShulkerBox) || !InventoryUtils.shulkerBoxHasItems(stack)) continue;
            Object2IntOpenHashMap<ItemType> boxCounts = InventoryUtils.getStoredItemCounts(stack);
            for (ItemType type : boxCounts.keySet()) {
                map.addTo((Object)type, boxCounts.getInt((Object)type));
            }
        }
        return map;
    }

    public static IInventory getAsInventory(NonNullList<ItemStack> items) {
        InventoryBasic inv = new InventoryBasic("", false, items.size());
        for (int slot = 0; slot < items.size(); ++slot) {
            inv.func_70299_a(slot, (ItemStack)items.get(slot));
        }
        return inv;
    }
}

