/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class IntBoundingBox {
    public final int minX;
    public final int minY;
    public final int minZ;
    public final int maxX;
    public final int maxY;
    public final int maxZ;

    public IntBoundingBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public boolean containsPos(Vec3i pos) {
        return pos.func_177958_n() >= this.minX && pos.func_177958_n() <= this.maxX && pos.func_177952_p() >= this.minZ && pos.func_177952_p() <= this.maxZ && pos.func_177956_o() >= this.minY && pos.func_177956_o() <= this.maxY;
    }

    public boolean intersects(IntBoundingBox box) {
        return this.maxX >= box.minX && this.minX <= box.maxX && this.maxZ >= box.minZ && this.minZ <= box.maxZ && this.maxY >= box.minY && this.minY <= box.maxY;
    }

    public StructureBoundingBox toVanillaBox() {
        return new StructureBoundingBox(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public NBTTagIntArray toNBTIntArray() {
        return new NBTTagIntArray(new int[]{this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ});
    }

    public static IntBoundingBox fromVanillaBox(StructureBoundingBox box) {
        return IntBoundingBox.createProper(box.field_78897_a, box.field_78895_b, box.field_78896_c, box.field_78893_d, box.field_78894_e, box.field_78892_f);
    }

    public static IntBoundingBox createProper(int x1, int y1, int z1, int x2, int y2, int z2) {
        return new IntBoundingBox(Math.min(x1, x2), Math.min(y1, y2), Math.min(z1, z2), Math.max(x1, x2), Math.max(y1, y2), Math.max(z1, z2));
    }

    public static IntBoundingBox fromArray(int[] coords) {
        if (coords.length == 6) {
            return new IntBoundingBox(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
        }
        return new IntBoundingBox(0, 0, 0, 0, 0, 0);
    }
}

