/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import fi.dy.masa.malilib.gui.GuiBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;

public class BlockUtils {
    @Nullable
    public static PropertyDirection getFirstDirectionProperty(IBlockState state) {
        for (IProperty prop : state.func_177228_b().keySet()) {
            if (!(prop instanceof PropertyDirection)) continue;
            return (PropertyDirection)prop;
        }
        return null;
    }

    @Nullable
    public static EnumFacing getFirstPropertyFacingValue(IBlockState state) {
        PropertyDirection prop = BlockUtils.getFirstDirectionProperty(state);
        return prop != null ? (EnumFacing)state.func_177229_b((IProperty)prop) : null;
    }

    public static List<String> getFormattedBlockStateProperties(IBlockState state) {
        return BlockUtils.getFormattedBlockStateProperties(state, ": ");
    }

    public static List<String> getFormattedBlockStateProperties(IBlockState state, String separator) {
        if (state.func_177228_b().size() > 0) {
            ArrayList<String> lines = new ArrayList<String>();
            for (Map.Entry entry : state.func_177228_b().entrySet()) {
                IProperty key = (IProperty)entry.getKey();
                Comparable val = (Comparable)entry.getValue();
                if (key instanceof PropertyBool) {
                    String pre = val.equals(Boolean.TRUE) ? GuiBase.TXT_GREEN : GuiBase.TXT_RED;
                    lines.add(key.func_177701_a() + separator + pre + val.toString());
                    continue;
                }
                if (key instanceof PropertyDirection) {
                    lines.add(key.func_177701_a() + separator + GuiBase.TXT_GOLD + val.toString());
                    continue;
                }
                if (key instanceof PropertyInteger) {
                    lines.add(key.func_177701_a() + separator + GuiBase.TXT_AQUA + val.toString());
                    continue;
                }
                lines.add(key.func_177701_a() + separator + val.toString());
            }
            return lines;
        }
        return Collections.emptyList();
    }
}

