/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.render;

import com.google.common.collect.Queues;
import fi.dy.masa.malilib.config.values.HudAlignment;
import fi.dy.masa.malilib.gui.widgets.WidgetToast;
import java.util.ArrayList;
import java.util.Deque;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.math.MathHelper;

public class ToastRenderer {
    public static final ToastRenderer INSTANCE = new ToastRenderer();
    protected final Minecraft mc;
    protected final ArrayList<ArrayList<ToastInstance>> activeToasts = new ArrayList();
    protected final ArrayList<Deque<WidgetToast>> toastQueue = new ArrayList();
    protected int maxToasts = 5;

    protected ToastRenderer() {
        this.mc = Minecraft.func_71410_x();
        for (int i = 0; i < HudAlignment.values().length; ++i) {
            this.activeToasts.add(new ArrayList());
            this.toastQueue.add(Queues.newArrayDeque());
        }
    }

    public void addToast(HudAlignment alignment, WidgetToast toast) {
        this.toastQueue.get(alignment.ordinal()).add(toast);
    }

    @Nullable
    public <T extends WidgetToast> T getToast(HudAlignment alignment, Class<? extends T> clazz) {
        for (ToastInstance toastInstance : this.activeToasts.get(alignment.ordinal())) {
            if (!clazz.isAssignableFrom(toastInstance.getToast().getClass())) continue;
            return (T)toastInstance.getToast();
        }
        for (Deque deque : this.toastQueue) {
            for (WidgetToast toast : deque) {
                if (!clazz.isAssignableFrom(toast.getClass())) continue;
                return (T)toast;
            }
        }
        return (T)((WidgetToast)null);
    }

    public void render() {
        if (!this.mc.field_71474_y.field_74319_N) {
            ScaledResolution res = new ScaledResolution(this.mc);
            RenderHelper.func_74518_a();
            for (HudAlignment alignment : HudAlignment.values()) {
                Deque<WidgetToast> deque;
                ArrayList<ToastInstance> list = this.activeToasts.get(alignment.ordinal());
                if (!list.isEmpty()) {
                    int y = this.getBaseY(alignment, res, list);
                    for (int i = 0; i < list.size(); ++i) {
                        ToastInstance instance = list.get(i);
                        y += instance.render(res, y);
                        if (!instance.hasExpired()) continue;
                        list.remove(i--);
                    }
                }
                if ((deque = this.toastQueue.get(alignment.ordinal())).isEmpty()) continue;
                int countToAdd = Math.min(deque.size(), this.maxToasts - list.size());
                for (int i = 0; i < countToAdd; ++i) {
                    list.add(new ToastInstance(alignment, deque.removeFirst()));
                }
            }
        }
    }

    protected int getBaseY(HudAlignment alignment, ScaledResolution res, ArrayList<ToastInstance> toasts) {
        switch (alignment) {
            case TOP_LEFT: 
            case TOP_RIGHT: {
                return 0;
            }
            case BOTTOM_LEFT: 
            case BOTTOM_RIGHT: {
                return res.func_78328_b() - this.getTotalToastHeight(toasts);
            }
            case CENTER: {
                return res.func_78328_b() / 2 - this.getTotalToastHeight(toasts) / 2;
            }
        }
        return 0;
    }

    protected int getTotalToastHeight(ArrayList<ToastInstance> list) {
        int height = 0;
        for (int i = 0; i < list.size(); ++i) {
            height += list.get(i).getHeight();
        }
        return height;
    }

    public static class ToastInstance {
        protected final WidgetToast toast;
        protected final HudAlignment alignment;
        protected long animationStartTime;
        protected long fullyVisibleStartTime;
        protected boolean expired;
        protected long animationTime;
        protected long currentTime;

        protected ToastInstance(HudAlignment alignment, WidgetToast toast) {
            this.alignment = alignment;
            this.toast = toast;
            this.animationTime = 300L;
            this.animationStartTime = -1L;
            this.fullyVisibleStartTime = -1L;
            this.expired = false;
        }

        public WidgetToast getToast() {
            return this.toast;
        }

        protected float getVisibility(long currentTime) {
            float f = MathHelper.func_76131_a((float)((float)(currentTime - this.animationStartTime) / (float)this.animationTime), (float)0.0f, (float)1.0f);
            f *= f;
            return this.expired ? 1.0f - f : f;
        }

        public int getHeight() {
            return this.toast.getHeight();
        }

        public int render(ScaledResolution res, int y) {
            long currentTime;
            int x = 0;
            int width = this.toast.getWidth();
            int height = this.toast.getHeight();
            int animationOffset = width;
            switch (this.alignment) {
                case TOP_RIGHT: 
                case BOTTOM_RIGHT: {
                    x = res.func_78326_a() - this.toast.getWidth();
                    break;
                }
                case CENTER: {
                    x = res.func_78326_a() / 2 - this.toast.getWidth() / 2;
                    break;
                }
                case TOP_LEFT: 
                case BOTTOM_LEFT: {
                    animationOffset = -animationOffset;
                    break;
                }
            }
            this.currentTime = currentTime = Minecraft.func_71386_F();
            if (this.animationStartTime == -1L) {
                this.animationStartTime = currentTime;
            }
            if (!this.expired && currentTime - this.animationStartTime <= this.animationTime) {
                this.fullyVisibleStartTime = currentTime;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)animationOffset * (1.0f - this.getVisibility(currentTime))), (float)0.0f, (float)500.0f);
            this.toast.setPosition(x, y);
            this.toast.render(x, y);
            GlStateManager.func_179121_F();
            boolean expired = this.toast.hasExpired();
            if (expired != this.expired) {
                this.animationStartTime = currentTime - (long)((1.0f - this.getVisibility(currentTime)) * (float)this.animationTime);
                this.expired = expired;
            }
            return height;
        }

        public boolean hasExpired() {
            return this.expired && this.currentTime - this.animationStartTime > this.animationTime;
        }
    }
}

